/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.Arrays;
import org.apache.uima.resource.metadata.impl.MetaDataObjectSerializer_plain;
import org.apache.uima.util.XMLSerializer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MetaDataObjectSerializer_indent
extends MetaDataObjectSerializer_plain {
    private static String lineEnd = System.getProperty("line.separator");
    private static final char[] blanks = new char[80];
    private static final char[] nlca;
    private final XMLSerializer.CharacterValidatingContentHandler cc;

    private static boolean hasElementChildNode(Node n) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!(c instanceof Element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhitespaceText(Node n) {
        if (!(n instanceof Text)) {
            return false;
        }
        Text t = (Text)n;
        String s = t.getData();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isCoIw(Node n) {
        return n != null && (n instanceof Comment || MetaDataObjectSerializer_indent.isWhitespaceText(n));
    }

    public MetaDataObjectSerializer_indent(XMLSerializer.CharacterValidatingContentHandler cc) {
        super(cc);
        this.cc = cc;
    }

    @Override
    public void saveAndAddNodeStore(Node infoset) {
        this.cc.setLastOutputNode(infoset);
        this.addNodeStore();
    }

    @Override
    public void deleteNodeStore() {
        this.cc.lastOutputNodeClearLevel();
    }

    @Override
    public void addNodeStore() {
        this.cc.lastOutputNodeAddLevel();
    }

    @Override
    public void outputStartElement(Node node, String aNamespace, String localname, String qname, Attributes attributes) throws SAXException {
        if (null == localname) {
            return;
        }
        this.maybeOutputCoIwBeforeStart(node);
        this.cc.startElement(aNamespace, localname, qname, attributes);
        this.maybeOutputCoIwAfterStart(node);
    }

    @Override
    public void outputEndElement(Node node, String aNamespace, String localname, String qname) throws SAXException {
        if (null == localname) {
            return;
        }
        this.maybeOutputCoIwBeforeEnd(node);
        this.cc.endElement(aNamespace, localname, qname);
        this.maybeOutputCoIwAfterEnd(node);
    }

    @Override
    public void outputStartElementForArrayElement(Node node, String nameSpace, String localName, String qName, Attributes attributes) throws SAXException {
        this.outputStartElement(node, nameSpace, localName, qName, attributes);
    }

    private void maybeOutputCoIwBeforeStart(Node node) throws SAXException {
        int indent = this.cc.getIndent();
        if (null == node) {
            if (!this.cc.prevNL) {
                this.outputNL();
                this.outputIndent(indent);
            }
            return;
        }
        if (node.getParentNode() instanceof Document) {
            this.outputNL();
            for (Node c = node.getParentNode().getFirstChild(); c != node; c = c.getNextSibling()) {
                if (!(c instanceof Comment)) continue;
                this.outputCoIw(c);
                this.outputNL();
            }
            return;
        }
        for (Node p = this.getFirstPrevCoIw(node); p != node; p = p.getNextSibling()) {
            this.outputCoIw(p);
        }
    }

    private void maybeOutputCoIwAfterStart(Node node) throws SAXException {
        this.cc.nextIndent();
        if (null == node || !MetaDataObjectSerializer_indent.hasElementChildNode(node)) {
            this.cc.prevNL = false;
            return;
        }
        this.outputCoIwAfterElement(node.getFirstChild());
    }

    private void maybeOutputCoIwBeforeEnd(Node node) throws SAXException {
        int indent = this.cc.prevIndent();
        if (null == node || !MetaDataObjectSerializer_indent.hasElementChildNode(node)) {
            if (null == node && this.cc.prevWasEndElement) {
                this.outputNL();
                this.outputIndent(indent);
            }
            return;
        }
        Node n = node.getLastChild();
        Node np = null;
        boolean newlineFound = false;
        for (Node p = n; p != null && !(p instanceof Element) && p.getNodeType() != 2; p = p.getPreviousSibling()) {
            if (this.hasNewline(p)) {
                newlineFound = true;
            }
            np = p;
        }
        if (!newlineFound) {
            return;
        }
        for (Node o = this.skipUpToFirstAfterNL(np); o != null; o = o.getNextSibling()) {
            this.outputCoIw(o);
        }
    }

    private void maybeOutputCoIwAfterEnd(Node node) throws SAXException {
        if (null == node) {
            return;
        }
        this.outputCoIwAfterElement(node.getNextSibling());
    }

    private void outputCoIwAfterElement(Node startNode) throws DOMException, SAXException {
        if (null != startNode) {
            Node n;
            Node lastNode = null;
            for (n = startNode; n != null && (n instanceof Comment || n instanceof Text); n = n.getNextSibling()) {
                if (n instanceof Text && !MetaDataObjectSerializer_indent.isWhitespaceText(n)) {
                    return;
                }
                lastNode = n;
            }
            if (null == lastNode) {
                return;
            }
            n = startNode;
            while (true) {
                this.outputCoIw(n);
                if (this.hasNewline(n)) {
                    this.cc.prevNL = true;
                    return;
                }
                if (n == lastNode) {
                    return;
                }
                n = n.getNextSibling();
            }
        }
        this.cc.prevNL = false;
    }

    private Node getFirstPrevCoIw(Node original) {
        boolean newlineFound = false;
        Node p = original;
        Node r = p.getPreviousSibling();
        while (MetaDataObjectSerializer_indent.isCoIw(r)) {
            if (this.hasNewline(r)) {
                newlineFound = true;
            }
            p = r;
            r = r.getPreviousSibling();
        }
        if (!newlineFound) {
            return original;
        }
        return this.skipUpToFirstAfterNL(p);
    }

    private Node skipUpToFirstAfterNL(Node n) {
        while (!this.hasNewline(n)) {
            n = n.getNextSibling();
        }
        return n.getNextSibling();
    }

    private boolean hasNewline(Node n) {
        if (n instanceof Comment) {
            return false;
        }
        CharacterData c = (CharacterData)n;
        return -1 != c.getData().indexOf(10);
    }

    @Override
    public Node findMatchingSubElement(String elementName) {
        if (null == elementName) {
            return null;
        }
        Node lastOutput = this.cc.getLastOutputNode();
        Node n = null;
        if (lastOutput == null) {
            lastOutput = this.cc.getLastOutputNodePrevLevel();
            if (lastOutput == null) {
                return null;
            }
            n = lastOutput.getFirstChild();
        } else {
            n = lastOutput.getNextSibling();
        }
        while (n != null) {
            if (n instanceof Element && elementName.equals(((Element)n).getTagName())) {
                this.cc.setLastOutputNode(n);
                return n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    private void outputCoIw(Node p) throws DOMException, SAXException {
        if (p instanceof Comment) {
            String cmt = ((Comment)p).getData();
            if (!lineEnd.equals("\n")) {
                cmt = cmt.replace("\n", lineEnd);
            }
            this.cc.comment(cmt.toCharArray(), 0, cmt.length());
        } else {
            String s = p.getTextContent();
            this.cc.characters(s.toCharArray(), 0, s.length());
        }
    }

    private void outputIndent(int indent) throws SAXException {
        this.cc.ignorableWhitespace(blanks, 0, Math.min(80, indent));
    }

    private void outputNL() throws SAXException {
        this.cc.ignorableWhitespace(nlca, 0, 1);
        this.cc.prevNL = true;
    }

    static {
        Arrays.fill(blanks, ' ');
        nlca = new char[]{'\n'};
    }
}

