/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import java.util.List;
import java.util.Map;
import org.json.simple.JSONValue;

public final class JsonExtractionException
extends Exception {
    public JsonExtractionException(String path, String message, Object value) {
        super((path == null ? "" : path + ": ") + message + (value == null ? "" : ": " + JsonExtractionException.summarizeValue(value)));
    }

    private static String summarizeValue(Object value) {
        if (value instanceof Map) {
            StringBuilder buf = new StringBuilder();
            Map map = (Map)value;
            buf.append("{");
            String sep = "";
            for (Map.Entry entry : map.entrySet()) {
                buf.append(sep);
                sep = ", ";
                buf.append(JSONValue.toJSONString(entry.getKey()));
                buf.append(" = ");
                buf.append("...");
            }
            buf.append("}");
            return buf.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return "[]";
            }
            if (list.size() == 1) {
                return "[" + JsonExtractionException.summarizeValue(list.get(0)) + "]";
            }
            return "[" + JsonExtractionException.summarizeValue(list.get(0)) + ", ...] (" + list.size() + " elements)";
        }
        return JSONValue.toJSONString((Object)value);
    }
}

