/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.geoapi.temporal.Instant;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gml.GMLAdapter;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.xml.XmlUtilities;

@XmlType(name="TimeInstantType")
@XmlRootElement(name="TimeInstant")
public final class TimeInstant
extends GMLAdapter {
    @XmlElement
    public XMLGregorianCalendar timePosition;

    public TimeInstant() {
    }

    public TimeInstant(Instant instant) {
        this.timePosition = TimeInstant.toXML(instant);
    }

    static XMLGregorianCalendar toXML(Instant instant) {
        Date date;
        if (instant != null && (date = instant.getDate()) != null) {
            Context context = Context.current();
            try {
                XMLGregorianCalendar xMLGregorianCalendar = XmlUtilities.toXML(context, date);
                if (xMLGregorianCalendar != null) {
                    XmlUtilities.trimTime(xMLGregorianCalendar, false);
                    return xMLGregorianCalendar;
                }
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                Context.warningOccured(context, TimeInstant.class, "toXML", datatypeConfigurationException, true);
            }
        }
        return null;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.timePosition);
    }
}

