/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class DSAKeyValueResolver
extends KeyResolverSpi {
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        if (element == null) {
            return null;
        }
        Element element2 = null;
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "DSAKeyValue");
        if (bl) {
            element2 = XMLUtils.selectDsNode(element.getFirstChild(), "DSAKeyValue", 0);
        } else if (bl2) {
            element2 = element;
        }
        if (element2 == null) {
            return null;
        }
        try {
            DSAKeyValue dSAKeyValue = new DSAKeyValue(element2, string);
            PublicKey publicKey = dSAKeyValue.getPublicKey();
            return publicKey;
        }
        catch (XMLSecurityException xMLSecurityException) {
            return null;
        }
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

