/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.manifoldcf.elasticsearch.MCFAuthorizer;
import org.apache.manifoldcf.elasticsearch.MCFAuthorizerException;
import org.apache.manifoldcf.elasticsearch.MCFConfigurationParameters;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class MCFAuthorizerRestSearchAction
extends RestSearchAction {
    protected final MCFAuthorizer authorizer;

    @Inject
    public MCFAuthorizerRestSearchAction(Settings settings, RestController restController, Client client) {
        super(settings, restController, client);
        MCFConfigurationParameters conf = new MCFConfigurationParameters(settings);
        this.authorizer = new MCFAuthorizer(conf);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        SearchRequest searchRequest = this.parseSearchRequestMCF(request);
        searchRequest.listenerThreaded(false);
        client.search(searchRequest, (ActionListener)new RestStatusToXContentListener(channel));
    }

    protected SearchRequest parseSearchRequestMCF(RestRequest request) throws MCFAuthorizerException {
        SearchRequest searchRequest;
        if (request.param("u") != null) {
            String[] authenticatedUserNamesAndDomains = request.param("u").split(",");
            String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
            searchRequest = new SearchRequest(indices);
            boolean isTemplateRequest = request.path().endsWith("/template");
            if (request.hasContent() || request.hasParam("source")) {
                FilterBuilder authorizationFilter = this.authorizer.buildAuthorizationFilter(authenticatedUserNamesAndDomains);
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    JsonNode requestJSON = objectMapper.readTree(RestActions.getRestContent((RestRequest)request).toBytes());
                    if (isTemplateRequest) {
                        ObjectNode modifiedJSON = (ObjectNode)requestJSON;
                        ObjectNode innerJSON = (ObjectNode)requestJSON.findValue("template");
                        FilteredQueryBuilder filteredQueryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.wrapperQuery((String)innerJSON.findValue("query").toString()), (FilterBuilder)authorizationFilter);
                        modifiedJSON.replace("template", innerJSON.set("query", objectMapper.readTree(filteredQueryBuilder.buildAsBytes().toBytes())));
                        searchRequest.templateSource(modifiedJSON.toString());
                    } else {
                        FilteredQueryBuilder filteredQueryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.wrapperQuery((String)requestJSON.findValue("query").toString()), (FilterBuilder)authorizationFilter);
                        ObjectNode modifiedJSON = (ObjectNode)requestJSON;
                        modifiedJSON.set("query", objectMapper.readTree(filteredQueryBuilder.buildAsBytes().toBytes()));
                        searchRequest.source(modifiedJSON.toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new MCFAuthorizerException("JSON parser error");
                }
            }
            searchRequest.extraSource(this.parseSearchSourceMCF(request));
            searchRequest.searchType(request.param("search_type"));
            searchRequest.queryCache(request.paramAsBoolean("query_cache", (Boolean)null));
            String scroll = request.param("scroll");
            if (scroll != null) {
                searchRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)scroll, (TimeValue)null)));
            }
            searchRequest.types(Strings.splitStringByCommaToArray((String)request.param("type")));
            searchRequest.routing(request.param("routing"));
            searchRequest.preference(request.param("preference"));
            searchRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)searchRequest.indicesOptions()));
        } else {
            searchRequest = RestSearchAction.parseSearchRequest((RestRequest)request);
        }
        return searchRequest;
    }

    protected SearchSourceBuilder parseSearchSourceMCF(RestRequest request) throws MCFAuthorizerException {
        String var28;
        String var32;
        int var31;
        String var25;
        int suggestText;
        String[] var26;
        String var23;
        FetchSourceContext var22;
        String suggestField;
        String var21;
        int var20;
        SearchSourceBuilder searchSourceBuilder = null;
        String queryString = request.param("q");
        if (queryString != null) {
            String[] authenticatedUserNamesAndDomains = request.param("u").split(",");
            FilterBuilder authorizationFilter = this.authorizer.buildAuthorizationFilter(authenticatedUserNamesAndDomains);
            QueryStringQueryBuilder from = QueryBuilders.queryStringQuery((String)queryString);
            from.defaultField(request.param("df"));
            from.analyzer(request.param("analyzer"));
            from.analyzeWildcard(request.paramAsBoolean("analyze_wildcard", false));
            from.lowercaseExpandedTerms(request.paramAsBoolean("lowercase_expanded_terms", true));
            from.lenient(request.paramAsBoolean("lenient", (Boolean)null));
            String size = request.param("default_operator");
            if (size != null) {
                if ("OR".equals(size)) {
                    from.defaultOperator(QueryStringQueryBuilder.Operator.OR);
                } else {
                    if (!"AND".equals(size)) {
                        throw new ElasticsearchIllegalArgumentException("Unsupported defaultOperator [" + size + "], can either be [OR] or [AND]");
                    }
                    from.defaultOperator(QueryStringQueryBuilder.Operator.AND);
                }
            }
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)from, (FilterBuilder)authorizationFilter));
        } else if (!request.hasContent() && !request.hasParam("source")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            FilterBuilder authorizationFilter = this.authorizer.buildAuthorizationFilter(request.param("u"));
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)authorizationFilter));
        }
        int var19 = request.paramAsInt("from", -1);
        if (var19 != -1) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.from(var19);
        }
        if ((var20 = request.paramAsInt("size", -1)) != -1) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.size(var20);
        }
        if (request.hasParam("explain")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.explain(request.paramAsBoolean("explain", (Boolean)null));
        }
        if (request.hasParam("version")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.version(request.paramAsBoolean("version", (Boolean)null));
        }
        if (request.hasParam("timeout")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.timeout(request.paramAsTime("timeout", (TimeValue)null));
        }
        if (request.hasParam("terminate_after")) {
            int sField;
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            if ((sField = request.paramAsInt("terminate_after", 0)) < 0) {
                throw new ElasticsearchIllegalArgumentException("terminateAfter must be > 0");
            }
            if (sField > 0) {
                searchSourceBuilder.terminateAfter(sField);
            }
        }
        if ((var21 = request.param("fields")) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            if (!Strings.hasText((String)var21)) {
                searchSourceBuilder.noFields();
            } else {
                String[] fetchSourceContext = Strings.splitStringByCommaToArray((String)var21);
                if (fetchSourceContext != null) {
                    String[] sSorts = fetchSourceContext;
                    int sIndicesBoost = fetchSourceContext.length;
                    for (int sStats = 0; sStats < sIndicesBoost; ++sStats) {
                        suggestField = sSorts[sStats];
                        searchSourceBuilder.field(suggestField);
                    }
                }
            }
        }
        if ((var22 = FetchSourceContext.parseFromRestRequest((RestRequest)request)) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.fetchSource(var22);
        }
        if (request.hasParam("track_scores")) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if ((var23 = request.param("sort")) != null) {
            String[] var24;
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            var26 = var24 = Strings.splitStringByCommaToArray((String)var23);
            int var27 = var24.length;
            for (suggestText = 0; suggestText < var27; ++suggestText) {
                String suggestSize = var26[suggestText];
                int suggestMode = suggestSize.lastIndexOf(":");
                if (suggestMode != -1) {
                    String divisor = suggestSize.substring(0, suggestMode);
                    String indexName = suggestSize.substring(suggestMode + 1);
                    if ("asc".equals(indexName)) {
                        searchSourceBuilder.sort(divisor, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(indexName)) continue;
                    searchSourceBuilder.sort(divisor, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(suggestSize);
            }
        }
        if ((var25 = request.param("indices_boost")) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            String[] var29 = var26 = Strings.splitStringByCommaToArray((String)var25);
            suggestText = var26.length;
            for (var31 = 0; var31 < suggestText; ++var31) {
                var32 = var29[var31];
                int var33 = var32.indexOf(44);
                if (var33 == -1) {
                    throw new ElasticsearchIllegalArgumentException("Illegal index boost [" + var32 + "], no ','");
                }
                String indexName = var32.substring(0, var33);
                String sBoost = var32.substring(var33 + 1);
                try {
                    searchSourceBuilder.indexBoost(indexName, Float.parseFloat(sBoost));
                    continue;
                }
                catch (NumberFormatException var18) {
                    throw new ElasticsearchIllegalArgumentException("Illegal index boost [" + var32 + "], boost not a float number");
                }
            }
        }
        if ((var28 = request.param("stats")) != null) {
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            searchSourceBuilder.stats(Strings.splitStringByCommaToArray((String)var28));
        }
        if ((suggestField = request.param("suggest_field")) != null) {
            String var30 = request.param("suggest_text", queryString);
            var31 = request.paramAsInt("suggest_size", 5);
            if (searchSourceBuilder == null) {
                searchSourceBuilder = new SearchSourceBuilder();
            }
            var32 = request.param("suggest_mode");
            searchSourceBuilder.suggest().addSuggestion((SuggestBuilder.SuggestionBuilder)((TermSuggestionBuilder)((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion((String)suggestField).field(suggestField)).text(var30)).size(var31)).suggestMode(var32));
        }
        return searchSourceBuilder;
    }
}

