/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.ClassVisitor;
import de.thetaphi.forbiddenapis.asm.FieldVisitor;
import de.thetaphi.forbiddenapis.asm.MethodVisitor;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class ClassMetadata
implements Constants {
    private ClassReader reader;
    public final boolean isRuntimeClass;
    public final boolean isNonPortableRuntime;
    public final boolean isInterface;
    public final Set<Method> methods;
    public final Set<String> fields;
    public final Set<String> signaturePolymorphicMethods;
    public final String className;
    public final String superName;
    public final String[] interfaces;

    public ClassMetadata(ClassReader classReader, boolean isRuntimeClass, boolean withReader) {
        this.reader = withReader ? classReader : null;
        this.isRuntimeClass = isRuntimeClass;
        this.className = classReader.getClassName();
        this.superName = classReader.getSuperName();
        this.interfaces = classReader.getInterfaces();
        this.isInterface = (classReader.getAccess() & 0x200) != 0;
        final HashSet methods = new HashSet();
        final HashSet fields = new HashSet();
        final HashSet signaturePolymorphicMethods = new HashSet();
        classReader.accept(new ClassVisitor(589824){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Method m = new Method(name, desc);
                methods.add(m);
                if (ClassMetadata.this.className.startsWith("java/lang/invoke/") && (access & 0x80) != 0 && (access & 0x100) != 0 && Constants.SIGNATURE_POLYMORPHIC_DESCRIPTOR.equals(desc)) {
                    signaturePolymorphicMethods.add(name);
                }
                return null;
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                fields.add(name);
                return null;
            }
        }, 7);
        this.methods = ClassMetadata.createSet(methods);
        this.fields = ClassMetadata.createSet(fields);
        this.signaturePolymorphicMethods = ClassMetadata.createSet(signaturePolymorphicMethods);
        this.isNonPortableRuntime = this.determineNonPortableRuntime();
    }

    public ClassMetadata(Class<?> clazz, boolean isRuntimeClass) {
        this.reader = null;
        this.isRuntimeClass = isRuntimeClass;
        this.className = Type.getType(clazz).getInternalName();
        Class<?> superclazz = clazz.getSuperclass();
        this.superName = superclazz == null ? null : Type.getType(superclazz).getInternalName();
        Class<?>[] interfClasses = clazz.getInterfaces();
        this.interfaces = new String[interfClasses.length];
        for (int i = 0; i < interfClasses.length; ++i) {
            this.interfaces[i] = Type.getType(interfClasses[i]).getInternalName();
        }
        this.isInterface = clazz.isInterface();
        HashSet<Method> methods = new HashSet<Method>();
        HashSet<String> fields = new HashSet<String>();
        HashSet<String> signaturePolymorphicMethods = new HashSet<String>();
        for (java.lang.reflect.Method method : clazz.getDeclaredMethods()) {
            methods.add(Method.getMethod(method));
            if (!this.className.startsWith("java/lang/invoke/") || !method.isVarArgs() || (method.getModifiers() & 0x100) == 0 || !SIGNATURE_POLYMORPHIC_DESCRIPTOR.equals(Type.getMethodDescriptor(method))) continue;
            signaturePolymorphicMethods.add(method.getName());
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            methods.add(Method.getMethod(executable));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            fields.add(((Field)accessibleObject).getName());
        }
        this.methods = ClassMetadata.createSet(methods);
        this.fields = ClassMetadata.createSet(fields);
        this.signaturePolymorphicMethods = ClassMetadata.createSet(signaturePolymorphicMethods);
        this.isNonPortableRuntime = this.determineNonPortableRuntime();
    }

    private static <T> Set<T> createSet(Set<? extends T> s) {
        return s.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(s);
    }

    private boolean determineNonPortableRuntime() {
        return this.isRuntimeClass && !AsmUtils.isPortableRuntimeClass(this.getBinaryClassName());
    }

    public ClassReader getReader() {
        if (this.reader == null) {
            throw new IllegalStateException("'" + this.getBinaryClassName() + "' has no ClassReader, because it was already checked or is only loaded as related class.");
        }
        try {
            ClassReader classReader = this.reader;
            return classReader;
        }
        finally {
            this.reader = null;
        }
    }

    public String getBinaryClassName() {
        return Type.getObjectType(this.className).getClassName();
    }
}

