/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.bmp;

import com.github.jaiimageio.impl.common.ImageUtil;
import com.github.jaiimageio.impl.plugins.bmp.BMPConstants;
import com.github.jaiimageio.impl.plugins.bmp.BMPImageWriter;
import com.github.jaiimageio.impl.plugins.bmp.I18N;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class BMPMetadata
extends IIOMetadata
implements Cloneable,
BMPConstants {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_bmp_image_1.0";
    public String bmpVersion;
    public int width;
    public int height;
    public short bitsPerPixel;
    public int compression;
    public int imageSize;
    public int xPixelsPerMeter;
    public int yPixelsPerMeter;
    public int colorsUsed;
    public int colorsImportant;
    public int redMask;
    public int greenMask;
    public int blueMask;
    public int alphaMask;
    public int colorSpace;
    public double redX;
    public double redY;
    public double redZ;
    public double greenX;
    public double greenY;
    public double greenZ;
    public double blueX;
    public double blueY;
    public double blueZ;
    public int gammaRed;
    public int gammaGreen;
    public int gammaBlue;
    public int intent;
    public byte[] palette = null;
    public int paletteSize;
    public int red;
    public int green;
    public int blue;
    public List comments = null;

    public BMPMetadata() {
        super(true, nativeMetadataFormatName, "com.github.jaiimageio.impl.bmp.BMPMetadataFormat", null, null);
    }

    public BMPMetadata(IIOMetadata metadata) throws IIOInvalidTreeException {
        this();
        if (metadata != null) {
            List<String> formats = Arrays.asList(metadata.getMetadataFormatNames());
            if (formats.contains(nativeMetadataFormatName)) {
                this.setFromTree(nativeMetadataFormatName, metadata.getAsTree(nativeMetadataFormatName));
            } else if (metadata.isStandardMetadataFormatSupported()) {
                String format = "javax_imageio_1.0";
                this.setFromTree(format, metadata.getAsTree(format));
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public Object clone() {
        BMPMetadata metadata;
        try {
            metadata = (BMPMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return metadata;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("BMPMetadata0"));
    }

    private Node getNativeTree() {
        IIOMetadataNode node;
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(root, "BMPVersion", this.bmpVersion);
        this.addChildNode(root, "Width", new Integer(this.width));
        this.addChildNode(root, "Height", new Integer(this.height));
        this.addChildNode(root, "BitsPerPixel", new Short(this.bitsPerPixel));
        this.addChildNode(root, "Compression", new Integer(this.compression));
        this.addChildNode(root, "ImageSize", new Integer(this.imageSize));
        if (this.xPixelsPerMeter > 0 && this.yPixelsPerMeter > 0) {
            node = this.addChildNode(root, "PixelsPerMeter", null);
            this.addChildNode(node, "X", new Integer(this.xPixelsPerMeter));
            this.addChildNode(node, "Y", new Integer(this.yPixelsPerMeter));
        }
        this.addChildNode(root, "ColorsUsed", new Integer(this.colorsUsed));
        this.addChildNode(root, "ColorsImportant", new Integer(this.colorsImportant));
        int version = 0;
        for (int i = 0; i < this.bmpVersion.length(); ++i) {
            if (!Character.isDigit(this.bmpVersion.charAt(i))) continue;
            version = this.bmpVersion.charAt(i) - 48;
        }
        if (version >= 4) {
            node = this.addChildNode(root, "Mask", null);
            this.addChildNode(node, "Red", new Integer(this.redMask));
            this.addChildNode(node, "Green", new Integer(this.greenMask));
            this.addChildNode(node, "Blue", new Integer(this.blueMask));
            this.addChildNode(node, "Alpha", new Integer(this.alphaMask));
            this.addChildNode(root, "ColorSpaceType", new Integer(this.colorSpace));
            node = this.addChildNode(root, "CIEXYZEndpoints", null);
            this.addXYZPoints(node, "Red", this.redX, this.redY, this.redZ);
            this.addXYZPoints(node, "Green", this.greenX, this.greenY, this.greenZ);
            this.addXYZPoints(node, "Blue", this.blueX, this.blueY, this.blueZ);
            node = this.addChildNode(root, "Gamma", null);
            this.addChildNode(node, "Red", new Integer(this.gammaRed));
            this.addChildNode(node, "Green", new Integer(this.gammaGreen));
            this.addChildNode(node, "Blue", new Integer(this.gammaBlue));
            node = this.addChildNode(root, "Intent", new Integer(this.intent));
        }
        if (this.palette != null && this.paletteSize > 0) {
            node = this.addChildNode(root, "Palette", null);
            boolean isVersion2 = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            int j = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                IIOMetadataNode entry = this.addChildNode(node, "PaletteEntry", null);
                this.blue = this.palette[j++] & 0xFF;
                this.green = this.palette[j++] & 0xFF;
                this.red = this.palette[j++] & 0xFF;
                this.addChildNode(entry, "Red", new Integer(this.red));
                this.addChildNode(entry, "Green", new Integer(this.green));
                this.addChildNode(entry, "Blue", new Integer(this.blue));
                if (isVersion2) continue;
                ++j;
            }
        }
        return root;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode node = new IIOMetadataNode("Chroma");
        IIOMetadataNode subNode = new IIOMetadataNode("ColorSpaceType");
        String colorSpaceType = this.palette != null && this.paletteSize > 0 || this.redMask != 0 || this.greenMask != 0 || this.blueMask != 0 || this.bitsPerPixel > 8 ? "RGB" : "GRAY";
        subNode.setAttribute("name", colorSpaceType);
        node.appendChild(subNode);
        subNode = new IIOMetadataNode("NumChannels");
        String numChannels = this.palette != null && this.paletteSize > 0 || this.redMask != 0 || this.greenMask != 0 || this.blueMask != 0 || this.bitsPerPixel > 8 ? (this.alphaMask != 0 ? "4" : "3") : "1";
        subNode.setAttribute("value", numChannels);
        node.appendChild(subNode);
        if (this.gammaRed != 0 && this.gammaGreen != 0 && this.gammaBlue != 0) {
            subNode = new IIOMetadataNode("Gamma");
            Double gamma = new Double((double)(this.gammaRed + this.gammaGreen + this.gammaBlue) / 3.0);
            subNode.setAttribute("value", gamma.toString());
            node.appendChild(subNode);
        }
        if (numChannels.equals("1") && (this.palette == null || this.paletteSize == 0)) {
            subNode = new IIOMetadataNode("BlackIsZero");
            subNode.setAttribute("value", "TRUE");
            node.appendChild(subNode);
        }
        if (this.palette != null && this.paletteSize > 0) {
            subNode = new IIOMetadataNode("Palette");
            boolean isVersion2 = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            int j = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                IIOMetadataNode subNode1 = new IIOMetadataNode("PaletteEntry");
                subNode1.setAttribute("index", "" + i);
                subNode1.setAttribute("blue", "" + (this.palette[j++] & 0xFF));
                subNode1.setAttribute("green", "" + (this.palette[j++] & 0xFF));
                subNode1.setAttribute("red", "" + (this.palette[j++] & 0xFF));
                if (!isVersion2) {
                    ++j;
                }
                subNode.appendChild(subNode1);
            }
            node.appendChild(subNode);
        }
        return node;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode node = new IIOMetadataNode("Compression");
        IIOMetadataNode subNode = new IIOMetadataNode("CompressionTypeName");
        subNode.setAttribute("value", compressionTypeNames[this.compression]);
        node.appendChild(subNode);
        subNode = new IIOMetadataNode("Lossless");
        subNode.setAttribute("value", this.compression == 4 ? "FALSE" : "TRUE");
        node.appendChild(subNode);
        return node;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode node = new IIOMetadataNode("Data");
        String sampleFormat = this.palette != null && this.paletteSize > 0 ? "Index" : "UnsignedIntegral";
        IIOMetadataNode subNode = new IIOMetadataNode("SampleFormat");
        subNode.setAttribute("value", sampleFormat);
        node.appendChild(subNode);
        String bits = "";
        if (this.redMask != 0 || this.greenMask != 0 || this.blueMask != 0) {
            bits = this.countBits(this.redMask) + " " + this.countBits(this.greenMask) + " " + this.countBits(this.blueMask);
            if (this.alphaMask != 0) {
                bits = bits + " " + this.countBits(this.alphaMask);
            }
        } else if (this.palette != null && this.paletteSize > 0) {
            for (int i = 1; i <= 3; ++i) {
                bits = bits + this.bitsPerPixel;
                if (i == 3) continue;
                bits = bits + " ";
            }
        } else if (this.bitsPerPixel == 1) {
            bits = "1";
        } else if (this.bitsPerPixel == 4) {
            bits = "4";
        } else if (this.bitsPerPixel == 8) {
            bits = "8";
        } else if (this.bitsPerPixel == 16) {
            bits = "5 6 5";
        } else if (this.bitsPerPixel == 24) {
            bits = "8 8 8";
        } else if (this.bitsPerPixel == 32) {
            bits = "8 8 8 8";
        }
        if (!bits.equals("")) {
            subNode = new IIOMetadataNode("BitsPerSample");
            subNode.setAttribute("value", bits);
            node.appendChild(subNode);
        }
        return node;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        if (this.yPixelsPerMeter > 0 && this.xPixelsPerMeter > 0) {
            IIOMetadataNode node = new IIOMetadataNode("Dimension");
            float ratio = (float)this.yPixelsPerMeter / (float)this.xPixelsPerMeter;
            IIOMetadataNode subNode = new IIOMetadataNode("PixelAspectRatio");
            subNode.setAttribute("value", "" + ratio);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("HorizontalPixelSize");
            subNode.setAttribute("value", "" + 1000.0f / (float)this.xPixelsPerMeter);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("VerticalPixelSize");
            subNode.setAttribute("value", "" + 1000.0f / (float)this.yPixelsPerMeter);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("HorizontalPhysicalPixelSpacing");
            subNode.setAttribute("value", "" + 1000.0f / (float)this.xPixelsPerMeter);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("VerticalPhysicalPixelSpacing");
            subNode.setAttribute("value", "" + 1000.0f / (float)this.yPixelsPerMeter);
            node.appendChild(subNode);
            return node;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardDocumentNode() {
        if (this.bmpVersion != null) {
            IIOMetadataNode node = new IIOMetadataNode("Document");
            IIOMetadataNode subNode = new IIOMetadataNode("FormatVersion");
            subNode.setAttribute("value", this.bmpVersion);
            node.appendChild(subNode);
            return node;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (this.comments != null) {
            IIOMetadataNode node = new IIOMetadataNode("Text");
            for (String comment : this.comments) {
                IIOMetadataNode subNode = new IIOMetadataNode("TextEntry");
                subNode.setAttribute("keyword", "comment");
                subNode.setAttribute("value", comment);
                node.appendChild(subNode);
            }
            return node;
        }
        return null;
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode node = new IIOMetadataNode("Transparency");
        IIOMetadataNode subNode = new IIOMetadataNode("Alpha");
        String alpha = this.alphaMask != 0 ? "nonpremultiplied" : "none";
        subNode.setAttribute("value", alpha);
        node.appendChild(subNode);
        return node;
    }

    private void fatal(Node node, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node);
    }

    private int getIntAttribute(Node node, String name, int defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private double getDoubleAttribute(Node node, String name, double defaultValue, boolean required) throws IIOInvalidTreeException {
        String value = this.getAttribute(node, name, null, required);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    private int getIntAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, name, -1, true);
    }

    private double getDoubleAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getDoubleAttribute(node, name, -1.0, true);
    }

    private String getAttribute(Node node, String name, String defaultValue, boolean required) throws IIOInvalidTreeException {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            if (!required) {
                return defaultValue;
            }
            this.fatal(node, "Required attribute " + name + " not present!");
        }
        return attr.getNodeValue();
    }

    private String getAttribute(Node node, String name) throws IIOInvalidTreeException {
        return this.getAttribute(node, name, null, true);
    }

    void initialize(ColorModel cm, SampleModel sm, ImageWriteParam param) {
        if (param != null) {
            this.bmpVersion = "BMP v. 3.x";
            if (param.getCompressionMode() == 2) {
                String compressionType = param.getCompressionType();
                this.compression = BMPImageWriter.getCompressionType(compressionType);
            }
        } else {
            this.bmpVersion = "BMP v. 3.x";
            this.compression = BMPImageWriter.getPreferredCompressionType(cm, sm);
        }
        this.width = sm.getWidth();
        this.height = sm.getHeight();
        this.bitsPerPixel = (short)cm.getPixelSize();
        if (cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            this.redMask = dcm.getRedMask();
            this.greenMask = dcm.getGreenMask();
            this.blueMask = dcm.getBlueMask();
            this.alphaMask = dcm.getAlphaMask();
        }
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            this.paletteSize = icm.getMapSize();
            byte[] r = new byte[this.paletteSize];
            byte[] g = new byte[this.paletteSize];
            byte[] b = new byte[this.paletteSize];
            icm.getReds(r);
            icm.getGreens(g);
            icm.getBlues(b);
            boolean isVersion2 = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            this.palette = new byte[(isVersion2 ? 3 : 4) * this.paletteSize];
            int j = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                this.palette[j++] = b[i];
                this.palette[j++] = g[i];
                this.palette[j++] = r[i];
                if (isVersion2) continue;
                ++j;
            }
        }
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node, "Root must be com_sun_media_imageio_plugins_bmp_image_1.0");
        }
        byte[] r = null;
        byte[] g = null;
        byte[] b = null;
        int maxIndex = -1;
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node subNode;
            Object value;
            String name = node.getNodeName();
            if (name.equals("BMPVersion")) {
                value = this.getStringValue(node);
                if (value == null) continue;
                this.bmpVersion = value;
                continue;
            }
            if (name.equals("Width")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.width = (Integer)value;
                continue;
            }
            if (name.equals("Height")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.height = (Integer)value;
                continue;
            }
            if (name.equals("BitsPerPixel")) {
                value = this.getShortValue(node);
                if (value == null) continue;
                this.bitsPerPixel = (Short)value;
                continue;
            }
            if (name.equals("Compression")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.compression = (Integer)value;
                continue;
            }
            if (name.equals("ImageSize")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.imageSize = (Integer)value;
                continue;
            }
            if (name.equals("PixelsPerMeter")) {
                for (subNode = node.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    Integer value2;
                    String subName = subNode.getNodeName();
                    if (subName.equals("X")) {
                        value2 = this.getIntegerValue(subNode);
                        if (value2 == null) continue;
                        this.xPixelsPerMeter = value2;
                        continue;
                    }
                    if (!subName.equals("Y") || (value2 = this.getIntegerValue(subNode)) == null) continue;
                    this.yPixelsPerMeter = value2;
                }
                continue;
            }
            if (name.equals("ColorsUsed")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.colorsUsed = (Integer)value;
                continue;
            }
            if (name.equals("ColorsImportant")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.colorsImportant = (Integer)value;
                continue;
            }
            if (name.equals("Mask")) {
                for (subNode = node.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    Integer value3;
                    String subName = subNode.getNodeName();
                    if (subName.equals("Red")) {
                        value3 = this.getIntegerValue(subNode);
                        if (value3 == null) continue;
                        this.redMask = value3;
                        continue;
                    }
                    if (subName.equals("Green")) {
                        value3 = this.getIntegerValue(subNode);
                        if (value3 == null) continue;
                        this.greenMask = value3;
                        continue;
                    }
                    if (subName.equals("Blue")) {
                        value3 = this.getIntegerValue(subNode);
                        if (value3 == null) continue;
                        this.blueMask = value3;
                        continue;
                    }
                    if (!subName.equals("Alpha") || (value3 = this.getIntegerValue(subNode)) == null) continue;
                    this.alphaMask = value3;
                }
                continue;
            }
            if (name.equals("ColorSpace")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.colorSpace = (Integer)value;
                continue;
            }
            if (name.equals("CIEXYZEndpoints")) {
                for (subNode = node.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    Double value4;
                    String subName1;
                    Node subNode1;
                    String subName = subNode.getNodeName();
                    if (subName.equals("Red")) {
                        for (subNode1 = subNode.getFirstChild(); subNode1 != null; subNode1 = subNode1.getNextSibling()) {
                            subName1 = subNode1.getNodeName();
                            if (subName1.equals("X")) {
                                value4 = this.getDoubleValue(subNode1);
                                if (value4 == null) continue;
                                this.redX = value4;
                                continue;
                            }
                            if (subName1.equals("Y")) {
                                value4 = this.getDoubleValue(subNode1);
                                if (value4 == null) continue;
                                this.redY = value4;
                                continue;
                            }
                            if (!subName1.equals("Z") || (value4 = this.getDoubleValue(subNode1)) == null) continue;
                            this.redZ = value4;
                        }
                        continue;
                    }
                    if (subName.equals("Green")) {
                        for (subNode1 = subNode.getFirstChild(); subNode1 != null; subNode1 = subNode1.getNextSibling()) {
                            subName1 = subNode1.getNodeName();
                            if (subName1.equals("X")) {
                                value4 = this.getDoubleValue(subNode1);
                                if (value4 == null) continue;
                                this.greenX = value4;
                                continue;
                            }
                            if (subName1.equals("Y")) {
                                value4 = this.getDoubleValue(subNode1);
                                if (value4 == null) continue;
                                this.greenY = value4;
                                continue;
                            }
                            if (!subName1.equals("Z") || (value4 = this.getDoubleValue(subNode1)) == null) continue;
                            this.greenZ = value4;
                        }
                        continue;
                    }
                    if (!subName.equals("Blue")) continue;
                    for (subNode1 = subNode.getFirstChild(); subNode1 != null; subNode1 = subNode1.getNextSibling()) {
                        subName1 = subNode1.getNodeName();
                        if (subName1.equals("X")) {
                            value4 = this.getDoubleValue(subNode1);
                            if (value4 == null) continue;
                            this.blueX = value4;
                            continue;
                        }
                        if (subName1.equals("Y")) {
                            value4 = this.getDoubleValue(subNode1);
                            if (value4 == null) continue;
                            this.blueY = value4;
                            continue;
                        }
                        if (!subName1.equals("Z") || (value4 = this.getDoubleValue(subNode1)) == null) continue;
                        this.blueZ = value4;
                    }
                }
                continue;
            }
            if (name.equals("Gamma")) {
                for (subNode = node.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    Integer value5;
                    String subName = subNode.getNodeName();
                    if (subName.equals("Red")) {
                        value5 = this.getIntegerValue(subNode);
                        if (value5 == null) continue;
                        this.gammaRed = value5;
                        continue;
                    }
                    if (subName.equals("Green")) {
                        value5 = this.getIntegerValue(subNode);
                        if (value5 == null) continue;
                        this.gammaGreen = value5;
                        continue;
                    }
                    if (!subName.equals("Blue") || (value5 = this.getIntegerValue(subNode)) == null) continue;
                    this.gammaBlue = value5;
                }
                continue;
            }
            if (name.equals("Intent")) {
                value = this.getIntegerValue(node);
                if (value == null) continue;
                this.intent = (Integer)value;
                continue;
            }
            if (name.equals("Palette")) {
                this.paletteSize = this.getIntAttribute(node, "sizeOfPalette");
                r = new byte[this.paletteSize];
                g = new byte[this.paletteSize];
                b = new byte[this.paletteSize];
                maxIndex = -1;
                Node paletteEntry = node.getFirstChild();
                if (paletteEntry == null) {
                    this.fatal(node, "Palette has no entries!");
                }
                int numPaletteEntries = 0;
                while (paletteEntry != null) {
                    if (!paletteEntry.getNodeName().equals("PaletteEntry")) {
                        this.fatal(node, "Only a PaletteEntry may be a child of a Palette!");
                    }
                    int index = -1;
                    for (Node subNode2 = paletteEntry.getFirstChild(); subNode2 != null; subNode2 = subNode2.getNextSibling()) {
                        Integer value6;
                        String subName = subNode2.getNodeName();
                        if (subName.equals("Index")) {
                            value6 = this.getIntegerValue(subNode2);
                            if (value6 != null) {
                                index = value6;
                            }
                            if (index >= 0 && index <= this.paletteSize - 1) continue;
                            this.fatal(node, "Bad value for PaletteEntry attribute index!");
                            continue;
                        }
                        if (subName.equals("Red")) {
                            value6 = this.getIntegerValue(subNode2);
                            if (value6 == null) continue;
                            this.red = value6;
                            continue;
                        }
                        if (subName.equals("Green")) {
                            value6 = this.getIntegerValue(subNode2);
                            if (value6 == null) continue;
                            this.green = value6;
                            continue;
                        }
                        if (!subName.equals("Blue") || (value6 = this.getIntegerValue(subNode2)) == null) continue;
                        this.blue = value6;
                    }
                    if (index == -1) {
                        index = numPaletteEntries;
                    }
                    if (index > maxIndex) {
                        maxIndex = index;
                    }
                    r[index] = (byte)this.red;
                    g[index] = (byte)this.green;
                    b[index] = (byte)this.blue;
                    ++numPaletteEntries;
                    paletteEntry = paletteEntry.getNextSibling();
                }
                continue;
            }
            if (name.equals("CommentExtensions")) {
                Node commentExtension = node.getFirstChild();
                if (commentExtension == null) {
                    this.fatal(node, "CommentExtensions has no entries!");
                }
                if (this.comments == null) {
                    this.comments = new ArrayList();
                }
                while (commentExtension != null) {
                    if (!commentExtension.getNodeName().equals("CommentExtension")) {
                        this.fatal(node, "Only a CommentExtension may be a child of a CommentExtensions!");
                    }
                    this.comments.add(this.getAttribute(commentExtension, "value"));
                    commentExtension = commentExtension.getNextSibling();
                }
                continue;
            }
            this.fatal(node, "Unknown child of root node!");
        }
        if (r != null && g != null && b != null) {
            boolean isVersion2 = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            int numEntries = maxIndex + 1;
            this.palette = new byte[(isVersion2 ? 3 : 4) * numEntries];
            int j = 0;
            for (int i = 0; i < numEntries; ++i) {
                this.palette[j++] = b[i];
                this.palette[j++] = g[i];
                this.palette[j++] = r[i];
                if (isVersion2) continue;
                ++j;
            }
        }
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            this.fatal(node, "Root must be javax_imageio_1.0");
        }
        String colorSpaceType = null;
        int numChannels = 0;
        int[] bitsPerSample = null;
        boolean hasAlpha = false;
        byte[] r = null;
        byte[] g = null;
        byte[] b = null;
        int maxIndex = -1;
        block0: for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String childName = child.getNodeName();
                    if (childName.equals("ColorSpaceType")) {
                        colorSpaceType = this.getAttribute(child, "name");
                        continue;
                    }
                    if (childName.equals("NumChannels")) {
                        numChannels = this.getIntAttribute(child, "value");
                        continue;
                    }
                    if (childName.equals("Gamma")) {
                        this.gammaGreen = this.gammaBlue = (int)(this.getDoubleAttribute(child, "value") + 0.5);
                        this.gammaRed = this.gammaBlue;
                        continue;
                    }
                    if (!childName.equals("Palette")) continue;
                    r = new byte[256];
                    g = new byte[256];
                    b = new byte[256];
                    maxIndex = -1;
                    Node paletteEntry = child.getFirstChild();
                    if (paletteEntry == null) {
                        this.fatal(node, "Palette has no entries!");
                    }
                    while (paletteEntry != null) {
                        int index;
                        if (!paletteEntry.getNodeName().equals("PaletteEntry")) {
                            this.fatal(node, "Only a PaletteEntry may be a child of a Palette!");
                        }
                        if ((index = this.getIntAttribute(paletteEntry, "index")) < 0 || index > 255) {
                            this.fatal(node, "Bad value for PaletteEntry attribute index!");
                        }
                        if (index > maxIndex) {
                            maxIndex = index;
                        }
                        r[index] = (byte)this.getIntAttribute(paletteEntry, "red");
                        g[index] = (byte)this.getIntAttribute(paletteEntry, "green");
                        b[index] = (byte)this.getIntAttribute(paletteEntry, "blue");
                        paletteEntry = paletteEntry.getNextSibling();
                    }
                }
                continue;
            }
            if (name.equals("Compression")) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String childName = child.getNodeName();
                    if (!childName.equals("CompressionTypeName")) continue;
                    String compressionName = this.getAttribute(child, "value");
                    this.compression = BMPImageWriter.getCompressionType(compressionName);
                }
                continue;
            }
            if (name.equals("Data")) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String childName = child.getNodeName();
                    if (!childName.equals("BitsPerSample")) continue;
                    ArrayList<Integer> bps = new ArrayList<Integer>(4);
                    String s = this.getAttribute(child, "value");
                    StringTokenizer t = new StringTokenizer(s);
                    while (t.hasMoreTokens()) {
                        bps.add(Integer.valueOf(t.nextToken()));
                    }
                    bitsPerSample = new int[bps.size()];
                    for (int i = 0; i < bitsPerSample.length; ++i) {
                        bitsPerSample[i] = (Integer)bps.get(i);
                    }
                    continue block0;
                }
                continue;
            }
            if (name.equals("Dimension")) {
                boolean gotWidth = false;
                boolean gotHeight = false;
                boolean gotAspectRatio = false;
                boolean gotSpaceX = false;
                boolean gotSpaceY = false;
                double width = -1.0;
                double height = -1.0;
                double aspectRatio = -1.0;
                double spaceX = -1.0;
                double spaceY = -1.0;
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String childName = child.getNodeName();
                    if (childName.equals("PixelAspectRatio")) {
                        aspectRatio = this.getDoubleAttribute(child, "value");
                        gotAspectRatio = true;
                        continue;
                    }
                    if (childName.equals("HorizontalPixelSize")) {
                        width = this.getDoubleAttribute(child, "value");
                        gotWidth = true;
                        continue;
                    }
                    if (childName.equals("VerticalPixelSize")) {
                        height = this.getDoubleAttribute(child, "value");
                        gotHeight = true;
                        continue;
                    }
                    if (childName.equals("HorizontalPhysicalPixelSpacing")) {
                        spaceX = this.getDoubleAttribute(child, "value");
                        gotSpaceX = true;
                        continue;
                    }
                    if (!childName.equals("VerticalPhysicalPixelSpacing")) continue;
                    spaceY = this.getDoubleAttribute(child, "value");
                    gotSpaceY = true;
                }
                if (!gotWidth && !gotHeight && (gotSpaceX || gotSpaceY)) {
                    width = spaceX;
                    gotWidth = gotSpaceX;
                    height = spaceY;
                    gotHeight = gotSpaceY;
                }
                if (gotWidth && gotHeight) {
                    this.xPixelsPerMeter = (int)(1000.0 / width + 0.5);
                    this.yPixelsPerMeter = (int)(1000.0 / height + 0.5);
                    continue;
                }
                if (!gotAspectRatio || aspectRatio == 0.0) continue;
                if (gotWidth) {
                    this.xPixelsPerMeter = (int)(1000.0 / width + 0.5);
                    this.yPixelsPerMeter = (int)(aspectRatio * (1000.0 / width) + 0.5);
                    continue;
                }
                if (!gotHeight) continue;
                this.xPixelsPerMeter = (int)(1000.0 / height / aspectRatio + 0.5);
                this.yPixelsPerMeter = (int)(1000.0 / height + 0.5);
                continue;
            }
            if (name.equals("Document")) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String childName = child.getNodeName();
                    if (!childName.equals("FormatVersion")) continue;
                    this.bmpVersion = this.getAttribute(child, "value");
                    continue block0;
                }
                continue;
            }
            if (name.equals("Text")) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String childName = child.getNodeName();
                    if (!childName.equals("TextEntry")) continue;
                    if (this.comments == null) {
                        this.comments = new ArrayList();
                    }
                    this.comments.add(this.getAttribute(child, "value"));
                }
                continue;
            }
            if (!name.equals("Transparency")) continue;
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                String childName = child.getNodeName();
                if (!childName.equals("Alpha")) continue;
                hasAlpha = !this.getAttribute(child, "value").equals("none");
                continue block0;
            }
        }
        if (bitsPerSample != null) {
            if (this.palette != null && this.paletteSize > 0) {
                this.bitsPerPixel = (short)bitsPerSample[0];
            } else {
                this.bitsPerPixel = 0;
                for (int i = 0; i < bitsPerSample.length; ++i) {
                    this.bitsPerPixel = (short)(this.bitsPerPixel + bitsPerSample[i]);
                }
            }
        } else if (this.palette != null) {
            this.bitsPerPixel = (short)8;
        } else if (numChannels == 1) {
            this.bitsPerPixel = (short)8;
        } else if (numChannels == 3) {
            this.bitsPerPixel = (short)24;
        } else if (numChannels == 4) {
            this.bitsPerPixel = (short)32;
        } else if (colorSpaceType.equals("GRAY")) {
            this.bitsPerPixel = (short)8;
        } else if (colorSpaceType.equals("RGB")) {
            this.bitsPerPixel = (short)(hasAlpha ? 32 : 24);
        }
        if (bitsPerSample != null && bitsPerSample.length == 4 || this.bitsPerPixel >= 24) {
            this.redMask = 0xFF0000;
            this.greenMask = 65280;
            this.blueMask = 255;
        }
        if (bitsPerSample != null && bitsPerSample.length == 4 || this.bitsPerPixel > 24) {
            this.alphaMask = -16777216;
        }
        if (r != null && g != null && b != null) {
            boolean isVersion2 = this.bmpVersion != null && this.bmpVersion.equals("BMP v. 2.x");
            this.paletteSize = maxIndex + 1;
            this.palette = new byte[(isVersion2 ? 3 : 4) * this.paletteSize];
            int j = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                this.palette[j++] = b[i];
                this.palette[j++] = g[i];
                this.palette[j++] = r[i];
                if (isVersion2) continue;
                ++j;
            }
        }
    }

    @Override
    public void reset() {
        this.bmpVersion = null;
        this.width = 0;
        this.height = 0;
        this.bitsPerPixel = 0;
        this.compression = 0;
        this.imageSize = 0;
        this.xPixelsPerMeter = 0;
        this.yPixelsPerMeter = 0;
        this.colorsUsed = 0;
        this.colorsImportant = 0;
        this.redMask = 0;
        this.greenMask = 0;
        this.blueMask = 0;
        this.alphaMask = 0;
        this.colorSpace = 0;
        this.redX = 0.0;
        this.redY = 0.0;
        this.redZ = 0.0;
        this.greenX = 0.0;
        this.greenY = 0.0;
        this.greenZ = 0.0;
        this.blueX = 0.0;
        this.blueY = 0.0;
        this.blueZ = 0.0;
        this.gammaRed = 0;
        this.gammaGreen = 0;
        this.gammaBlue = 0;
        this.intent = 0;
        this.palette = null;
        this.paletteSize = 0;
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.comments = null;
    }

    private String countBits(int num) {
        int count = 0;
        while (num != 0) {
            if ((num & 1) == 1) {
                ++count;
            }
            num >>>= 1;
        }
        return count == 0 ? "0" : "" + count;
    }

    private void addXYZPoints(IIOMetadataNode root, String name, double x, double y, double z) {
        IIOMetadataNode node = this.addChildNode(root, name, null);
        this.addChildNode(node, "X", new Double(x));
        this.addChildNode(node, "Y", new Double(y));
        this.addChildNode(node, "Z", new Double(z));
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode root, String name, Object object) {
        IIOMetadataNode child = new IIOMetadataNode(name);
        if (object != null) {
            child.setUserObject(object);
            child.setNodeValue(ImageUtil.convertObjectToString(object));
        }
        root.appendChild(child);
        return child;
    }

    private Object getObjectValue(Node node) {
        Object tmp = node.getNodeValue();
        if (tmp == null && node instanceof IIOMetadataNode) {
            tmp = ((IIOMetadataNode)node).getUserObject();
        }
        return tmp;
    }

    private String getStringValue(Node node) {
        Object tmp = this.getObjectValue(node);
        return tmp instanceof String ? (String)tmp : null;
    }

    private Byte getByteValue(Node node) {
        Object tmp = this.getObjectValue(node);
        Byte value = null;
        if (tmp instanceof String) {
            value = Byte.valueOf((String)tmp);
        } else if (tmp instanceof Byte) {
            value = (Byte)tmp;
        }
        return value;
    }

    private Short getShortValue(Node node) {
        Object tmp = this.getObjectValue(node);
        Short value = null;
        if (tmp instanceof String) {
            value = Short.valueOf((String)tmp);
        } else if (tmp instanceof Short) {
            value = (Short)tmp;
        }
        return value;
    }

    private Integer getIntegerValue(Node node) {
        Object tmp = this.getObjectValue(node);
        Integer value = null;
        if (tmp instanceof String) {
            value = Integer.valueOf((String)tmp);
        } else if (tmp instanceof Integer) {
            value = (Integer)tmp;
        } else if (tmp instanceof Byte) {
            value = new Integer((int)((Byte)tmp & 0xFF));
        }
        return value;
    }

    private Double getDoubleValue(Node node) {
        Object tmp = this.getObjectValue(node);
        Double value = null;
        if (tmp instanceof String) {
            value = Double.valueOf((String)tmp);
        } else if (tmp instanceof Double) {
            value = (Double)tmp;
        }
        return value;
    }
}

