/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.Objects;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.TypeBuilder;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.util.GenericName;

public final class CharacteristicTypeBuilder<V>
extends TypeBuilder {
    private AttributeTypeBuilder<?> owner;
    private final Class<V> valueClass;
    private V defaultValue;
    private transient DefaultAttributeType<V> characteristic;

    private CharacteristicTypeBuilder(CharacteristicTypeBuilder<?> characteristicTypeBuilder, Class<V> clazz) throws UnconvertibleObjectException {
        super(characteristicTypeBuilder);
        this.owner = characteristicTypeBuilder.owner;
        this.valueClass = clazz;
        this.defaultValue = ObjectConverters.convert(characteristicTypeBuilder.defaultValue, clazz);
    }

    CharacteristicTypeBuilder(AttributeTypeBuilder<?> attributeTypeBuilder, Class<V> clazz) {
        super(attributeTypeBuilder.getLocale());
        this.owner = attributeTypeBuilder;
        this.valueClass = clazz;
    }

    CharacteristicTypeBuilder(AttributeTypeBuilder<?> attributeTypeBuilder, DefaultAttributeType<V> defaultAttributeType) {
        super(attributeTypeBuilder.getLocale());
        this.owner = attributeTypeBuilder;
        this.characteristic = defaultAttributeType;
        this.valueClass = defaultAttributeType.getValueClass();
        this.defaultValue = defaultAttributeType.getDefaultValue();
        this.initialize(defaultAttributeType);
    }

    @Override
    final void clearCache() {
        this.characteristic = null;
        this.ensureAlive(this.owner);
        this.owner.clearCache();
    }

    @Override
    final String getDefaultName() {
        return Classes.getShortName(this.valueClass);
    }

    @Override
    public CharacteristicTypeBuilder<V> setName(GenericName genericName) {
        super.setName(genericName);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setName(CharSequence charSequence) {
        super.setName(charSequence);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setName(CharSequence ... charSequenceArray) {
        super.setName(charSequenceArray);
        return this;
    }

    @Override
    final GenericName createLocalName(CharSequence charSequence) {
        this.ensureAlive(this.owner);
        return this.owner.createLocalName(charSequence);
    }

    @Override
    final GenericName createGenericName(CharSequence ... charSequenceArray) {
        this.ensureAlive(this.owner);
        return this.owner.createGenericName(charSequenceArray);
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    public <N> CharacteristicTypeBuilder<N> setValueClass(Class<N> clazz) throws UnconvertibleObjectException {
        this.ensureAlive(this.owner);
        this.ensureNonNull("type", clazz);
        if (clazz == this.valueClass) {
            return this;
        }
        CharacteristicTypeBuilder<N> characteristicTypeBuilder = new CharacteristicTypeBuilder<N>(this, clazz);
        this.owner.characteristics.set(this.owner.characteristics.lastIndexOf(this), characteristicTypeBuilder);
        this.owner = null;
        return characteristicTypeBuilder;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public CharacteristicTypeBuilder<V> setDefaultValue(V v) {
        if (!Objects.equals(this.defaultValue, v)) {
            this.defaultValue = v;
            this.clearCache();
        }
        return this;
    }

    final void set(Object object) {
        this.setDefaultValue(this.valueClass.cast(object));
    }

    @Override
    public CharacteristicTypeBuilder<V> setDefinition(CharSequence charSequence) {
        super.setDefinition(charSequence);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setDesignation(CharSequence charSequence) {
        super.setDesignation(charSequence);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setDescription(CharSequence charSequence) {
        super.setDescription(charSequence);
        return this;
    }

    @Override
    public CharacteristicTypeBuilder<V> setDeprecated(boolean bl) {
        super.setDeprecated(bl);
        return this;
    }

    @Override
    public DefaultAttributeType<V> build() {
        if (this.characteristic == null) {
            this.characteristic = new DefaultAttributeType<V>(this.identification(), this.valueClass, 0, 1, this.defaultValue, new DefaultAttributeType[0]);
        }
        return this.characteristic;
    }

    final void owner(AttributeTypeBuilder<?> attributeTypeBuilder) {
        this.owner = attributeTypeBuilder;
    }

    @Override
    public void remove() {
        if (this.owner != null) {
            this.owner.characteristics.remove(this.owner.characteristics.lastIndexOf(this));
            this.owner.clearCache();
            this.owner = null;
        }
    }
}

