/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.j2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.sis.internal.feature.AbstractGeometry;
import org.apache.sis.internal.referencing.j2d.IntervalRectangle;

public abstract class FlatShape
extends AbstractGeometry
implements Shape {
    final IntervalRectangle bounds;

    FlatShape(IntervalRectangle intervalRectangle) {
        this.bounds = intervalRectangle;
    }

    FlatShape(double[] dArray, int n) {
        double d;
        double d2;
        double d3 = d2 = dArray[0];
        double d4 = d = dArray[1];
        int n2 = 2;
        while (n2 < n) {
            double d5 = dArray[n2++];
            double d6 = dArray[n2++];
            if (d5 < d3) {
                d3 = d5;
            }
            if (d5 > d2) {
                d2 = d5;
            }
            if (d6 < d4) {
                d4 = d6;
            }
            if (!(d6 > d)) continue;
            d = d6;
        }
        this.bounds = new IntervalRectangle(d3, d4, d2, d);
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds.getBounds();
    }

    @Override
    public final Rectangle2D getBounds2D() {
        return this.bounds.getBounds2D();
    }

    @Override
    public final boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public final PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    public FlatShape fastClip(Rectangle2D rectangle2D) {
        return this.bounds.intersects(rectangle2D) ? this : null;
    }
}

