/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.util.Arrays;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class ST_Transform<R, G>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -5769818355081378907L;
    private final Expression<? super R, GeometryWrapper<G>> geometry;

    ST_Transform(Expression<? super R, ?>[] expressionArray, Geometries<G> geometries) {
        super(SQLMM.ST_Transform, expressionArray, 1);
        this.geometry = ST_Transform.toGeometryWrapper(geometries, expressionArray[0]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<? super R, ?>[] expressionArray) {
        return new ST_Transform(expressionArray, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return ST_Transform.getGeometryLibrary(this.geometry);
    }

    @Override
    public List<Expression<? super R, ?>> getParameters() {
        return Arrays.asList(ST_Transform.unwrap(this.geometry), this.srid);
    }

    @Override
    public Object apply(R r) {
        GeometryWrapper<G> geometryWrapper = this.geometry.apply(r);
        if (geometryWrapper != null) {
            try {
                return geometryWrapper.transform(this.getTargetCRS(r)).implementation();
            }
            catch (BackingStoreException backingStoreException) {
                Throwable throwable = backingStoreException.getCause();
                this.warning(throwable instanceof Exception ? (Exception)throwable : backingStoreException, false);
            }
            catch (UnsupportedOperationException | TransformException | FactoryException throwable) {
                this.warning((Exception)throwable, false);
            }
        }
        return null;
    }
}

