/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime.async;

import org.apache.chemistry.opencmis.client.api.AsyncSession;
import org.apache.chemistry.opencmis.client.api.AsyncSessionFactory;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.async.ThreadPoolExecutorAsyncSession;

public class AsyncSessionFactoryImpl
implements AsyncSessionFactory {
    protected AsyncSessionFactoryImpl() {
    }

    public static AsyncSessionFactoryImpl newInstance() {
        return new AsyncSessionFactoryImpl();
    }

    public AsyncSession createAsyncSession(Session session) {
        return this.createAsyncSession(session, 5);
    }

    public AsyncSession createAsyncSession(Session session, int maxParallelRequests) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (maxParallelRequests < 1) {
            throw new IllegalArgumentException("maxParallelRequests must be >0!");
        }
        return new ThreadPoolExecutorAsyncSession(session, maxParallelRequests);
    }
}

