/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.admin;

import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.admin.TypeSystemMgr;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;

public abstract class CASFactory {
    public static final boolean USE_JCAS_CACHE_DEFAULT = true;

    public static CASMgr createCAS() {
        return new CASImpl();
    }

    public static CASMgr createCAS(int initialHeapSize) {
        return CASFactory.createCAS(initialHeapSize, true);
    }

    public static CASMgr createCAS(int initialHeapSize, boolean useJcasCache) {
        return new CASImpl(initialHeapSize, useJcasCache);
    }

    public static CASMgr createCAS(int initialHeapSize, TypeSystem ts) {
        return CASFactory.createCAS(initialHeapSize, ts, true);
    }

    public static CASMgr createCAS(int initialHeapSize, TypeSystem ts, boolean useJcasCache) {
        if (ts == null) {
            throw new NullPointerException("TypeSystem");
        }
        return new CASImpl((TypeSystemImpl)ts, initialHeapSize, useJcasCache);
    }

    public static CASMgr createCAS(TypeSystem ts) {
        return CASFactory.createCAS(ts, true);
    }

    public static CASMgr createCAS(TypeSystem ts, boolean useJcasCache) {
        if (ts == null) {
            throw new NullPointerException("TypeSystem");
        }
        return new CASImpl((TypeSystemImpl)ts, 500000, useJcasCache);
    }

    public static TypeSystemMgr createTypeSystem() {
        TypeSystemImpl ts = new TypeSystemImpl();
        return ts;
    }
}

