/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.algorithm;

import java.io.PrintStream;

public class Printer {
    public static final int DEFAULT_INCREMENT = 4;
    private PrintStream ps;
    private int increment;
    private char padChar;
    private int indent;
    private char[] pad;
    private StringBuilder bld;
    private int rightJustificationSize;

    public Printer(PrintStream ps) {
        this(ps, 4, ' ');
    }

    public Printer(PrintStream ps, int increment, char padChar) {
        this.ps = ps;
        this.increment = increment;
        this.padChar = padChar;
        this.indent = 0;
        this.bld = new StringBuilder();
        this.fill();
        this.rightJustificationSize = 0;
    }

    public Printer rj(int size) {
        this.rightJustificationSize = size;
        return this;
    }

    private Printer rightJustify(String str) {
        if (str.length() < this.rightJustificationSize) {
            for (int ctr = 0; ctr < this.rightJustificationSize - str.length(); ++ctr) {
                this.bld.append(' ');
            }
        }
        this.rightJustificationSize = 0;
        return this;
    }

    public Printer p(String str) {
        this.rightJustify(str);
        this.bld.append(str);
        return this;
    }

    public Printer p(Object ... args) {
        for (Object obj : args) {
            this.p(obj);
        }
        return this;
    }

    public Printer p(Object obj) {
        String str = obj.toString();
        this.rightJustify(str);
        this.bld.append(str);
        return this;
    }

    public Printer in() {
        this.indent += this.increment;
        this.fill();
        return this;
    }

    public Printer out() {
        if (this.indent < this.increment) {
            throw new IllegalStateException("Cannot undent past start of line");
        }
        this.indent -= this.increment;
        this.fill();
        return this;
    }

    public int indent() {
        return this.indent;
    }

    private void fill() {
        this.pad = new char[this.indent];
        for (int ctr = 0; ctr < this.pad.length; ++ctr) {
            this.pad[ctr] = this.padChar;
        }
    }

    public Printer nl() {
        this.ps.println(this.bld.toString());
        this.bld = new StringBuilder();
        this.bld.append(this.pad);
        return this;
    }

    private boolean isPrintable(char c) {
        if (Character.isJavaIdentifierStart(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        switch (Character.getType(c)) {
            case 27: {
                return true;
            }
            case 20: {
                return true;
            }
            case 25: {
                return true;
            }
            case 24: {
                return true;
            }
            case 21: {
                return true;
            }
            case 22: {
                return true;
            }
        }
        return false;
    }

    public Printer printBuffer(byte[] buffer) {
        int length = buffer.length;
        for (int i = 0; i < length; i += 16) {
            int j;
            StringBuffer sbuf = new StringBuffer();
            for (j = 0; j < 16 && i + j < length; ++j) {
                String hex;
                int k = buffer[i + j];
                if (k < 0) {
                    k = 256 + k;
                }
                if ((hex = Integer.toHexString(k)).length() == 1) {
                    hex = "0" + hex;
                }
                sbuf.append(hex + " ");
            }
            while (j < 16) {
                sbuf.append("   ");
                ++j;
            }
            for (int x = 0; x < 16 && x + i < length; ++x) {
                char ch = (char)buffer[i + x];
                if (this.isPrintable(ch)) {
                    sbuf.append(ch);
                    continue;
                }
                sbuf.append('.');
            }
            this.nl().p((Object)sbuf);
        }
        return this;
    }
}

