/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.exceptions;

import java.math.BigInteger;
import java.util.Map;

public abstract class CmisBaseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private BigInteger code = BigInteger.ZERO;
    private String errorContent;
    private Map<String, String> additionalData;

    protected CmisBaseException() {
    }

    protected CmisBaseException(String message, BigInteger code, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    protected CmisBaseException(String message, String errorContent, Map<String, String> additionalData, Throwable cause) {
        super(message, cause);
        this.errorContent = errorContent;
        this.additionalData = additionalData;
    }

    protected CmisBaseException(String message, String errorContent, Throwable cause) {
        this(message, errorContent, null, cause);
    }

    protected CmisBaseException(String message, BigInteger code) {
        super(message);
        this.code = code;
    }

    protected CmisBaseException(String message, BigInteger code, String errorContent) {
        super(message);
        this.code = code;
        this.errorContent = errorContent;
    }

    protected CmisBaseException(String message, BigInteger code, String errorContent, Map<String, String> additionalData) {
        this(message, code, errorContent);
        this.additionalData = additionalData;
    }

    protected CmisBaseException(String message, String errorContent) {
        super(message);
        this.errorContent = errorContent;
    }

    protected CmisBaseException(String message, Throwable cause) {
        this(message, (BigInteger)null, cause);
    }

    protected CmisBaseException(String message) {
        this(message, (BigInteger)null);
    }

    public BigInteger getCode() {
        return this.code;
    }

    public String getErrorContent() {
        return this.errorContent;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public String getAdditionalData(String key) {
        if (this.additionalData == null) {
            return null;
        }
        return this.additionalData.get(key);
    }

    public void setAdditionalData(Map<String, String> data) {
        this.additionalData = data;
    }

    public abstract String getExceptionName();
}

