/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.util.TableParser;

public class FslLocalTables
extends NcepLocalTables {
    public static final int center_id = 59;
    private static final String fimTable = "resources/grib2/noaa_gsd/fim.gribtable";
    private static final String hrrrTable = "resources/grib2/noaa_gsd/Fsl-hrrr2.csv";
    private static Map<String, FslLocalTables> tables = new HashMap<String, FslLocalTables>();

    public static FslLocalTables getCust(Grib2Table table) {
        FslLocalTables cust = tables.get(FslLocalTables.getPath(table));
        if (cust != null) {
            return cust;
        }
        cust = new FslLocalTables(table);
        tables.put(table.getPath(), cust);
        return cust;
    }

    private static String getPath(Grib2Table grib2Table) {
        if (grib2Table.getId().genProcessId == 125) {
            return fimTable;
        }
        return hrrrTable;
    }

    private FslLocalTables(Grib2Table grib2Table) {
        super(grib2Table);
        grib2Table.setPath(FslLocalTables.getPath(grib2Table));
        this.initLocalTable(null);
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return this.grib2Table.getPath();
    }

    @Override
    public List<GribTables.Parameter> getParameters() {
        ArrayList<GribTables.Parameter> result = new ArrayList<GribTables.Parameter>();
        for (Grib2Parameter p : this.local.values()) {
            result.add(p);
        }
        Collections.sort(result, new LocalTables.ParameterSort());
        return result;
    }

    @Override
    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return (GribTables.Parameter)this.local.get(FslLocalTables.makeHash(discipline, category, number));
    }

    @Override
    public String getSubCenterName(int center, int subcenter) {
        switch (subcenter) {
            case 0: {
                return null;
            }
            case 1: {
                return "FSL/FRD Regional Analysis and Prediction Branch";
            }
            case 2: {
                return "FSL/FRD Local Analysis and Prediction Branch";
            }
        }
        return super.getSubCenterName(center, subcenter);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        switch (genProcess) {
            case 103: {
                return "ExREF";
            }
            case 105: {
                return "RAP/ RUC";
            }
            case 106: {
                return "Developmental Testbed Center Winter Field Experiment, WRF-ARW";
            }
            case 112: {
                return "Developmental Testbed Center Winter Field Experiment, WRF-NMM";
            }
            case 116: {
                return "Flow-following Finite-volume Icosahedral Model (FIM)";
            }
            case 125: {
                return "High-Resolution Rapid Refresh";
            }
        }
        return null;
    }

    @Override
    public String getLevelNameShort(int id) {
        if (id < 192) {
            return super.getLevelNameShort(id);
        }
        switch (id) {
            case 200: {
                return "Entire_atmosphere";
            }
        }
        return null;
    }

    @Override
    public String getLevelName(int id) {
        if (id < 192) {
            return super.getLevelName(id);
        }
        switch (id) {
            case 200: {
                return "Entire atmosphere layer";
            }
        }
        return null;
    }

    @Override
    public String getStatisticNameShort(int id) {
        switch (id) {
            case 255: {
                return "Interval";
            }
        }
        return super.getStatisticNameShort(id);
    }

    protected void initLocalTable(Formatter f) {
        this.local = this.grib2Table.getPath().equals(hrrrTable) ? this.readCsv(hrrrTable, f) : this.readFim(fimTable, f);
    }

    @Override
    public void lookForProblems(Formatter f) {
        this.initLocalTable(f);
    }

    private Map<Integer, Grib2Parameter> readCsv(String resourcePath, Formatter f) {
        boolean header = true;
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(resourcePath);){
            String line;
            if (is == null) {
                throw new IllegalStateException("Cant find " + resourcePath);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            HashMap<String, Grib2Parameter> names = new HashMap<String, Grib2Parameter>(200);
            while ((line = br.readLine()) != null && !line.startsWith("Record")) {
            }
            while ((line = br.readLine()) != null) {
                Grib2Parameter dup;
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = line.split(",");
                String recordNumber = flds[0].trim();
                int tableNumber = Integer.parseInt(flds[1].trim());
                int disciplineNumber = Integer.parseInt(flds[2].trim());
                int categoryNumber = Integer.parseInt(flds[3].trim());
                int parameterNumber = Integer.parseInt(flds[4].trim());
                String WGrib2Name = flds[5].trim();
                String NCLName = flds[6].trim();
                String FieldType = flds[7].trim();
                String Description = flds[8].trim();
                String Units = flds[9].trim();
                if (f != null) {
                    f.format("%3s %3d %3d %3d %3d %-10s %-25s %-30s %-100s %-20s%n", recordNumber, tableNumber, disciplineNumber, categoryNumber, parameterNumber, WGrib2Name, NCLName, FieldType, Description, Units);
                }
                String name = !WGrib2Name.equals("var") ? WGrib2Name : FieldType;
                Grib2Parameter s = new Grib2Parameter(disciplineNumber, categoryNumber, parameterNumber, name, Units, null, Description);
                s.desc = Description;
                result.put(FslLocalTables.makeHash(disciplineNumber, categoryNumber, parameterNumber), s);
                if (f != null) {
                    f.format(" %s%n", s);
                }
                if ((categoryNumber > 191 || parameterNumber > 191) && (dup = (Grib2Parameter)names.get(s.getName())) != null && f != null) {
                    if (header) {
                        f.format("Problems in table %s %n", resourcePath);
                    }
                    header = false;
                    f.format(" DUPLICATE NAME %s and %s (%s)%n", s.getId(), dup.getId(), s.getName());
                }
                names.put(s.getName(), s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }

    private Map<Integer, Grib2Parameter> readFim(String resourcePath, Formatter f) {
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(resourcePath);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + resourcePath);
            }
            if (f != null) {
                f.format("%50s == %s, %s, %-20s, %-20s%n", "desc", "param", "ztype", "abbrev", "units");
            }
            List<TableParser.Record> recs = TableParser.readTable(is, "56,63i,68i,93,102,112", 50000);
            for (TableParser.Record record : recs) {
                String desc = ((String)record.get(0)).trim();
                int param = (Integer)record.get(1);
                int ztype = (Integer)record.get(2);
                String abbrev = ((String)record.get(4)).trim();
                String units = ((String)record.get(5)).trim();
                if (f != null) {
                    f.format("%50s == %3d, %3d, %-20s, %-20s%n", desc, param, ztype, abbrev, units);
                }
                Grib2Parameter gp = new Grib2Parameter(0, 0, param, abbrev, units, null, desc);
                result.put(FslLocalTables.makeHash(0, 0, param), gp);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }

    public static void main(String[] args) {
        FslLocalTables hrrr = new FslLocalTables(new Grib2Table("GSD_HRRR", 59, -1, -1, -1, 125, null, Grib2Table.Type.gsd));
        Formatter f = new Formatter();
        Grib2Parameter.compareTables("FSL-HRRR", "Standard WMO version", hrrr.getParameters(), Grib2Customizer.factory(0, 0, 0, 0, 0), f);
        System.out.printf("%s%n", f);
        Formatter f2 = new Formatter();
        Grib2Parameter.compareTables("FSL-HRRR", "NCEP Table", hrrr.getParameters(), Grib2Customizer.factory(7, 0, 0, 0, 0), f2);
        System.out.printf("%s%n", f2);
    }
}

