/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.DocumentAnalysisResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;

public class DocumentAnalysisRequest
extends SolrRequest<DocumentAnalysisResponse> {
    private List<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
    private String query;
    private boolean showMatch = false;

    public DocumentAnalysisRequest() {
        super(SolrRequest.METHOD.POST, "/analysis/document");
    }

    public DocumentAnalysisRequest(String uri) {
        super(SolrRequest.METHOD.POST, uri);
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                try {
                    DocumentAnalysisRequest.this.getXML(outputStreamWriter);
                }
                finally {
                    outputStreamWriter.flush();
                }
            }

            @Override
            public String getContentType() {
                return "application/xml; charset=UTF-8";
            }
        };
    }

    @Override
    protected DocumentAnalysisResponse createResponse(SolrClient client) {
        return new DocumentAnalysisResponse();
    }

    @Override
    public ModifiableSolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (this.query != null) {
            params.add("analysis.query", this.query);
            params.add("analysis.showmatch", String.valueOf(this.showMatch));
        }
        return params;
    }

    String getXML(Writer writer) throws IOException {
        writer.write("<docs>");
        for (SolrInputDocument document : this.documents) {
            ClientUtils.writeXML(document, writer);
        }
        writer.write("</docs>");
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    public DocumentAnalysisRequest addDocument(SolrInputDocument doc) {
        this.documents.add(doc);
        return this;
    }

    public DocumentAnalysisRequest addDocuments(Collection<SolrInputDocument> docs) {
        this.documents.addAll(docs);
        return this;
    }

    public DocumentAnalysisRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public DocumentAnalysisRequest setShowMatch(boolean showMatch) {
        this.showMatch = showMatch;
        return this;
    }

    public List<SolrInputDocument> getDocuments() {
        return this.documents;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isShowMatch() {
        return this.showMatch;
    }

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.QUERY.toString();
    }
}

