/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.interfaces;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatus;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatusSet;

public class IngestStatuses {
    public static final String _rcsid = "@(#)$Id: IngestStatuses.java 1612102 2014-07-20 15:20:42Z kwright $";
    protected final Map<OutputKey, DocumentIngestStatusSet> statuses = new HashMap<OutputKey, DocumentIngestStatusSet>();

    public void addStatus(String documentClass, String documentIDHash, String outputConnectionName, String componentIDHash, DocumentIngestStatus status) {
        OutputKey ok = new OutputKey(documentClass, documentIDHash, outputConnectionName);
        DocumentIngestStatusSet set = this.statuses.get(ok);
        if (set == null) {
            set = new DocumentIngestStatusSet();
            this.statuses.put(ok, set);
        }
        set.addDocumentStatus(componentIDHash, status);
    }

    public DocumentIngestStatusSet getStatus(String documentClass, String documentIDHash, String outputConnectionName) {
        return this.statuses.get(new OutputKey(documentClass, documentIDHash, outputConnectionName));
    }

    protected static class OutputKey {
        protected final String documentClass;
        protected final String documentIDHash;
        protected final String outputConnectionName;

        public OutputKey(String documentClass, String documentIDHash, String outputConnectionName) {
            this.documentClass = documentClass;
            this.documentIDHash = documentIDHash;
            this.outputConnectionName = outputConnectionName;
        }

        public String getDocumentClass() {
            return this.documentClass;
        }

        public String getDocumentIDHash() {
            return this.documentIDHash;
        }

        public String getOutputConnectionName() {
            return this.outputConnectionName;
        }

        public int hashCode() {
            return this.documentClass.hashCode() + this.documentIDHash.hashCode() + this.outputConnectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof OutputKey)) {
                return false;
            }
            OutputKey dis = (OutputKey)o;
            return dis.documentClass.equals(this.documentClass) && dis.documentIDHash.equals(this.documentIDHash) && dis.outputConnectionName.equals(this.outputConnectionName);
        }
    }
}

