/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAVLDiskLarge;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL
implements PersistentStore {
    DataFileCache cache;
    RowOutputInterface rowOut;
    boolean largeData;

    public RowStoreAVLDisk(PersistentStoreCollection persistentStoreCollection, DataFileCache dataFileCache, Table table) {
        this(persistentStoreCollection, table);
        this.cache = dataFileCache;
        this.rowOut = dataFileCache.rowOut.duplicate();
        dataFileCache.adjustStoreCount(1);
        this.largeData = this.database.logger.propLargeData;
        this.tableSpace = dataFileCache.spaceManager.getTableSpace(table.getSpaceID());
    }

    protected RowStoreAVLDisk(PersistentStoreCollection persistentStoreCollection, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        persistentStoreCollection.setStore(table, this);
        this.largeData = this.database.logger.getDataFileFactor() > 1;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject cachedObject) {
        this.database.txManager.setTransactionInfo(this, cachedObject);
    }

    @Override
    public CachedObject get(long l) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, false);
        return cachedObject;
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        int n = cachedObject.getRealSize(this.rowOut);
        n += this.indexList.length * 16;
        n = this.rowOut.getStorageSize(n);
        cachedObject.setStorageSize(n);
        long l = this.tableSpace.getFilePosition(n, false);
        cachedObject.setPos(l);
        if (bl) {
            RowAction rowAction;
            Row row = (Row)cachedObject;
            row.rowAction = rowAction = new RowAction(session, this.table, 1, row, null);
            this.database.txManager.addTransactionInfo(cachedObject);
        }
        this.cache.add(cachedObject);
        this.storageSize += (long)n;
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            if (this.largeData) {
                return new RowAVLDiskLarge(this.table, rowInputInterface);
            }
            return new RowAVLDisk(this.table, rowInputInterface);
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDisk rowAVLDisk = this.largeData ? new RowAVLDiskLarge(this.table, (Object[])object, this) : new RowAVLDisk(this.table, (Object[])object, this);
        this.add(session, rowAVLDisk, bl);
        return rowAVLDisk;
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.indexRow(session, row);
            row.keepInMemory(false);
        }
        catch (HsqlException hsqlException) {
            this.database.txManager.removeTransactionInfo(row);
            throw hsqlException;
        }
    }

    @Override
    public void removeAll() {
        this.elementCount.set(0L);
        this.cache.spaceManager.freeTableSpace(this.tableSpace.getSpaceID());
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject cachedObject) {
        this.cache.remove(cachedObject);
        this.tableSpace.release(cachedObject.getPos(), cachedObject.getStorageSize());
        this.storageSize -= (long)cachedObject.getStorageSize();
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                if (n2 != 0) break;
                this.remove(row);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row);
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row);
                break;
            }
            case 4: {
                if (n2 != 0) {
                    this.delete(session, row);
                    this.database.txManager.removeTransactionInfo(row);
                }
                this.remove(row);
            }
        }
    }

    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
        this.database.txManager.removeTransactionInfo(rowAction.getPos());
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void release() {
        this.cache.adjustStoreCount(-1);
        this.cache = null;
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[index.getPosition()];
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = (RowAVL)this.get((CachedObject)nodeAVL.getRow(this), false);
        nodeAVL = rowAVL.getNode(index.getPosition());
        this.accessorList[index.getPosition()] = nodeAVL;
        return nodeAVL;
    }

    @Override
    public void setAccessor(Index index, long l) {
        CachedObject cachedObject = this.get(l, false);
        if (cachedObject != null) {
            NodeAVL nodeAVL = ((RowAVL)cachedObject).getNode(index.getPosition());
            cachedObject = nodeAVL;
        }
        this.setAccessor(index, cachedObject);
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveDataToSpace(Session session) {
        Table table = (Table)this.table;
        long l = this.elementCount();
        if (l == 0L) {
            return;
        }
        if (l > Integer.MAX_VALUE) {
            return;
        }
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex((int)l, false);
        doubleIntIndex.setKeysSearchTarget();
        this.cache.writeLock.lock();
        try {
            this.moveDataToSpace(this.cache, doubleIntIndex);
            CachedObject[] cachedObjectArray = new CachedObject[this.accessorList.length];
            for (int i = 0; i < this.accessorList.length; ++i) {
                long l2 = doubleIntIndex.lookup(this.accessorList[i].getPos());
                if (l2 == -1L) {
                    throw Error.error(466);
                }
                cachedObjectArray[i] = this.cache.get(l2, (PersistentStore)this, false);
            }
            RowIterator rowIterator = this.rowIterator();
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                this.cache.remove(row);
                this.tableSpace.release(row.getPos(), row.getStorageSize());
            }
            this.accessorList = cachedObjectArray;
        }
        finally {
            this.cache.writeLock.unlock();
        }
        this.database.logger.logDetailEvent("table written " + table.getName().name);
    }

    public void moveDataToSpace(DataFileCache dataFileCache, LongLookup longLookup) {
        long l;
        Row row;
        int n = this.table.getSpaceID();
        TableSpaceManager tableSpaceManager = dataFileCache.spaceManager.getTableSpace(n);
        RowIterator rowIterator = this.rowIterator();
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            l = tableSpaceManager.getFilePosition(row.getStorageSize(), false);
            longLookup.addUnsorted(row.getPos(), l);
        }
        rowIterator = this.rowIterator();
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            dataFileCache.rowOut.reset();
            row.write(dataFileCache.rowOut, longLookup);
            l = longLookup.lookup(row.getPos());
            dataFileCache.saveRowOutput(l);
        }
    }

    long getStorageSizeEstimate() {
        if (this.elementCount.get() == 0L) {
            return 0L;
        }
        CachedObject cachedObject = this.getAccessor(this.indexList[0]);
        CachedObject cachedObject2 = this.get(cachedObject.getPos());
        return (long)cachedObject2.getStorageSize() * this.elementCount.get();
    }

    @Override
    public void writeLock() {
        this.cache.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.cache.writeLock.unlock();
    }
}

