/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class DefineTransformationConnection {
    public static final String _rcsid = "@(#)$Id$";

    private DefineTransformationConnection() {
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: DefineTransformationConnection <connection_name> <description> <connector_class> <pool_max> <param1>=<value1> ...");
            System.exit(1);
        }
        String connectionName = args[0];
        String description = args[1];
        String connectorClass = args[2];
        String poolMax = args[3];
        try {
            IThreadContext tc = ThreadContextFactory.make();
            ManifoldCF.initializeEnvironment(tc);
            ITransformationConnectionManager mgr = TransformationConnectionManagerFactory.make(tc);
            ITransformationConnection conn = mgr.create();
            conn.setName(connectionName);
            conn.setDescription(description);
            conn.setClassName(connectorClass);
            conn.setMaxConnections(new Integer(poolMax));
            ConfigParams x = conn.getConfigParams();
            int i = 4;
            while (i < args.length) {
                String arg;
                int pos;
                if ((pos = (arg = args[i++]).indexOf("=")) == -1) {
                    throw new ManifoldCFException("Argument missing =");
                }
                String name = arg.substring(0, pos);
                String value = arg.substring(pos + 1);
                if (name.endsWith("assword")) {
                    x.setObfuscatedParameter(name, value);
                    continue;
                }
                x.setParameter(name, value);
            }
            mgr.save(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

