/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.TransactionalAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class RegisterOutput
extends TransactionalAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: RegisterOutput.java 988245 2010-08-23 18:39:35Z kwright $";
    private final String className;
    private final String description;

    public RegisterOutput(String className, String description) {
        this.className = className;
        this.description = description;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IOutputConnectorManager mgr = OutputConnectorManagerFactory.make(tc);
        IOutputConnectionManager connManager = OutputConnectionManagerFactory.make(tc);
        mgr.registerConnector(this.description, this.className);
        String[] connectionNames = connManager.findConnectionsForConnector(this.className);
        AgentManagerFactory.noteOutputConnectorRegistration(tc, connectionNames);
        Logging.root.info((Object)("Successfully registered output connector '" + this.className + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: RegisterOutput <classname> <description>");
            System.exit(1);
        }
        String className = args[0];
        String description = args[1];
        try {
            RegisterOutput registerOutput = new RegisterOutput(className, description);
            registerOutput.execute();
            System.err.println("Successfully registered output connector '" + className + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

