/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.manifoldcf.agents.output.solr.ModifiedHttp2SolrClient;
import org.apache.manifoldcf.agents.output.solr.ModifiedLBSolrClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.MDC;

public class ModifiedLBHttp2SolrClient
extends ModifiedLBSolrClient {
    private static final long serialVersionUID = -1147138830059067321L;
    private final ModifiedHttp2SolrClient httpClient;

    public ModifiedLBHttp2SolrClient(ModifiedHttp2SolrClient httpClient, String ... baseSolrUrls) {
        super(Arrays.asList(baseSolrUrls));
        this.httpClient = httpClient;
    }

    @Override
    protected SolrClient getClient(String baseUrl) {
        return this.httpClient;
    }

    @Override
    public void setParser(ResponseParser parser) {
        super.setParser(parser);
        this.httpClient.setParser(parser);
    }

    @Override
    public void setRequestWriter(RequestWriter writer) {
        super.setRequestWriter(writer);
        this.httpClient.setRequestWriter(writer);
    }

    @Override
    public void setQueryParams(Set<String> queryParams) {
        super.setQueryParams(queryParams);
        this.httpClient.setQueryParams(queryParams);
    }

    @Override
    public void addQueryParams(String queryOnlyParam) {
        super.addQueryParams(queryOnlyParam);
        this.httpClient.setQueryParams(this.getQueryParams());
    }

    public Cancellable asyncReq(final ModifiedLBSolrClient.Req req, final AsyncListener<ModifiedLBSolrClient.Rsp> asyncListener) {
        final ModifiedLBSolrClient.Rsp rsp = new ModifiedLBSolrClient.Rsp();
        final boolean isNonRetryable = req.request instanceof IsUpdateRequest || CommonParams.ADMIN_PATHS.contains(req.request.getPath());
        final ModifiedLBSolrClient.ServerIterator it = new ModifiedLBSolrClient.ServerIterator(req, this.zombieServers);
        asyncListener.onStart();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final AtomicReference<Cancellable> currentCancellable = new AtomicReference<Cancellable>();
        RetryListener retryListener = new RetryListener(){

            @Override
            public void onSuccess(ModifiedLBSolrClient.Rsp rsp2) {
                asyncListener.onSuccess((Object)rsp2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e, boolean retryReq) {
                block12: {
                    if (retryReq) {
                        String url;
                        try {
                            url = it.nextOrError(e);
                        }
                        catch (SolrServerException ex) {
                            asyncListener.onFailure((Throwable)e);
                            return;
                        }
                        try {
                            MDC.put((String)"ModifiedLBSolrClient.url", (String)url);
                            AtomicBoolean atomicBoolean = cancelled;
                            synchronized (atomicBoolean) {
                                block11: {
                                    if (!cancelled.get()) break block11;
                                    return;
                                }
                                Cancellable cancellable = ModifiedLBHttp2SolrClient.this.doRequest(url, req, rsp, isNonRetryable, it.isServingZombieServer(), this);
                                currentCancellable.set(cancellable);
                                break block12;
                            }
                        }
                        finally {
                            MDC.remove((String)"ModifiedLBSolrClient.url");
                        }
                    }
                    asyncListener.onFailure((Throwable)e);
                }
            }
        };
        try {
            Cancellable cancellable = this.doRequest(it.nextOrError(), req, rsp, isNonRetryable, it.isServingZombieServer(), retryListener);
            currentCancellable.set(cancellable);
        }
        catch (SolrServerException e) {
            asyncListener.onFailure((Throwable)e);
        }
        return () -> {
            AtomicBoolean atomicBoolean = cancelled;
            synchronized (atomicBoolean) {
                cancelled.set(true);
                if (currentCancellable.get() != null) {
                    ((Cancellable)currentCancellable.get()).cancel();
                }
            }
        };
    }

    private Cancellable doRequest(final String baseUrl, ModifiedLBSolrClient.Req req, final ModifiedLBSolrClient.Rsp rsp, final boolean isNonRetryable, final boolean isZombie, final RetryListener listener) {
        rsp.server = baseUrl;
        req.getRequest().setBasePath(baseUrl);
        return ((ModifiedHttp2SolrClient)this.getClient(baseUrl)).asyncRequest(req.getRequest(), null, new AsyncListener<NamedList<Object>>(){

            public void onSuccess(NamedList<Object> result) {
                rsp.rsp = result;
                if (isZombie) {
                    ModifiedLBHttp2SolrClient.this.zombieServers.remove(baseUrl);
                }
                listener.onSuccess(rsp);
            }

            public void onFailure(Throwable oe) {
                try {
                    throw (Exception)oe;
                }
                catch (BaseHttpSolrClient.RemoteExecutionException e) {
                    listener.onFailure((Exception)((Object)e), false);
                }
                catch (SolrException e) {
                    if (!isNonRetryable && ModifiedLBSolrClient.RETRY_CODES.contains(e.code())) {
                        listener.onFailure((Exception)(!isZombie ? ModifiedLBHttp2SolrClient.this.addZombie(baseUrl, (Exception)((Object)e)) : e), true);
                    } else {
                        if (isZombie) {
                            ModifiedLBHttp2SolrClient.this.zombieServers.remove(baseUrl);
                        }
                        listener.onFailure((Exception)((Object)e), false);
                    }
                }
                catch (SocketException e) {
                    if (!isNonRetryable || e instanceof ConnectException) {
                        listener.onFailure(!isZombie ? ModifiedLBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else {
                        listener.onFailure(e, false);
                    }
                }
                catch (SocketTimeoutException e) {
                    if (!isNonRetryable) {
                        listener.onFailure(!isZombie ? ModifiedLBHttp2SolrClient.this.addZombie(baseUrl, e) : e, true);
                    } else {
                        listener.onFailure(e, false);
                    }
                }
                catch (SolrServerException e) {
                    Throwable rootCause = e.getRootCause();
                    if (!isNonRetryable && rootCause instanceof IOException) {
                        listener.onFailure((Exception)(!isZombie ? ModifiedLBHttp2SolrClient.this.addZombie(baseUrl, (Exception)((Object)e)) : e), true);
                    } else if (isNonRetryable && rootCause instanceof ConnectException) {
                        listener.onFailure((Exception)(!isZombie ? ModifiedLBHttp2SolrClient.this.addZombie(baseUrl, (Exception)((Object)e)) : e), true);
                    } else {
                        listener.onFailure((Exception)((Object)e), false);
                    }
                }
                catch (Exception e) {
                    listener.onFailure((Exception)((Object)new SolrServerException((Throwable)e)), false);
                }
            }
        });
    }

    private static interface RetryListener {
        public void onSuccess(ModifiedLBSolrClient.Rsp var1);

        public void onFailure(Exception var1, boolean var2);
    }
}

