/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.EnumeratedValues;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.ScheduleRecord;
import org.apache.manifoldcf.crawler.jobs.JobDescription;

public class ScheduleManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: ScheduleManager.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String ownerIDField = "ownerid";
    public static final String ordinalField = "ordinal";
    public static final String dayOfWeekField = "dayofweek";
    public static final String dayOfMonthField = "dayofmonth";
    public static final String monthOfYearField = "monthofyear";
    public static final String yearField = "yearlist";
    public static final String hourOfDayField = "hourofday";
    public static final String minutesOfHourField = "minutesofhour";
    public static final String timezoneField = "timezone";
    public static final String windowDurationField = "windowlength";
    public static final String requestMinimumField = "requestminimum";

    public ScheduleManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "schedules");
    }

    public void install(String ownerTable, String owningTablePrimaryKey) throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerIDField, new ColumnDescription("BIGINT", false, false, ownerTable, owningTablePrimaryKey, false));
                map.put(ordinalField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(dayOfWeekField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(dayOfMonthField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(monthOfYearField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(yearField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(hourOfDayField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(minutesOfHourField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(timezoneField, new ColumnDescription("VARCHAR(32)", false, true, null, null, false));
                map.put(windowDurationField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(requestMinimumField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription ownerIndex = new IndexDescription(false, new String[]{ownerIDField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex == null) break block3;
            this.performAddIndex(null, ownerIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void getRows(Map<Long, JobDescription> returnValues, String ownerIDList, ArrayList ownerIDParams) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE ownerid IN (" + ownerIDList + ") ORDER BY ordinal ASC", ownerIDParams, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long ownerID = (Long)row.getValue(ownerIDField);
            ScheduleRecord sr = new ScheduleRecord(ScheduleManager.stringToEnumeratedValue((String)row.getValue(dayOfWeekField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(monthOfYearField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(dayOfMonthField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(yearField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(hourOfDayField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(minutesOfHourField)), (String)row.getValue(timezoneField), (Long)row.getValue(windowDurationField), ScheduleManager.stringToRequestMinimumValue((String)row.getValue(requestMinimumField)));
            returnValues.get(ownerID).addScheduleRecord(sr);
        }
    }

    public int maxClauseGetRowsAlternate() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    public void getRowsAlternate(Map returnValues, ArrayList ownerIDParams) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(ownerIDField, (List)ownerIDParams)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query + " ORDER BY ordinal ASC", list, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long ownerID = (Long)row.getValue(ownerIDField);
            ScheduleRecord sr = new ScheduleRecord(ScheduleManager.stringToEnumeratedValue((String)row.getValue(dayOfWeekField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(monthOfYearField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(dayOfMonthField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(yearField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(hourOfDayField)), ScheduleManager.stringToEnumeratedValue((String)row.getValue(minutesOfHourField)), (String)row.getValue(timezoneField), (Long)row.getValue(windowDurationField), ScheduleManager.stringToRequestMinimumValue((String)row.getValue(requestMinimumField)));
            ArrayList<ScheduleRecord> theList = (ArrayList<ScheduleRecord>)returnValues.get(ownerID);
            if (theList == null) {
                theList = new ArrayList<ScheduleRecord>();
                returnValues.put(ownerID, theList);
            }
            theList.add(sr);
        }
    }

    public void writeRows(Long ownerID, IJobDescription list) throws ManifoldCFException {
        this.beginTransaction();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < list.getScheduleRecordCount(); ++i) {
                ScheduleRecord record = list.getScheduleRecord(i);
                map.clear();
                map.put(dayOfWeekField, ScheduleManager.enumeratedValueToString(record.getDayOfWeek()));
                map.put(monthOfYearField, ScheduleManager.enumeratedValueToString(record.getMonthOfYear()));
                map.put(dayOfMonthField, ScheduleManager.enumeratedValueToString(record.getDayOfMonth()));
                map.put(yearField, ScheduleManager.enumeratedValueToString(record.getYear()));
                map.put(hourOfDayField, ScheduleManager.enumeratedValueToString(record.getHourOfDay()));
                map.put(minutesOfHourField, ScheduleManager.enumeratedValueToString(record.getMinutesOfHour()));
                map.put(timezoneField, record.getTimezone());
                map.put(windowDurationField, record.getDuration());
                map.put(requestMinimumField, ScheduleManager.requestMinimumValueToString(record.getRequestMinimum()));
                map.put(ownerIDField, ownerID);
                map.put(ordinalField, new Long(i));
                this.performInsert(map, null);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteRows(Long ownerID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)});
        this.performDelete("WHERE " + query, list, null);
    }

    public static EnumeratedValues stringToEnumeratedValue(String value) throws ManifoldCFException {
        if (value == null) {
            return null;
        }
        try {
            ArrayList<Integer> valStore = new ArrayList<Integer>();
            if (!value.equals("*")) {
                int curpos = 0;
                while (true) {
                    int newpos;
                    if ((newpos = value.indexOf(",", curpos)) == -1) {
                        valStore.add(new Integer(value.substring(curpos)));
                        break;
                    }
                    valStore.add(new Integer(value.substring(curpos, newpos)));
                    curpos = newpos + 1;
                }
            }
            return new EnumeratedValues(valStore);
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Bad number: '" + value + "'", (Throwable)e);
        }
    }

    public static String enumeratedValueToString(EnumeratedValues values) {
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "*";
        }
        StringBuilder rval = new StringBuilder();
        Iterator iter = values.getValues();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                rval.append(',');
            }
            rval.append(((Integer)iter.next()).toString());
        }
        return rval.toString();
    }

    public static String requestMinimumValueToString(boolean requestMinimum) {
        return requestMinimum ? "T" : "F";
    }

    public static boolean stringToRequestMinimumValue(String requestMinimum) throws ManifoldCFException {
        if (requestMinimum == null) {
            return false;
        }
        if (requestMinimum.equals("T")) {
            return true;
        }
        if (requestMinimum.equals("F")) {
            return false;
        }
        throw new ManifoldCFException("Bad requestminimum value: '" + requestMinimum + "'");
    }
}

