/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.InitializationCommand;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public abstract class TransactionalAgentsInitializationCommand
implements InitializationCommand {
    public void execute() throws ManifoldCFException {
        IThreadContext tc = ThreadContextFactory.make();
        ManifoldCF.initializeEnvironment(tc);
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        try {
            database.beginTransaction();
            this.doExecute(tc);
        }
        catch (ManifoldCFException e) {
            database.signalRollback();
            throw e;
        }
        catch (Error e) {
            database.signalRollback();
            throw e;
        }
        finally {
            database.endTransaction();
        }
    }

    protected abstract void doExecute(IThreadContext var1) throws ManifoldCFException;
}

