/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.confluence.v6;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.Messages;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.client.ConfluenceClient;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Attachment;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceResponse;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceRestrictionsResponse;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Page;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.PageType;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Restrictions;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.Space;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.util.ConfluenceUtil;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceRepositoryConnector
extends BaseRepositoryConnector {
    protected static final String ACTIVITY_READ = "read document";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    private static final String CHILD_PREFIX = "child+";
    private static final String PARAMETER_PREFIX = "confluence_";
    private static final String CONF_SERVER_TAB_PROPERTY = "ConfluenceRepositoryConnector.Server";
    private static final String CONF_SECURITY_TAB_PROPERTY = "ConfluenceRepositoryConnector.Security";
    private static final String CONF_SPACES_TAB_PROPERTY = "ConfluenceRepositoryConnector.Spaces";
    private static final String CONF_PAGES_TAB_PROPERTY = "ConfluenceRepositoryConnector.Pages";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_conf.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_conf_server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_conf.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification_conf.js";
    private static final String EDIT_SPEC_FORWARD_SECURITY = "editSpecification_confSecurity.html";
    private static final String EDIT_SPEC_FORWARD_SPACES = "editSpecification_confSpaces.html";
    private static final String EDIT_SPEC_FORWARD_CONF_PAGES = "editSpecification_confPages.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification_conf.html";
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected static final long interruptionRetryTime = 300000L;
    private final Logger logger = LoggerFactory.getLogger(ConfluenceRepositoryConnector.class);
    protected String protocol = null;
    protected String host = null;
    protected String port = null;
    protected String path = null;
    protected String username = null;
    protected String password = null;
    protected String socketTimeout = null;
    protected String connectionTimeout = null;
    protected String retryIntervalString = null;
    protected String retryNumberString = null;
    protected String proxyUsername = null;
    protected String proxyPassword = null;
    protected String proxyProtocol = null;
    protected String proxyHost = null;
    protected String proxyPort = null;
    protected long retryInterval = -1L;
    protected int retryNumber = -1;
    protected ConfluenceClient confluenceClient = null;

    public void setConfluenceClient(ConfluenceClient confluenceClient) {
        this.confluenceClient = confluenceClient;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.host};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.confluenceClient != null) {
            this.confluenceClient = null;
        }
        this.protocol = null;
        this.host = null;
        this.port = null;
        this.path = null;
        this.username = null;
        this.password = null;
        this.socketTimeout = null;
        this.connectionTimeout = null;
        this.retryIntervalString = null;
        this.retryNumberString = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.proxyProtocol = null;
        this.proxyHost = null;
        this.proxyPort = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.protocol = this.params.getParameter("protocol");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.username = this.params.getParameter("username");
        this.password = this.params.getObfuscatedParameter("password");
        this.socketTimeout = this.params.getParameter("socket_timeout");
        this.connectionTimeout = this.params.getParameter("connection_timeout");
        this.retryIntervalString = configParams.getParameter("retryInterval");
        this.retryNumberString = configParams.getParameter("retryNumber");
        this.proxyUsername = this.params.getParameter("proxy_username");
        this.proxyPassword = this.params.getObfuscatedParameter("proxy_password");
        this.proxyProtocol = this.params.getParameter("proxy_port");
        this.proxyHost = this.params.getParameter("proxy_host");
        this.proxyPort = this.params.getParameter("proxy_port");
        try {
            this.initConfluenceClient();
        }
        catch (ManifoldCFException e) {
            this.logger.debug("Not possible to initialize Confluence client. Reason: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public String check() throws ManifoldCFException {
        try {
            Boolean result;
            if (!this.isConnected()) {
                this.initConfluenceClient();
            }
            if ((result = Boolean.valueOf(this.confluenceClient.check())).booleanValue()) {
                return super.check();
            }
            throw new ManifoldCFException("Confluence instance could not be reached");
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
        catch (Exception e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void initConfluenceClient() throws ManifoldCFException {
        if (this.confluenceClient == null) {
            int proxyPortInt;
            int connectionTimeoutInt;
            int socketTimeoutInt;
            int portInt;
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence protocol = '" + this.protocol + "'"));
            }
            if (StringUtils.isEmpty((String)this.host)) {
                throw new ManifoldCFException("Parameter host required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence host = '" + this.host + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence port = '" + this.port + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence path = '" + this.path + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence username = '" + this.username + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence password '" + this.password != null ? "set" : "not set'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence socket timeout = '" + this.socketTimeout + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Confluence connection timeout = '" + this.connectionTimeout + "'"));
            }
            if (this.port != null && this.port.length() > 0) {
                try {
                    portInt = Integer.parseInt(this.port);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                portInt = this.protocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
            }
            if (this.socketTimeout != null && this.socketTimeout.length() > 0) {
                try {
                    socketTimeoutInt = Integer.parseInt(this.socketTimeout);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                socketTimeoutInt = 900000;
            }
            if (this.connectionTimeout != null && this.connectionTimeout.length() > 0) {
                try {
                    connectionTimeoutInt = Integer.parseInt(this.connectionTimeout);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                connectionTimeoutInt = 60000;
            }
            try {
                this.retryInterval = Long.parseLong(this.retryIntervalString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad retry interval number: " + this.retryIntervalString);
            }
            try {
                this.retryNumber = Integer.parseInt(this.retryNumberString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad retry number: " + this.retryNumberString);
            }
            if (this.proxyPort != null && this.proxyPort.length() > 0) {
                try {
                    proxyPortInt = Integer.parseInt(this.proxyPort);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                proxyPortInt = -1;
            }
            this.confluenceClient = new ConfluenceClient(this.protocol, this.host, portInt, this.path, this.username, this.password, socketTimeoutInt, connectionTimeoutInt, this.proxyUsername, this.proxyPassword, this.proxyProtocol, this.proxyHost, proxyPortInt);
            this.lastSessionFetch = System.currentTimeMillis();
        }
    }

    public boolean isConnected() {
        return this.confluenceClient != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.confluenceClient.close();
            this.confluenceClient = null;
            this.lastSessionFetch = -1L;
        }
    }

    public int getMaxDocumentRequest() {
        return super.getMaxDocumentRequest();
    }

    public String[] getRelationshipTypes() {
        return new String[0];
    }

    private void fillInServerConfigurationMap(Map<String, String> serverMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String confluenceProtocol = parameters.getParameter("protocol");
        String confluenceHost = parameters.getParameter("host");
        String confluencePort = parameters.getParameter("port");
        String confluencePath = parameters.getParameter("path");
        String confluenceUsername = parameters.getParameter("username");
        String confluencePassword = parameters.getObfuscatedParameter("password");
        String confluenceSocketTimeout = parameters.getParameter("socket_timeout");
        String confluenceConnectionTimeout = parameters.getParameter("connection_timeout");
        String confluenceRetryNumber = parameters.getParameter("retryNumber");
        String confluenceRetryInterval = parameters.getParameter("retryInterval");
        String confluenceProxyUsername = parameters.getParameter("proxy_username");
        String confluenceProxyPassword = parameters.getObfuscatedParameter("proxy_password");
        String confluenceProxyProtocol = parameters.getParameter("proxy_protocol");
        String confluenceProxyHost = parameters.getParameter("proxy_host");
        String confluenceProxyPort = parameters.getParameter("proxy_port");
        if (confluenceProtocol == null) {
            confluenceProtocol = "http";
        }
        if (confluenceHost == null) {
            confluenceHost = "";
        }
        if (confluencePort == null) {
            confluencePort = "8090";
        }
        if (confluencePath == null) {
            confluencePath = "/confluence";
        }
        if (confluenceUsername == null) {
            confluenceUsername = "";
        }
        confluencePassword = confluencePassword == null ? "" : mapper.mapPasswordToKey(confluencePassword);
        if (confluenceSocketTimeout == null) {
            confluenceSocketTimeout = "900000";
        }
        if (confluenceConnectionTimeout == null) {
            confluenceConnectionTimeout = "60000";
        }
        if (confluenceRetryNumber == null) {
            confluenceRetryNumber = "2";
        }
        if (confluenceRetryInterval == null) {
            confluenceRetryInterval = "20000";
        }
        if (confluenceProxyUsername == null) {
            confluenceProxyUsername = "";
        }
        confluenceProxyPassword = confluenceProxyPassword == null ? "" : mapper.mapPasswordToKey(confluenceProxyPassword);
        if (confluenceProxyProtocol == null) {
            confluenceProxyProtocol = "http";
        }
        if (confluenceProxyHost == null) {
            confluenceProxyHost = "";
        }
        if (confluenceProxyPort == null) {
            confluenceProxyPort = "";
        }
        serverMap.put("confluence_protocol", confluenceProtocol);
        serverMap.put("confluence_host", confluenceHost);
        serverMap.put("confluence_port", confluencePort);
        serverMap.put("confluence_path", confluencePath);
        serverMap.put("confluence_username", confluenceUsername);
        serverMap.put("confluence_password", confluencePassword);
        serverMap.put("confluence_socket_timeout", confluenceSocketTimeout);
        serverMap.put("confluence_connection_timeout", confluenceConnectionTimeout);
        serverMap.put("confluence_retryNumber", confluenceRetryNumber);
        serverMap.put("confluence_retryInterval", confluenceRetryInterval);
        serverMap.put("confluence_proxy_username", confluenceProxyUsername);
        serverMap.put("confluence_proxy_password", confluenceProxyPassword);
        serverMap.put("confluence_proxy_protocol", confluenceProxyProtocol);
        serverMap.put("confluence_proxy_host", confluenceProxyHost);
        serverMap.put("confluence_proxy_port", confluenceProxyPort);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap, true);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CONF_SERVER_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap, true);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String confluenceProxyPassword;
        String confluenceProxyUsername;
        String confluenceProxyPort;
        String confluenceProxyHost;
        String confluenceProxyProtocol;
        String confluenceRetryInterval;
        String confluenceRetryNumber;
        String confluenceConnectionTimeout;
        String confluenceSocketTimeout;
        String confluencePassword;
        String confluenceUsername;
        String confluencePath;
        String confluencePort;
        String confluenceHost;
        String confluenceProtocol = variableContext.getParameter("confluence_protocol");
        if (confluenceProtocol != null) {
            parameters.setParameter("protocol", confluenceProtocol);
        }
        if ((confluenceHost = variableContext.getParameter("confluence_host")) != null) {
            parameters.setParameter("host", confluenceHost);
        }
        if ((confluencePort = variableContext.getParameter("confluence_port")) != null) {
            parameters.setParameter("port", confluencePort);
        }
        if ((confluencePath = variableContext.getParameter("confluence_path")) != null) {
            parameters.setParameter("path", confluencePath);
        }
        if ((confluenceUsername = variableContext.getParameter("confluence_username")) != null) {
            parameters.setParameter("username", confluenceUsername);
        }
        if ((confluencePassword = variableContext.getParameter("confluence_password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(confluencePassword));
        }
        if ((confluenceSocketTimeout = variableContext.getParameter("confluence_socket_timeout")) != null) {
            parameters.setParameter("socket_timeout", confluenceSocketTimeout);
        }
        if ((confluenceConnectionTimeout = variableContext.getParameter("confluence_connection_timeout")) != null) {
            parameters.setParameter("connection_timeout", confluenceConnectionTimeout);
        }
        if ((confluenceRetryNumber = variableContext.getParameter("confluence_retryNumber")) != null) {
            parameters.setParameter("retryNumber", confluenceRetryNumber);
        }
        if ((confluenceRetryInterval = variableContext.getParameter("confluence_retryInterval")) != null) {
            parameters.setParameter("retryInterval", confluenceRetryInterval);
        }
        if ((confluenceProxyProtocol = variableContext.getParameter("confluence_proxy_protocol")) != null) {
            parameters.setParameter("proxy_protocol", confluenceProxyProtocol);
        }
        if ((confluenceProxyHost = variableContext.getParameter("confluence_proxy_host")) != null) {
            parameters.setParameter("proxy_host", confluenceProxyHost);
        }
        if ((confluenceProxyPort = variableContext.getParameter("confluence_proxy_port")) != null) {
            parameters.setParameter("proxy_port", confluenceProxyPort);
        }
        if ((confluenceProxyUsername = variableContext.getParameter("confluence_proxy_username")) != null) {
            parameters.setParameter("proxy_username", confluenceProxyUsername);
        }
        if ((confluenceProxyPassword = variableContext.getParameter("confluence_proxy_password")) != null) {
            parameters.setObfuscatedParameter("proxy_password", variableContext.mapKeyToPassword(confluenceProxyPassword));
        }
        return null;
    }

    private void fillInConfSpacesSpecificationMap(Map<String, Object> newMap, ConfluenceSpecification cs) {
        newMap.put("spaces".toUpperCase(Locale.ROOT), cs.getSpaces());
    }

    private void fillInConfSecuritySpecificationMap(Map<String, Object> newMap, ConfluenceSpecification cs) {
        newMap.put("activate_security".toUpperCase(Locale.ROOT), cs.isSecurityActive().toString());
    }

    private void fillInConfPagesSpecificationMap(Map<String, Object> newMap, ConfluenceSpecification cs) {
        newMap.put("process_attachments".toUpperCase(Locale.ROOT), cs.isProcessAttachments().toString());
        newMap.put("pagetype".toUpperCase(Locale.ROOT), cs.getPageType());
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        ConfluenceSpecification cs = ConfluenceSpecification.from(ds);
        this.fillInConfSecuritySpecificationMap(paramMap, cs);
        this.fillInConfSpacesSpecificationMap(paramMap, cs);
        this.fillInConfPagesSpecificationMap(paramMap, cs);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPEC_FORWARD, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String pageType;
        SpecificationNode sn;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String xc = variableContext.getParameter(seqPrefix + "spacescount");
        if (xc != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("spaces")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode spaces = new SpecificationNode("spaces");
            ds.addChild(ds.getChildCount(), (ConfigurationNode)spaces);
            int spacesCount = Integer.parseInt(xc);
            i = 0;
            while (i < spacesCount) {
                String spaceDescription = "_" + Integer.toString(i);
                String spaceOpName = seqPrefix + "spaceop" + spaceDescription;
                xc = variableContext.getParameter(spaceOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String spaceKey = variableContext.getParameter(seqPrefix + "space" + spaceDescription);
                SpecificationNode node = new SpecificationNode("space");
                node.setAttribute("key", spaceKey);
                spaces.addChild(spaces.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "spaceop");
            if (op != null && op.equals("Add")) {
                String spaceSpec = variableContext.getParameter(seqPrefix + "space");
                SpecificationNode node = new SpecificationNode("space");
                node.setAttribute("key", spaceSpec);
                spaces.addChild(spaces.getChildCount(), (ConfigurationNode)node);
            }
        }
        i = 0;
        while (i < ds.getChildCount()) {
            sn = ds.getChild(i);
            if (sn.getType().equals("security")) {
                ds.removeChild(i);
                continue;
            }
            ++i;
        }
        SpecificationNode security = new SpecificationNode("security");
        ds.addChild(ds.getChildCount(), (ConfigurationNode)security);
        String activateSecurity = variableContext.getParameter(seqPrefix + "activate_security");
        if (activateSecurity != null && !activateSecurity.isEmpty()) {
            security.setAttribute("activate_security", String.valueOf(activateSecurity));
        }
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn2 = ds.getChild(i);
            if (sn2.getType().equals("pages")) {
                ds.removeChild(i);
                continue;
            }
            ++i;
        }
        SpecificationNode pages = new SpecificationNode("pages");
        ds.addChild(ds.getChildCount(), (ConfigurationNode)pages);
        String procAttachments = variableContext.getParameter(seqPrefix + "process_attachments");
        if (procAttachments != null && !procAttachments.isEmpty()) {
            pages.setAttribute("process_attachments", String.valueOf(procAttachments));
        }
        if ((pageType = variableContext.getParameter(seqPrefix + "pagetype")) != null && !pageType.isEmpty()) {
            pages.setAttribute("pagetype", pageType);
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        ConfluenceSpecification cs = ConfluenceSpecification.from(ds);
        this.fillInConfSecuritySpecificationMap(paramMap, cs);
        this.fillInConfSpacesSpecificationMap(paramMap, cs);
        this.fillInConfPagesSpecificationMap(paramMap, cs);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_SECURITY, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_SPACES, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_CONF_PAGES, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CONF_SECURITY_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, CONF_SPACES_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, CONF_PAGES_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_HEADER_FORWARD, paramMap);
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        if (!this.isConnected()) {
            this.initConfluenceClient();
        }
        try {
            ConfluenceSpecification confluenceSpecification = ConfluenceSpecification.from(spec);
            List<String> spaceKeys = confluenceSpecification.getSpaces();
            String pageType = confluenceSpecification.getPageType();
            if (spaceKeys.isEmpty()) {
                this.logger.info("No spaces configured. Processing all spaces");
                spaceKeys = this.getAllSpaceKeys();
            }
            for (String space : spaceKeys) {
                this.logger.info("Processing configured space {}", (Object)space);
                this.addSeedDocumentsForSpace(space, (Optional<String>)Optional.of((Object)pageType), activities, confluenceSpecification, lastSeedVersion, seedTime, jobMode);
            }
            return "";
        }
        catch (Exception e) {
            ConfluenceRepositoryConnector.handleConfluenceDownException(e, "seeding");
            return null;
        }
    }

    private List<Page> getPageChilds(String pageId) throws ManifoldCFException, ServiceInterruption {
        long lastStart = 0L;
        long defaultSize = 25L;
        ArrayList<Page> pageChilds = new ArrayList<Page>();
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)new MessageFormat("Starting from {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 25L, "getPageChilds"}));
        }
        try {
            ConfluenceResponse<Page> response;
            Boolean isLast = true;
            while ((response = this.confluenceClient.getPageChilds((int)lastStart, 25, pageId)) != null) {
                int count = 0;
                for (Page page : response.getResults()) {
                    pageChilds.add(page);
                    ++count;
                }
                lastStart += (long)count;
                isLast = response.isLast();
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 25L, "getPageChilds"}));
                }
                if (!isLast.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            ConfluenceRepositoryConnector.handleConfluenceDownException(e, "seeding");
        }
        return pageChilds;
    }

    private List<Restrictions> getPageReadRestrictions(String pageId) throws ManifoldCFException, ServiceInterruption {
        long lastStart = 0L;
        long defaultSize = 200L;
        ArrayList<Restrictions> restrictionsList = new ArrayList<Restrictions>();
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)new MessageFormat("Starting from {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 200L, "getAllSpaceKeys"}));
        }
        try {
            ConfluenceRestrictionsResponse<Restrictions> response;
            Boolean isLast = true;
            while ((response = this.confluenceClient.getPageReadRestrictions((int)lastStart, 200, pageId)) != null) {
                if (response.getResult() != null) {
                    restrictionsList.add(response.getResult());
                }
                if (!(isLast = response.isLast()).booleanValue()) {
                    lastStart += 200L;
                }
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 200L, "getAllSpaceKeys"}));
                }
                if (!isLast.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            ConfluenceRepositoryConnector.handleConfluenceDownException(e, "seeding");
        }
        return restrictionsList;
    }

    private List<String> getAllSpaceKeys() throws ManifoldCFException, ServiceInterruption {
        ArrayList<String> spaceKeys = new ArrayList<String>();
        long lastStart = 0L;
        long defaultSize = 25L;
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)new MessageFormat("Starting from {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 25L, "getAllSpaceKeys"}));
        }
        try {
            ConfluenceResponse<Space> response;
            Boolean isLast = true;
            while ((response = this.confluenceClient.getSpaces((int)lastStart, 25, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent())) != null) {
                int count = 0;
                for (Space space : response.getResults()) {
                    spaceKeys.add(space.getKey());
                    ++count;
                }
                lastStart += (long)count;
                isLast = response.isLast();
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 25L, "getAllSpaceKeys"}));
                }
                if (!isLast.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            ConfluenceRepositoryConnector.handleConfluenceDownException(e, "seeding");
        }
        return spaceKeys;
    }

    private void addSeedDocumentsForSpace(String space, Optional<String> pageType, ISeedingActivity activities, ConfluenceSpecification confluenceSpec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long lastStart = 0L;
        long defaultSize = 50L;
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            String spaceDesc = "space with key " + space;
            Logging.connectors.debug((Object)new MessageFormat("Starting from {0} and size {1} for {2}", Locale.ROOT).format(new Object[]{lastStart, 50L, spaceDesc}));
        }
        try {
            ConfluenceResponse<Page> response;
            Boolean isLast = true;
            while ((response = this.confluenceClient.getSpaceRootPages((int)lastStart, 50, space, pageType)) != null) {
                int count = 0;
                for (Page page : response.getResults()) {
                    activities.addSeedDocument(page.getId());
                    if (confluenceSpec.isProcessAttachments().booleanValue()) {
                        this.processSeedAttachments(page, activities);
                    }
                    ++count;
                }
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("Fetched and added {0} seed documents", Locale.ROOT).format(new Object[]{new Integer(count)}));
                }
                lastStart += (long)count;
                isLast = response.isLast();
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1}", Locale.ROOT).format(new Object[]{lastStart, 50L}));
                }
                if (!isLast.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            ConfluenceRepositoryConnector.handleConfluenceDownException(e, "seeding");
        }
    }

    private void processSeedAttachments(Page page, ISeedingActivity activities) throws ManifoldCFException, ServiceInterruption {
        long lastStart = 0L;
        long defaultSize = 50L;
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)new MessageFormat("Processing page {} attachments starting from {} and size {}", Locale.ROOT).format(new Object[]{page.getId(), lastStart, 50L}));
        }
        try {
            ConfluenceResponse<Attachment> response;
            Boolean isLast = true;
            while ((response = this.confluenceClient.getPageAttachments(page.getId(), (int)lastStart, 50)) != null) {
                int count = 0;
                for (Page page2 : response.getResults()) {
                    activities.addSeedDocument(ConfluenceUtil.generateRepositoryDocumentIdentifier(page2.getId(), page.getId()));
                    ++count;
                }
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("Fetched and added {} seed document attachments for page {}", Locale.ROOT).format(new Object[]{new Integer(count), page.getId()}));
                }
                lastStart += (long)count;
                isLast = response.isLast();
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)new MessageFormat("New start {0} and size {1}", Locale.ROOT).format(new Object[]{lastStart, 50L}));
                }
                if (!isLast.booleanValue()) continue;
                break;
            }
        }
        catch (Exception e) {
            ConfluenceRepositoryConnector.handleConfluenceDownException(e, "seeding");
        }
    }

    protected static void handleConfluenceDownException(Exception e, String context) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        String message = "Server appears down during " + context + ": " + e.getMessage();
        Logging.connectors.warn((Object)message, (Throwable)e);
        throw new ServiceInterruption(message, (Throwable)e, currentTime + 300000L, -1L, 3, true);
    }

    protected void handlePageException(Exception e, String context) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        String message = "Server appears down during " + context + ": " + e.getMessage();
        Logging.connectors.warn((Object)message, (Throwable)e);
        throw new ServiceInterruption(message, (Throwable)e, currentTime + this.retryInterval, -1L, this.retryNumber, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)"Process Confluence documents: Inside processDocuments");
        }
        ConfluenceSpecification confluenceSpecification = ConfluenceSpecification.from(spec);
        boolean activeSecurity = confluenceSpecification.isSecurityActive();
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            String documentIdentifier;
            String pageId = documentIdentifier = documentIdentifiers[i];
            String version = statuses.getIndexedVersionString(documentIdentifier);
            ArrayList<String> parentRestrictions = new ArrayList<String>();
            if (pageId.startsWith(CHILD_PREFIX)) {
                JSONParser parser = new JSONParser();
                try {
                    JSONObject child = (JSONObject)parser.parse((Reader)new StringReader(pageId.substring(CHILD_PREFIX.length())));
                    pageId = child.get((Object)"id").toString();
                    JSONArray arrParentRestrictions = (JSONArray)child.get((Object)"parentRestricions");
                    arrParentRestrictions.forEach(pr -> parentRestrictions.add(pr.toString()));
                    parentRestrictions.sort(String::compareToIgnoreCase);
                }
                catch (IOException | ParseException e) {
                    ConfluenceRepositoryConnector.handleException((Exception)e);
                }
            }
            long startTime = System.currentTimeMillis();
            long fileSize = 0L;
            String errorCode = "OK";
            String errorDesc = "";
            ProcessResult pResult = null;
            boolean doLog = true;
            try {
                if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Confluence: Processing document identifier '" + pageId + "'"));
                }
                if (!this.isConnected()) {
                    this.initConfluenceClient();
                }
                if (ConfluenceUtil.isAttachment(pageId)) {
                    pResult = this.processPageAsAttachment(activeSecurity, documentIdentifier, parentRestrictions, pageId, version, activities, true);
                    continue;
                }
                pResult = this.processPage(activeSecurity, documentIdentifier, parentRestrictions, pageId, version, activities, true, Maps.newHashMap());
                continue;
            }
            catch (IOException ioe) {
                this.handleIOException(ioe);
                continue;
            }
            catch (Exception e) {
                ConfluenceRepositoryConnector.handleException(e);
                continue;
            }
            finally {
                if (pResult != null && pResult.errorCode != null && !pResult.errorCode.isEmpty()) {
                    activities.recordActivity(new Long(startTime), ACTIVITY_READ, Long.valueOf(pResult.fileSize), pageId, pResult.errorCode, pResult.errorDescription, null);
                } else {
                    if (pResult != null) {
                        fileSize = pResult.fileSize;
                    }
                    activities.recordActivity(new Long(startTime), ACTIVITY_READ, Long.valueOf(fileSize), pageId, "OK", "", null);
                }
            }
        }
    }

    private ProcessResult processPage(boolean activeSecurity, String documentIdentifier, List<String> parentRestrictions, String pageId, String version, IProcessActivity activities, boolean doLog, Map<String, String> extraProperties) throws ManifoldCFException, ServiceInterruption, IOException {
        Page page = new Page();
        try {
            page = this.confluenceClient.getPage(pageId);
        }
        catch (Exception e) {
            this.handlePageException(e, "page processing");
        }
        if (page != null) {
            return this.processPageInternal(activeSecurity, parentRestrictions, page, documentIdentifier, version, activities, doLog, extraProperties);
        }
        return null;
    }

    private ProcessResult processPageAsAttachment(boolean activeSecurity, String documentIdentifier, List<String> parentRestrictions, String pageId, String version, IProcessActivity activities, boolean doLog) throws ManifoldCFException, ServiceInterruption, IOException {
        String[] ids = ConfluenceUtil.getAttachmentAndPageId(pageId);
        Attachment attachment = new Attachment();
        try {
            attachment = this.confluenceClient.getAttachment(ids[0]);
        }
        catch (Exception e) {
            this.handlePageException(e, "attachment processing");
        }
        HashMap extraProperties = Maps.newHashMap();
        extraProperties.put("attachedBy", ids[1]);
        return this.processPageInternal(activeSecurity, parentRestrictions, attachment, documentIdentifier, version, activities, doLog, extraProperties);
    }

    private ProcessResult processPageInternal(boolean activeSecurity, List<String> parentRestrictions, Page page, String manifoldDocumentIdentifier, String version, IProcessActivity activities, boolean doLog, Map<String, String> extraProperties) throws ManifoldCFException, ServiceInterruption, IOException {
        String errorCode;
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Confluence: This content exists: " + page.getId()));
        }
        RepositoryDocument rd = new RepositoryDocument();
        Date createdDate = page.getCreatedDate();
        Date lastModified = page.getLastModifiedDate();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.ROOT);
        StringBuilder versionBuilder = new StringBuilder();
        versionBuilder.append(df.format(lastModified));
        ArrayList pageRestrictions = new ArrayList();
        if (activeSecurity) {
            List<Restrictions> restrictions = this.getPageReadRestrictions(page.getId());
            for (Restrictions restrictions2 : restrictions) {
                Restrictions.ReadRestrictions readRestrictions = restrictions2.getReadRestrictions();
                readRestrictions.getUsers().forEach(user -> pageRestrictions.add("user-" + user.getUserKey()));
                readRestrictions.getGroups().forEach(group -> pageRestrictions.add("group-" + group.getName()));
            }
        }
        pageRestrictions.sort(String::compareToIgnoreCase);
        versionBuilder.append("+");
        ConfluenceRepositoryConnector.packList((StringBuilder)versionBuilder, pageRestrictions, (char)'+');
        versionBuilder.append("+");
        ConfluenceRepositoryConnector.packList((StringBuilder)versionBuilder, parentRestrictions, (char)'+');
        String lastVersion = versionBuilder.toString();
        if (page.getType() == PageType.PAGE) {
            List<Page> pageChilds = this.getPageChilds(page.getId());
            for (Page page2 : pageChilds) {
                JSONObject child = new JSONObject();
                child.put((Object)"id", (Object)page2.getId());
                ArrayList<String> childParentRestrictions = new ArrayList<String>();
                if (activeSecurity) {
                    if (pageRestrictions.isEmpty()) {
                        childParentRestrictions.addAll(parentRestrictions);
                    } else {
                        childParentRestrictions.addAll(pageRestrictions);
                    }
                }
                childParentRestrictions.sort(String::compareToIgnoreCase);
                child.put((Object)"parentRestricions", childParentRestrictions);
                activities.addDocumentReference(CHILD_PREFIX + child.toJSONString());
            }
        }
        if (!activities.checkDocumentNeedsReindexing(manifoldDocumentIdentifier, lastVersion)) {
            return new ProcessResult(page.getLength(), "RETAINED", "");
        }
        if (!activities.checkLengthIndexable(page.getLength())) {
            activities.noDocument(manifoldDocumentIdentifier, lastVersion);
            errorCode = "EXCLUDEDLENGTH";
            String string = "Excluding document because of length (" + page.getLength() + ")";
            return new ProcessResult(page.getLength(), "EXCLUDEDLENGTH", string);
        }
        if (!activities.checkMimeTypeIndexable(page.getMediaType())) {
            activities.noDocument(manifoldDocumentIdentifier, lastVersion);
            errorCode = "EXCLUDEDMIMETYPE";
            String string = "Excluding document because of mime type (" + page.getMediaType() + ")";
            return new ProcessResult(page.getLength(), "EXCLUDEDMIMETYPE", string);
        }
        if (!activities.checkDateIndexable(lastModified)) {
            activities.noDocument(manifoldDocumentIdentifier, lastVersion);
            errorCode = "EXCLUDEDDATE";
            String string = "Excluding document because of date (" + String.valueOf(lastModified) + ")";
            return new ProcessResult(page.getLength(), "EXCLUDEDDATE", string);
        }
        if (!activities.checkURLIndexable(page.getWebUrl())) {
            activities.noDocument(manifoldDocumentIdentifier, lastVersion);
            errorCode = "EXCLUDEDURL";
            String string = "Excluding document because of URL ('" + page.getWebUrl() + "')";
            return new ProcessResult(page.getLength(), "EXCLUDEDURL", string);
        }
        rd.setMimeType(page.getMediaType());
        if (createdDate != null) {
            rd.setCreatedDate(createdDate);
        }
        if (lastModified != null) {
            rd.setModifiedDate(lastModified);
        }
        rd.setIndexingDate(new Date());
        Map<String, Object> pageMetadata = page.getMetadataAsMap();
        for (Map.Entry<String, Object> entry : pageMetadata.entrySet()) {
            if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                rd.addField(entry.getKey(), list.toArray(new String[list.size()]));
                continue;
            }
            if (entry.getValue() == null) continue;
            String key = entry.getKey();
            String value = entry.getValue().toString();
            rd.addField(key, value);
            if (!key.toLowerCase(Locale.ROOT).contentEquals("title")) continue;
            rd.addField("stream_name", value);
        }
        rd.addField("source", "confluence");
        for (Map.Entry<String, String> entry : extraProperties.entrySet()) {
            rd.addField(entry.getKey(), entry.getValue());
        }
        String string = page.getWebUrl();
        if (activeSecurity) {
            rd.setSecurity("share", new String[]{"space-" + page.getSpace()}, new String[]{defaultAuthorityDenyToken});
            if (parentRestrictions.size() > 0) {
                rd.setSecurity("parent", parentRestrictions.toArray(new String[0]), new String[]{defaultAuthorityDenyToken});
            }
            if (pageRestrictions.size() > 0) {
                rd.setSecurity("document", pageRestrictions.toArray(new String[0]), new String[]{defaultAuthorityDenyToken});
            }
        }
        rd.setBinary(page.getContentStream(), page.getLength());
        rd.addField("size", String.valueOf(page.getLength()));
        rd.addField("url", string);
        activities.ingestDocumentWithException(manifoldDocumentIdentifier, lastVersion, string, rd);
        return new ProcessResult(page.getLength(), null, null);
    }

    private void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("IO exception: " + e.getMessage()), (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + this.retryInterval, currentTime + 10800000L, -1, false);
    }

    private static void handleException(Exception e) throws ServiceInterruption, ManifoldCFException {
        if (!(e instanceof ServiceInterruption)) {
            Logging.connectors.warn((Object)("Exception: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Exception: " + e.getMessage(), (Throwable)e, 5);
        }
        throw (ServiceInterruption)((Object)e);
    }

    private static class ConfluenceSpecification {
        private List<String> spaces;
        private Boolean activateSecurity = true;
        private Boolean processAttachments = false;
        private String pageType = null;

        private ConfluenceSpecification() {
        }

        public Boolean isSecurityActive() {
            return this.activateSecurity;
        }

        public Boolean isProcessAttachments() {
            return this.processAttachments;
        }

        public List<String> getSpaces() {
            return this.spaces;
        }

        public String getPageType() {
            if (this.pageType == null || this.pageType.isEmpty()) {
                return "page";
            }
            return this.pageType;
        }

        public static ConfluenceSpecification from(Specification spec) {
            ConfluenceSpecification cs = new ConfluenceSpecification();
            cs.spaces = Lists.newArrayList();
            int len = spec.getChildCount();
            for (int i = 0; i < len; ++i) {
                SpecificationNode sn = spec.getChild(i);
                if (sn.getType().equals("spaces")) {
                    int sLen = sn.getChildCount();
                    for (int j = 0; j < sLen; ++j) {
                        SpecificationNode specNode = sn.getChild(j);
                        if (!specNode.getType().equals("space")) continue;
                        cs.spaces.add(specNode.getAttributeValue("key"));
                    }
                    continue;
                }
                if (sn.getType().equals("pages")) {
                    String s = sn.getAttributeValue("process_attachments");
                    cs.processAttachments = Boolean.valueOf(s);
                    cs.pageType = sn.getAttributeValue("pagetype");
                    continue;
                }
                if (!sn.getType().equals("security")) continue;
                String s = sn.getAttributeValue("activate_security");
                cs.activateSecurity = Boolean.valueOf(s);
            }
            return cs;
        }
    }

    private class ProcessResult {
        private final long fileSize;
        private final String errorCode;
        private final String errorDescription;

        private ProcessResult(long fileSize, String errorCode, String errorDescription) {
            this.fileSize = fileSize;
            this.errorCode = errorCode;
            this.errorDescription = errorDescription;
        }
    }
}

