/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.EnumSet;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="install", description="Installs a feature with the specified name and version.")
public class InstallFeatureCommand
extends FeaturesCommandSupport {
    private static String DEFAULT_VERSION = "0.0.0";
    @Argument(index=0, name="feature", description="The name and version of the features to uninstall. A feature id looks like name/version. The version is optional.", required=true, multiValued=true)
    List<String> features;
    @Option(name="-c", aliases={"--no-clean"}, description="Do not uninstall bundles on failure", required=false, multiValued=false)
    boolean noClean;
    @Option(name="-r", aliases={"--no-auto-refresh"}, description="Do not automatically refresh bundles", required=false, multiValued=false)
    boolean noRefresh;
    @Option(name="-v", aliases={"--verbose"}, description="Explain what is being done", required=false, multiValued=false)
    boolean verbose;

    protected void doExecute(FeaturesService admin) throws Exception {
        for (String feature : this.features) {
            String[] split = feature.split("/");
            String name = split[0];
            String version = null;
            if (split.length == 2) {
                version = split[1];
            }
            if (version == null || version.length() == 0) {
                version = DEFAULT_VERSION;
            }
            EnumSet<FeaturesService.Option> options = EnumSet.of(FeaturesService.Option.PrintBundlesToRefresh);
            if (this.noRefresh) {
                options.add(FeaturesService.Option.NoAutoRefreshBundles);
            }
            if (this.noClean) {
                options.add(FeaturesService.Option.NoCleanIfFailure);
            }
            if (this.verbose) {
                options.add(FeaturesService.Option.Verbose);
            }
            admin.installFeature(name, version, options);
        }
    }
}

