/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ReportPlugin;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Reporting
implements Serializable,
InputLocationTracker {
    final String excludeDefaults;
    final String outputDirectory;
    final List<ReportPlugin> plugins;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected Reporting(Builder builder) {
        String string = builder.excludeDefaults != null ? builder.excludeDefaults : (this.excludeDefaults = builder.base != null ? builder.base.excludeDefaults : null);
        String string2 = builder.outputDirectory != null ? builder.outputDirectory : (this.outputDirectory = builder.base != null ? builder.base.outputDirectory : null);
        this.plugins = ImmutableCollections.copy(builder.plugins != null ? builder.plugins : (builder.base != null ? builder.base.plugins : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getExcludeDefaults() {
        return this.excludeDefaults;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Nonnull
    public List<ReportPlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return Reporting.newBuilder(this);
    }

    @Nonnull
    public Reporting withExcludeDefaults(String excludeDefaults) {
        return Reporting.newBuilder(this, true).excludeDefaults(excludeDefaults).build();
    }

    @Nonnull
    public Reporting withOutputDirectory(String outputDirectory) {
        return Reporting.newBuilder(this, true).outputDirectory(outputDirectory).build();
    }

    @Nonnull
    public Reporting withPlugins(Collection<ReportPlugin> plugins) {
        return Reporting.newBuilder(this, true).plugins(plugins).build();
    }

    @Nonnull
    public static Reporting newInstance() {
        return Reporting.newInstance(true);
    }

    @Nonnull
    public static Reporting newInstance(boolean withDefaults) {
        return Reporting.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Reporting.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Reporting from) {
        return Reporting.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Reporting from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isExcludeDefaults() {
        return this.getExcludeDefaults() != null ? Boolean.parseBoolean(this.getExcludeDefaults()) : false;
    }

    @NotThreadSafe
    public static class Builder {
        Reporting base;
        String excludeDefaults;
        String outputDirectory;
        Collection<ReportPlugin> plugins;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Reporting base, boolean forceCopy) {
            if (forceCopy) {
                this.excludeDefaults = base.excludeDefaults;
                this.outputDirectory = base.outputDirectory;
                this.plugins = base.plugins;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder excludeDefaults(String excludeDefaults) {
            this.excludeDefaults = excludeDefaults;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder plugins(Collection<ReportPlugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Reporting build() {
            if (!(this.base == null || this.excludeDefaults != null && this.excludeDefaults != this.base.excludeDefaults || this.outputDirectory != null && this.outputDirectory != this.base.outputDirectory || this.plugins != null && this.plugins != this.base.plugins)) {
                return this.base;
            }
            return new Reporting(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

