/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.Serializable;
import java.util.Objects;

public abstract class BaseObject
implements Serializable,
Cloneable {
    protected transient ChildrenTracking childrenTracking;
    protected Object delegate;

    public BaseObject() {
    }

    public BaseObject(Object delegate, BaseObject parent) {
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        this.childrenTracking = parent != null ? parent::replace : null;
    }

    public BaseObject(Object delegate, ChildrenTracking parent) {
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        this.childrenTracking = parent;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void update(Object newDelegate) {
        if (this.delegate != newDelegate) {
            if (this.childrenTracking != null) {
                this.childrenTracking.replace(this.delegate, newDelegate);
            }
            this.delegate = newDelegate;
        }
    }

    protected boolean replace(Object oldDelegate, Object newDelegate) {
        return false;
    }

    @FunctionalInterface
    protected static interface ChildrenTracking {
        public boolean replace(Object var1, Object var2);
    }
}

