/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.file;

import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.Objects;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryUriUtils;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.file.FileTransporter;

@Named(value="file")
public final class FileTransporterFactory
implements TransporterFactory {
    public static final String NAME = "file";
    private float priority;

    public float getPriority() {
        return this.priority;
    }

    public FileTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        FileTransporter.FileOp fileOp = FileTransporter.FileOp.COPY;
        String repositoryUrl = repository.getUrl();
        if (repositoryUrl.startsWith("symlink+")) {
            fileOp = FileTransporter.FileOp.SYMLINK;
            repositoryUrl = repositoryUrl.substring("symlink+".length());
        } else if (repositoryUrl.startsWith("hardlink+")) {
            fileOp = FileTransporter.FileOp.HARDLINK;
            repositoryUrl = repositoryUrl.substring("hardlink+".length());
        }
        try {
            return new FileTransporter(Paths.get(RepositoryUriUtils.toUri((String)repositoryUrl)).toAbsolutePath(), fileOp);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e) {
            throw new NoTransporterException(repository, (Throwable)e);
        }
    }
}

