/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sshd.client.proxy.ProxyData;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.functors.IOFunction;

public abstract class AbstractProxyConnector
implements Closeable {
    protected final InetSocketAddress proxyAddress;
    protected final InetSocketAddress remoteAddress;
    protected String proxyUser;
    protected char[] proxyPassword;
    protected boolean done;
    private final IOFunction<Buffer, IoWriteFuture> send;
    private final Function<InetSocketAddress, PasswordAuthentication> passwordAuth;

    protected AbstractProxyConnector(ProxyData proxy, InetSocketAddress remoteAddress, IOFunction<Buffer, IoWriteFuture> send, Function<InetSocketAddress, PasswordAuthentication> passwordAuth) {
        this.proxyAddress = proxy.getAddress();
        this.proxyUser = proxy.getUser();
        char[] pass = proxy.getPassword();
        this.proxyPassword = pass != null ? (char[])pass.clone() : new char[]{};
        proxy.clearPassword();
        this.remoteAddress = Objects.requireNonNull(remoteAddress);
        this.send = send;
        this.passwordAuth = passwordAuth;
    }

    protected IoWriteFuture write(Buffer message) throws IOException {
        return (IoWriteFuture)this.send.apply((Object)message);
    }

    protected PasswordAuthentication passwordAuthentication() {
        return this.passwordAuth.apply(this.proxyAddress);
    }

    protected void clearPassword() {
        Arrays.fill(this.proxyPassword, '\u0000');
        this.proxyPassword = new char[0];
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void close() {
        this.clearPassword();
    }

    public abstract Buffer received(Readable var1) throws Exception;

    public abstract void start() throws IOException;
}

