/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.managedproperty;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.FacesException;
import javax.faces.annotation.ManagedProperty;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.managedproperty.ManagedPropertyInfo;
import org.apache.myfaces.cdi.util.AbstractDynamicProducer;
import org.apache.myfaces.util.lang.ClassUtils;

@ApplicationScoped
public class ManagedPropertyProducer
extends AbstractDynamicProducer<Object> {
    public ManagedPropertyProducer(BeanManager beanManager, ManagedPropertyInfo typeInfo) {
        super(beanManager);
        Class beanClass = typeInfo.getType() instanceof ParameterizedType ? ClassUtils.simpleClassForName((String)((ParameterizedType)typeInfo.getType()).getRawType().getTypeName()) : ClassUtils.simpleJavaTypeToClass((String)typeInfo.getType().getTypeName());
        super.id(typeInfo.getType() + "_" + typeInfo.getExpression()).scope(Dependent.class).qualifiers(new Annotation[]{new ManagedPropertyAnnotationLiteral(typeInfo.getExpression())}).types(new Type[]{typeInfo.getType(), Object.class}).beanClass(beanClass).create((CreationalContext<T> e) -> this.createManagedProperty((CreationalContext<Object>)e, typeInfo));
    }

    protected Object createManagedProperty(CreationalContext<Object> cc, ManagedPropertyInfo typeInfo) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new FacesException("@ManagedProperty(\"" + typeInfo.getExpression() + "\") can only be resolved in a JSF request!");
        }
        return facesContext.getApplication().evaluateExpressionGet(facesContext, typeInfo.getExpression(), this.getBeanClass());
    }

    class ManagedPropertyAnnotationLiteral
    extends AnnotationLiteral<ManagedProperty>
    implements ManagedProperty {
        private static final long serialVersionUID = 1L;
        private String value;

        public ManagedPropertyAnnotationLiteral(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

