/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.FacesServletMapping;
import org.apache.myfaces.application.FacesServletMappingUtils;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.resource.AliasResourceMetaImpl;
import org.apache.myfaces.resource.ContractResource;
import org.apache.myfaces.resource.ResourceHandlerSupport;
import org.apache.myfaces.resource.ResourceLoader;
import org.apache.myfaces.resource.ResourceLoaderUtils;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.resource.ValueExpressionFilterInputStream;

public class ResourceImpl
extends Resource
implements ContractResource {
    protected static final String JAVAX_FACES_LIBRARY_NAME = "javax.faces";
    protected static final String JSF_JS_RESOURCE_NAME = "jsf.js";
    private ResourceMeta _resourceMeta;
    private ResourceLoader _resourceLoader;
    private ResourceHandlerSupport _resourceHandlerSupport;
    private URL _url;
    private String _requestPath;

    public ResourceImpl(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceHandlerSupport support, String contentType) {
        this._resourceMeta = resourceMeta;
        this._resourceLoader = resourceLoader;
        this._resourceHandlerSupport = support;
        this.setLibraryName(resourceMeta.getLibraryName());
        this.setResourceName(resourceMeta.getResourceName());
        this.setContentType(contentType);
    }

    public ResourceImpl(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceHandlerSupport support, String contentType, URL url, String requestPath) {
        this._resourceMeta = resourceMeta;
        this._resourceLoader = resourceLoader;
        this._resourceHandlerSupport = support;
        this._url = url;
        this._requestPath = requestPath;
        this.setLibraryName(resourceMeta.getLibraryName());
        this.setResourceName(resourceMeta.getResourceName());
        this.setContentType(contentType);
    }

    public ResourceLoader getResourceLoader() {
        return this._resourceLoader;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.couldResourceContainValueExpressions()) {
            return new ValueExpressionFilterInputStream(this.getResourceLoader().getResourceInputStream(this._resourceMeta), this.getLibraryName(), this.getResourceName());
        }
        return this.getResourceLoader().getResourceInputStream(this._resourceMeta);
    }

    private boolean couldResourceContainValueExpressions() {
        if (this._resourceMeta.couldResourceContainValueExpressions()) {
            return true;
        }
        String contentType = this.getContentType();
        return "text/css".equals(contentType);
    }

    @Override
    public String getRequestPath() {
        if (this._requestPath == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            FacesServletMapping mapping = FacesServletMappingUtils.getCurrentRequestFacesServletMapping(context);
            if (mapping.isExactMapping()) {
                mapping = FacesServletMappingUtils.getGenericPrefixOrSuffixMapping(context);
            }
            String path = "";
            if (mapping.isExtensionMapping()) {
                path = this._resourceHandlerSupport.getResourceIdentifier() + '/' + this.getResourceName() + mapping.getExtension();
            } else {
                path = this._resourceHandlerSupport.getResourceIdentifier() + '/' + this.getResourceName();
                path = mapping.getPrefix() == null ? path : mapping.getPrefix() + path;
            }
            String metadata = null;
            boolean useAmp = false;
            if (this.getLibraryName() != null) {
                metadata = "?ln=" + this.getLibraryName();
                path = path + metadata;
                useAmp = true;
                if (!context.isProjectStage(ProjectStage.Production) && JSF_JS_RESOURCE_NAME.equals(this.getResourceName()) && JAVAX_FACES_LIBRARY_NAME.equals(this.getLibraryName())) {
                    path = path + "&stage=" + context.getApplication().getProjectStage().toString();
                }
            }
            if (this._resourceMeta.getLocalePrefix() != null) {
                path = path + (useAmp ? (char)'&' : '?') + "loc=" + this._resourceMeta.getLocalePrefix();
                useAmp = true;
            }
            if (this._resourceMeta.getContractName() != null) {
                path = path + (useAmp ? (char)'&' : '?') + "con=" + this._resourceMeta.getContractName();
                useAmp = true;
            }
            this._requestPath = context.getApplication().getViewHandler().getResourceURL(context, path);
        }
        return this._requestPath;
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext)) {
            HashMap<String, String> headers = new HashMap<String, String>(2, 1.0f);
            long lastModified = this.getLastModified(facesContext);
            if (this.couldResourceContainValueExpressions() && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            } else if (this._resourceMeta instanceof AliasResourceMetaImpl && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            }
            if (lastModified >= 0L) {
                headers.put("Last-Modified", ResourceLoaderUtils.formatDateHeader(lastModified));
                if (facesContext.isProjectStage(ProjectStage.Development)) {
                    headers.put("Cache-Control", "no-cache");
                } else {
                    headers.put("Cache-Control", "max-age=" + this._resourceHandlerSupport.getMaxTimeExpires() / 1000L);
                }
            }
            return headers;
        }
        return Collections.emptyMap();
    }

    @Override
    public URL getURL() {
        if (this._url == null) {
            this._url = this.getResourceLoader().getResourceURL(this._resourceMeta);
        }
        return this._url;
    }

    @Override
    public boolean userAgentNeedsUpdate(FacesContext context) {
        String ifModifiedSinceString = context.getExternalContext().getRequestHeaderMap().get("If-Modified-Since");
        if (ifModifiedSinceString == null) {
            return true;
        }
        Long ifModifiedSince = ResourceLoaderUtils.parseDateHeader(ifModifiedSinceString);
        if (ifModifiedSince == null) {
            return true;
        }
        long lastModified = this.getLastModified(context);
        if (lastModified >= 0L) {
            if (this.couldResourceContainValueExpressions() && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            }
            if (lastModified - lastModified % 1000L <= ifModifiedSince) {
                return false;
            }
        }
        return true;
    }

    protected ResourceHandlerSupport getResourceHandlerSupport() {
        return this._resourceHandlerSupport;
    }

    protected ResourceMeta getResourceMeta() {
        return this._resourceMeta;
    }

    @Override
    public boolean isContractResource() {
        return this._resourceMeta.getContractName() != null;
    }

    @Override
    public String getContractName() {
        return this._resourceMeta.getContractName();
    }

    protected long getLastModified(FacesContext facesContext) {
        if (MyfacesConfig.getCurrentInstance(facesContext).isResourceCacheLastModified()) {
            Long lastModified = this._resourceMeta.getLastModified();
            if (lastModified == null) {
                try {
                    lastModified = ResourceLoaderUtils.getResourceLastModified(this.getURL());
                }
                catch (IOException e) {
                    lastModified = -1L;
                }
                this._resourceMeta.setLastModified(lastModified);
            }
            return lastModified;
        }
        try {
            return ResourceLoaderUtils.getResourceLastModified(this.getURL());
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

