/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

public class JavascriptContext {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final char TABULATOR = '\t';
    private long currentIndentationLevel;
    private StringBuilder buffer = new StringBuilder();
    private boolean prettyPrint = false;
    private boolean automaticFormatting = true;

    public JavascriptContext() {
    }

    public JavascriptContext(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public JavascriptContext(StringBuilder buf, boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.buffer = buf;
    }

    public void increaseIndent() {
        ++this.currentIndentationLevel;
    }

    public void decreaseIndent() {
        --this.currentIndentationLevel;
        if (this.currentIndentationLevel < 0L) {
            this.currentIndentationLevel = 0L;
        }
    }

    public void prettyLine() {
        if (this.prettyPrint) {
            this.append(LINE_SEPARATOR);
            int i = 0;
            while ((long)i < this.getCurrentIndentationLevel()) {
                this.append('\t');
                ++i;
            }
        }
    }

    public void prettyLineIncreaseIndent() {
        this.increaseIndent();
        this.prettyLine();
    }

    public void prettyLineDecreaseIndent() {
        this.decreaseIndent();
        this.prettyLine();
    }

    public long getCurrentIndentationLevel() {
        return this.currentIndentationLevel;
    }

    public void setCurrentIndentationLevel(long currentIndentationLevel) {
        this.currentIndentationLevel = currentIndentationLevel;
    }

    public JavascriptContext append(String str) {
        if (this.automaticFormatting && str.length() == 1) {
            boolean openBlock = str.equals("{");
            boolean closeBlock = str.equals("}");
            if (openBlock) {
                this.prettyLine();
            } else if (closeBlock) {
                this.prettyLineDecreaseIndent();
            }
            this.buffer.append(str);
            if (openBlock) {
                this.prettyLineIncreaseIndent();
            } else if (closeBlock) {
                this.prettyLine();
            }
        } else {
            this.buffer.append(str);
        }
        return this;
    }

    public JavascriptContext append(char c) {
        this.buffer.append(c);
        return this;
    }

    public JavascriptContext append(int i) {
        this.buffer.append(i);
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

