/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.ActionSource2AttachedObjectHandler;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;

public final class ActionListenerHandler
extends TagHandler
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;

    public ActionListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        if (type != null) {
            if (!type.isLiteral()) {
                throw new TagAttributeException(type, "Must be a literal class name of type ActionListener");
            }
            try {
                ReflectionUtil.forName(type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(type, "Couldn't qualify ActionListener", (Throwable)e);
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            if (this.getAttribute("for") == null) {
                throw new TagException(this.tag, "is nested inside a composite component but does not have a for attribute.");
            }
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not composite component or of type ActionSource, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        ActionSource as = (ActionSource)parent;
        ValueExpression b = null;
        if (this.binding != null) {
            b = this.binding.getValueExpression(faceletContext, ActionListener.class);
        }
        LazyActionListener listener = new LazyActionListener(this.listenerType, b);
        as.addActionListener((ActionListener)listener);
    }

    public String getFor() {
        TagAttribute forAttribute = this.getAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    private static final class LazyActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = -9202120013153262119L;
        private final String type;
        private final ValueExpression binding;

        public LazyActionListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            ActionListener instance = null;
            FacesContext faces = FacesContext.getCurrentInstance();
            if (faces == null) {
                return;
            }
            if (this.binding != null) {
                instance = (ActionListener)this.binding.getValue(faces.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (ActionListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(faces.getELContext(), (Object)instance);
                }
            }
            if (instance != null) {
                instance.processAction(event);
            }
        }
    }
}

