/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.validator;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Inherited
@Qualifier
public @interface FacesValidator {
    public String value() default "";

    public boolean isDefault() default false;

    public boolean managed() default false;

    public static final class Literal
    extends AnnotationLiteral<FacesValidator>
    implements FacesValidator {
        private static final long serialVersionUID = 1L;
        public static final Literal INSTANCE = Literal.of("", false, false);
        private final String value;
        private final boolean isDefault;
        private final boolean managed;

        public static Literal of(String value, boolean isDefault, boolean managed) {
            return new Literal(value, isDefault, managed);
        }

        private Literal(String value, boolean isDefault, boolean managed) {
            this.value = value;
            this.isDefault = isDefault;
            this.managed = managed;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        @Override
        public boolean managed() {
            return this.managed;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Objects.hashCode(this.value);
            hash = 59 * hash + (this.isDefault ? 1 : 0);
            hash = 59 * hash + (this.managed ? 1 : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Literal other = (Literal)obj;
            if (this.isDefault != other.isDefault) {
                return false;
            }
            if (this.managed != other.managed) {
                return false;
            }
            return Objects.equals(this.value, other.value);
        }
    }
}

