/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.faces.component.EditableValueHolder;
import java.io.Serializable;

public class EditableValueHolderState
implements Serializable {
    public static final EditableValueHolderState EMPTY = new ImmutableEditableValueHolderState();
    private static final long serialVersionUID = 2920252657338389849L;
    private boolean localValueSet = false;
    private Object submittedValue;
    private boolean valid = true;
    private Object localValue;

    public EditableValueHolderState() {
    }

    public EditableValueHolderState(EditableValueHolder evh) {
        this();
        this.saveState(evh);
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Object getLocalValue() {
        return this.localValue;
    }

    public String toString() {
        return "EditableValueHolderState{localValueSet=" + this.localValueSet + ", submittedValue=" + String.valueOf(this.submittedValue) + ", valid=" + this.valid + ", localValue=" + String.valueOf(this.localValue) + "}";
    }

    public void saveState(EditableValueHolder evh) {
        this.localValue = evh.getLocalValue();
        this.localValueSet = evh.isLocalValueSet();
        this.valid = evh.isValid();
        this.submittedValue = evh.getSubmittedValue();
    }

    public void restoreState(EditableValueHolder evh) {
        evh.setValue(this.localValue);
        evh.setLocalValueSet(this.localValueSet);
        evh.setValid(this.valid);
        evh.setSubmittedValue(this.submittedValue);
    }

    public static EditableValueHolderState create(EditableValueHolder evh) {
        if (EditableValueHolderState.isEmpty(evh)) {
            return null;
        }
        return new EditableValueHolderState(evh);
    }

    public static boolean isEmpty(EditableValueHolder evh) {
        return evh.getLocalValue() == null && evh.isValid() && !evh.isLocalValueSet() && evh.getSubmittedValue() == null;
    }

    public static class ImmutableEditableValueHolderState
    extends EditableValueHolderState {
        @Override
        public void saveState(EditableValueHolder evh) {
            throw new UnsupportedOperationException();
        }
    }
}

