/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class ParametrizableFacesMessage
extends FacesMessage {
    private static final long serialVersionUID = 7792947730961657948L;
    private final Object[] args;
    private String evaluatedDetail;
    private String evaluatedSummary;
    private transient Object[] evaluatedArgs;
    private Locale locale;

    public ParametrizableFacesMessage(String summary, String detail, Object[] args, Locale locale) {
        super(summary, detail);
        Assert.notNull(locale, "locale");
        this.locale = locale;
        this.args = args;
    }

    public ParametrizableFacesMessage(FacesMessage.Severity severity, String summary, String detail, Object[] args, Locale locale) {
        super(severity, summary, detail);
        Assert.notNull(locale, "locale");
        this.locale = locale;
        this.args = args;
    }

    @Override
    public String getDetail() {
        if (this.evaluatedArgs == null && this.args != null) {
            this.evaluateArgs();
        }
        if (this.evaluatedDetail == null) {
            MessageFormat format = new MessageFormat(super.getDetail(), this.locale);
            this.evaluatedDetail = format.format(this.evaluatedArgs);
        }
        return this.evaluatedDetail;
    }

    @Override
    public void setDetail(String detail) {
        super.setDetail(detail);
        this.evaluatedDetail = null;
    }

    public String getUnformattedDetail() {
        return super.getDetail();
    }

    @Override
    public String getSummary() {
        if (this.evaluatedArgs == null && this.args != null) {
            this.evaluateArgs();
        }
        if (this.evaluatedSummary == null) {
            MessageFormat format = new MessageFormat(super.getSummary(), this.locale);
            this.evaluatedSummary = format.format(this.evaluatedArgs);
        }
        return this.evaluatedSummary;
    }

    @Override
    public void setSummary(String summary) {
        super.setSummary(summary);
        this.evaluatedSummary = null;
    }

    public String getUnformattedSummary() {
        return super.getSummary();
    }

    private void evaluateArgs() {
        FacesContext facesContext = null;
        this.evaluatedArgs = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            if (this.args[i] instanceof ValueExpression) {
                if (facesContext == null) {
                    facesContext = FacesContext.getCurrentInstance();
                }
                this.evaluatedArgs[i] = ((ValueExpression)this.args[i]).getValue(facesContext.getELContext());
                continue;
            }
            this.evaluatedArgs[i] = this.args[i];
        }
    }
}

