/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.Conversation;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.CloseWindowContextEvent;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.CreateWindowContextEvent;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.DefaultWindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.JsfWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.WindowContextIdHolderComponent;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowContextFactory;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowContextQuotaHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class DefaultWindowContextManager
implements EditableWindowContextManager {
    private static final long serialVersionUID = 2872151847183166424L;
    private ConcurrentHashMap<String, EditableWindowContext> windowContextMap = new ConcurrentHashMap();
    private ProjectStage projectStage;
    private BeanManager beanManager;
    private WindowContextConfig windowContextConfig;
    private ConversationConfig conversationConfig;
    private boolean allowUnknownWindowIds = false;
    private boolean urlParameterSupported = true;
    private WindowHandler windowHandler;
    private boolean projectStageDevelopment;
    private WindowContextQuotaHandler windowContextQuotaHandler;
    private boolean createWindowContextEventEnable;
    private boolean closeWindowContextEventEnable;
    private static final int DEFAULT_WINDOW_KEY_LENGTH = 3;

    protected DefaultWindowContextManager(WindowContextConfig windowContextConfig, ConversationConfig conversationConfig, ProjectStage projectStage, BeanManager beanManager) {
        this.windowContextConfig = windowContextConfig;
        this.conversationConfig = conversationConfig;
        this.projectStage = projectStage;
        this.beanManager = beanManager;
        this.createWindowContextEventEnable = windowContextConfig.isCreateWindowContextEventEnabled();
        this.closeWindowContextEventEnable = windowContextConfig.isCloseWindowContextEventEnabled();
        this.init();
    }

    protected void init() {
        this.windowHandler = (WindowHandler)CodiUtils.getContextualReferenceByClass(WindowHandler.class, (Annotation[])new Annotation[0]);
        this.windowContextQuotaHandler = (WindowContextQuotaHandler)CodiUtils.getContextualReferenceByClass(WindowContextQuotaHandler.class, (Annotation[])new Annotation[0]);
        this.allowUnknownWindowIds = this.windowContextConfig.isUnknownWindowIdsAllowed();
        this.urlParameterSupported = this.windowContextConfig.isUrlParameterSupported();
        this.projectStageDevelopment = ProjectStage.Development == this.projectStage;
    }

    public WindowContext getCurrentWindowContext() {
        WindowContext windowContext = RequestCache.getCurrentWindowContext();
        if (windowContext != null) {
            return windowContext;
        }
        String windowContextId = ConversationUtils.resolveWindowContextId(this.windowHandler, this.urlParameterSupported, this.allowUnknownWindowIds);
        if (windowContextId == null) {
            windowContextId = this.createNewWindowContextId();
        }
        windowContext = this.getWindowContext(windowContextId);
        RequestCache.setCurrentWindowContext(windowContext);
        return windowContext;
    }

    private synchronized String createNewWindowContextId() {
        String windowContextId = this.windowHandler.createWindowId();
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if (!(!this.windowContextQuotaHandler.isWindowContextQuotaViolated(this.getNumberOfNextWindowContext()) || this.windowContextConfig.isCloseEmptyWindowContextsEnabled() && ConversationUtils.cleanupInactiveWindowContexts(this))) {
            this.windowContextQuotaHandler.handleQuotaViolation();
        }
        if (this.projectStageDevelopment && this.windowHandler instanceof DefaultWindowHandler) {
            windowContextId = this.convertToDevWindowContextId(windowContextId, this.getNumberOfNextWindowContext());
        }
        ConversationUtils.storeCreatedWindowContextId(externalContext, windowContextId);
        ConversationUtils.cacheWindowId(externalContext, windowContextId, this.allowUnknownWindowIds);
        return windowContextId;
    }

    private int getNumberOfNextWindowContext() {
        return this.windowContextMap.size() + 1;
    }

    public synchronized WindowContext getWindowContext(String windowContextId) {
        EditableWindowContext result = this.windowContextMap.get(windowContextId);
        if (result != null && !result.isActive()) {
            this.closeWindowContext(result);
            result = null;
        }
        if (result == null) {
            result = this.createWindowContext(windowContextId);
            this.windowContextMap.put(windowContextId, result);
        }
        result.touch();
        return result;
    }

    private EditableWindowContext createWindowContext(String windowContextId) {
        WindowContextFactory windowContextFactory = (WindowContextFactory)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, WindowContextFactory.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (windowContextFactory != null) {
            return windowContextFactory.createWindowContext(windowContextId, this.windowContextConfig, this.conversationConfig);
        }
        JsfWindowContext windowContext = new JsfWindowContext(windowContextId, this.windowContextConfig, this.conversationConfig, this.projectStageDevelopment, this.beanManager);
        if (this.createWindowContextEventEnable) {
            this.beanManager.fireEvent((Object)new CreateWindowContextEvent((WindowContext)windowContext), new Annotation[0]);
        }
        return windowContext;
    }

    @Override
    public boolean activateWindowContext(String windowContextId) {
        return this.activateWindowContext(this.convert(this.getWindowContext(windowContextId)));
    }

    @Override
    public boolean activateWindowContext(EditableWindowContext windowContext) {
        JsfUtils.resetCaches();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        WindowContextIdHolderComponent windowContextIdHolder = ConversationUtils.getWindowContextIdHolderComponent(facesContext);
        if (windowContextIdHolder != null) {
            windowContextIdHolder.changeWindowContextId(windowContext.getId());
        }
        return ConversationUtils.cacheWindowId(facesContext.getExternalContext(), windowContext.getId(), this.allowUnknownWindowIds);
    }

    @Override
    public void restartConversations() {
        this.restartConversations(this.convert(this.getCurrentWindowContext()));
    }

    @Override
    public void restartConversations(String windowContextId) {
        this.restartConversations(this.convert(this.getWindowContext(windowContextId)));
    }

    @Override
    public void restartConversations(EditableWindowContext windowContext) {
        JsfUtils.resetCaches();
        for (EditableConversation conversation : windowContext.getConversations().values()) {
            conversation.deactivate();
            if (conversation.isActive()) continue;
            conversation.restart();
        }
    }

    @Override
    public void closeCurrentWindowContext() {
        this.closeWindowContext(this.convert(this.getCurrentWindowContext()));
    }

    @Override
    public void closeWindowContext(String windowContextId) {
        this.closeWindowContext(this.convert(this.getWindowContext(windowContextId)));
    }

    @Override
    public void closeWindowContext(EditableWindowContext editableWindowContext) {
        if (this.closeWindowContextEventEnable) {
            this.beanManager.fireEvent((Object)new CloseWindowContextEvent((WindowContext)editableWindowContext), new Annotation[0]);
        }
        JsfUtils.resetCaches();
        this.windowContextMap.remove(editableWindowContext.getId());
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        this.removeWindowContextIdHolderComponent(facesContext);
        ConversationUtils.removeExistingWindowId(externalContext, editableWindowContext.getId());
        externalContext.getRequestMap().remove("windowId");
        editableWindowContext.closeConversations();
        editableWindowContext.removeInactiveConversations();
    }

    private void removeWindowContextIdHolderComponent(FacesContext facesContext) {
        JsfUtils.resetCaches();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            return;
        }
        Iterator uiComponents = viewRoot.getChildren().iterator();
        while (uiComponents.hasNext()) {
            UIComponent uiComponent = (UIComponent)uiComponents.next();
            if (!(uiComponent instanceof WindowContextIdHolderComponent)) continue;
            uiComponents.remove();
            return;
        }
    }

    private String convertToDevWindowContextId(String windowContextId, int currentWindowContextCount) {
        String devWindowContextId = currentWindowContextCount + windowContextId;
        if (devWindowContextId.length() > 3 + ("" + currentWindowContextCount).length()) {
            return windowContextId;
        }
        return devWindowContextId;
    }

    @Override
    public Collection<EditableWindowContext> getWindowContexts() {
        return Collections.unmodifiableCollection(this.windowContextMap.values());
    }

    @Override
    public void closeAllWindowContexts() {
        for (WindowContext windowContext : this.windowContextMap.values()) {
            for (Conversation conversation : ((EditableWindowContext)windowContext).getConversations().values()) {
                conversation.close();
            }
            ((EditableWindowContext)windowContext).removeInactiveConversations();
        }
        RequestCache.resetCache();
    }

    @Override
    public boolean isWindowContextActive(String windowContextId) {
        EditableWindowContext editableWindowContext = this.windowContextMap.get(windowContextId);
        return editableWindowContext != null && editableWindowContext.isActive();
    }

    private EditableWindowContext convert(WindowContext windowContext) {
        if (!(windowContext instanceof EditableWindowContext)) {
            throw ExceptionUtils.windowContextNotEditableException(windowContext);
        }
        return (EditableWindowContext)windowContext;
    }
}

