/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.myfaces.extensions.cdi.message.api.CompositeMessageHandler;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageFilter;
import org.apache.myfaces.extensions.cdi.message.api.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultCompositeMessageHandler
implements CompositeMessageHandler,
Serializable {
    private static final long serialVersionUID = 3553885372006874180L;
    private ArrayList<MessageHandler> messageHandlers = new ArrayList();

    DefaultCompositeMessageHandler(Iterable<MessageHandler> messageHandlerIterable) {
        for (MessageHandler messageHandler : messageHandlerIterable) {
            this.messageHandlers.add(messageHandler);
        }
    }

    public void addMessage(MessageContext messageContext, Message message) {
        for (MessageHandler messageHandler : this.messageHandlers) {
            messageHandler.addMessage(messageContext, message);
        }
    }

    public void addMessageFilter(MessageFilter ... messageFilters) {
        for (MessageHandler messageHandler : this.messageHandlers) {
            messageHandler.addMessageFilter(messageFilters);
        }
    }

    public Set<MessageFilter> getMessageFilters() {
        HashSet result = new HashSet();
        for (MessageHandler messageHandler : this.messageHandlers) {
            result.addAll(messageHandler.getMessageFilters());
        }
        return Collections.unmodifiableSet(result);
    }

    public void removeMessage(Message message) {
        for (MessageHandler messageHandler : this.messageHandlers) {
            messageHandler.removeMessage(message);
        }
    }

    public void removeAllMessages() {
        for (MessageHandler messageHandler : this.messageHandlers) {
            messageHandler.removeAllMessages();
        }
    }

    public List<Message> getMessages() {
        ArrayList<Message> result = new ArrayList<Message>();
        for (MessageHandler messageHandler : this.messageHandlers) {
            for (Message message : messageHandler.getMessages()) {
                if (result.contains(message)) continue;
                result.add(message);
            }
        }
        return result;
    }

    public List<MessageHandler> getMessageHandlers() {
        return Collections.unmodifiableList(this.messageHandlers);
    }
}

