/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.config.view;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.PhaseId;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.InitView;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PostRenderView;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PrePageAction;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.PreRenderView;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.AfterPhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.BeforePhase;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.DefaultRequestLifecycleCallbackEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.PhasesLifecycleCallbackEntryHelper;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.LifecycleAwarePageBeanDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.RequestLifecycleCallbackEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultPageBeanDescriptor
implements LifecycleAwarePageBeanDescriptor {
    private final String beanName;
    private final Class beanClass;
    private final Map<PhaseId, RequestLifecycleCallbackEntry> phasesLifecycleCallbacks;
    private List<Method> initViewMethods = new ArrayList<Method>();
    private List<Method> prePageActionMethods = new ArrayList<Method>();
    private List<Method> preRenderViewMethods = new ArrayList<Method>();
    private List<Method> postRenderViewMethods = new ArrayList<Method>();

    DefaultPageBeanDescriptor(String beanName, Class beanClass) {
        this.beanName = beanName;
        this.beanClass = beanClass;
        this.phasesLifecycleCallbacks = Collections.unmodifiableMap(this.findCallbackDefinitions(beanClass));
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    @Override
    public RequestLifecycleCallbackEntry getPhasesLifecycleCallback(PhaseId phaseId) {
        return this.phasesLifecycleCallbacks.get(phaseId);
    }

    @Override
    public List<Method> getInitViewMethods() {
        return Collections.unmodifiableList(this.initViewMethods);
    }

    @Override
    public List<Method> getPrePageActionMethods() {
        return Collections.unmodifiableList(this.prePageActionMethods);
    }

    @Override
    public List<Method> getPreRenderViewMethods() {
        return Collections.unmodifiableList(this.preRenderViewMethods);
    }

    @Override
    public List<Method> getPostRenderViewMethods() {
        return Collections.unmodifiableList(this.postRenderViewMethods);
    }

    private Map<PhaseId, RequestLifecycleCallbackEntry> findCallbackDefinitions(Class beanClass) {
        Class currentClass = beanClass;
        PhasesLifecycleCallbackEntryHelper beforeCallbackEntryHelper = new PhasesLifecycleCallbackEntryHelper();
        PhasesLifecycleCallbackEntryHelper afterCallbackEntryHelper = new PhasesLifecycleCallbackEntryHelper();
        ArrayList<String> processedMethodNames = new ArrayList<String>();
        while (!currentClass.getName().equals(Object.class.getName())) {
            for (Method currentMethod : currentClass.getDeclaredMethods()) {
                if (processedMethodNames.contains(currentMethod.getName())) continue;
                boolean callbackAdded = false;
                if (currentMethod.isAnnotationPresent(BeforePhase.class)) {
                    callbackAdded = true;
                    beforeCallbackEntryHelper.add(currentMethod.getAnnotation(BeforePhase.class).value(), currentMethod);
                } else if (currentMethod.isAnnotationPresent(AfterPhase.class)) {
                    callbackAdded = true;
                    afterCallbackEntryHelper.add(currentMethod.getAnnotation(AfterPhase.class).value(), currentMethod);
                } else if (currentMethod.isAnnotationPresent(InitView.class)) {
                    callbackAdded = true;
                    this.initViewMethods.add(currentMethod);
                } else if (currentMethod.isAnnotationPresent(PrePageAction.class)) {
                    callbackAdded = true;
                    this.prePageActionMethods.add(currentMethod);
                } else if (currentMethod.isAnnotationPresent(PreRenderView.class)) {
                    callbackAdded = true;
                    this.preRenderViewMethods.add(currentMethod);
                } else if (currentMethod.isAnnotationPresent(PostRenderView.class)) {
                    callbackAdded = true;
                    this.postRenderViewMethods.add(currentMethod);
                }
                if (!callbackAdded) continue;
                processedMethodNames.add(currentMethod.getName());
                String errorMessage = "";
                if (currentMethod.getParameterTypes().length != 0) {
                    errorMessage = errorMessage + "Parameters aren't supported. ";
                }
                if (Modifier.isPrivate(currentMethod.getModifiers())) {
                    errorMessage = errorMessage + "Private methods aren't supported to avoid side-effects with normal-scoped CDI beans. Please use e.g. protected or public instead. ";
                }
                if ("".equals(errorMessage)) continue;
                throw new IllegalStateException("Callback-Implementation not supported: " + currentMethod.getDeclaringClass().getName() + "#" + currentMethod.getName() + ". " + errorMessage);
            }
            currentClass = currentClass.getSuperclass();
        }
        return this.createPhasesLifecycleCallbackMap(beforeCallbackEntryHelper, afterCallbackEntryHelper);
    }

    private Map<PhaseId, RequestLifecycleCallbackEntry> createPhasesLifecycleCallbackMap(PhasesLifecycleCallbackEntryHelper beforeCallbackEntryHelper, PhasesLifecycleCallbackEntryHelper afterCallbackEntryHelper) {
        HashMap<PhaseId, RequestLifecycleCallbackEntry> result = new HashMap<PhaseId, RequestLifecycleCallbackEntry>(6);
        result.put(PhaseId.RESTORE_VIEW, this.createCallbackEntry(PhaseId.RESTORE_VIEW, beforeCallbackEntryHelper, afterCallbackEntryHelper));
        result.put(PhaseId.APPLY_REQUEST_VALUES, this.createCallbackEntry(PhaseId.APPLY_REQUEST_VALUES, beforeCallbackEntryHelper, afterCallbackEntryHelper));
        result.put(PhaseId.PROCESS_VALIDATIONS, this.createCallbackEntry(PhaseId.PROCESS_VALIDATIONS, beforeCallbackEntryHelper, afterCallbackEntryHelper));
        result.put(PhaseId.UPDATE_MODEL_VALUES, this.createCallbackEntry(PhaseId.UPDATE_MODEL_VALUES, beforeCallbackEntryHelper, afterCallbackEntryHelper));
        result.put(PhaseId.INVOKE_APPLICATION, this.createCallbackEntry(PhaseId.INVOKE_APPLICATION, beforeCallbackEntryHelper, afterCallbackEntryHelper));
        result.put(PhaseId.RENDER_RESPONSE, this.createCallbackEntry(PhaseId.RENDER_RESPONSE, beforeCallbackEntryHelper, afterCallbackEntryHelper));
        return result;
    }

    private RequestLifecycleCallbackEntry createCallbackEntry(PhaseId phaseId, PhasesLifecycleCallbackEntryHelper beforeCallbackEntryHelper, PhasesLifecycleCallbackEntryHelper afterCallbackEntryHelper) {
        List<Method> beforePhaseCallbacks = beforeCallbackEntryHelper.getMethodsFor(phaseId);
        List<Method> afterPhaseCallbacks = afterCallbackEntryHelper.getMethodsFor(phaseId);
        if (PhaseId.ANY_PHASE.equals(phaseId) || PhaseId.RESTORE_VIEW.equals(phaseId) && beforePhaseCallbacks != null && !beforePhaseCallbacks.isEmpty()) {
            throw ExceptionUtils.unsupportedPhasesLifecycleCallback();
        }
        return new DefaultRequestLifecycleCallbackEntry(beforePhaseCallbacks, afterPhaseCallbacks);
    }
}

