/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import org.apache.myfaces.extensions.validator.core.JsfProjectStage;
import org.apache.myfaces.extensions.validator.core.renderkit.RendererProxy;
import org.apache.myfaces.extensions.validator.core.storage.RendererProxyStorage;
import org.apache.myfaces.extensions.validator.core.storage.RendererProxyStorageEntry;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValRendererProxy
extends Renderer
implements RendererProxy {
    public static final String KEY = ExtValRendererProxy.class.getName() + ":KEY";
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected Renderer wrapped;

    public ExtValRendererProxy(Renderer renderer) {
        this.wrapped = renderer;
        this.logger.finest("proxy created for " + renderer.getClass().getName());
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        RendererProxyStorageEntry entry = this.getRendererEntry(facesContext, uiComponent);
        if (!entry.isDecodeCalled()) {
            entry.setDecodeCalled(true);
            try {
                this.wrapped.decode(facesContext, uiComponent);
            }
            catch (RuntimeException r) {
                this.resetComponentProxyMapping();
                throw r;
            }
        } else {
            this.tryToCreateMessage("decode");
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererProxyStorageEntry entry = this.getRendererEntry(facesContext, uiComponent);
        if (!entry.isEncodeBeginCalled()) {
            entry.setEncodeBeginCalled(true);
            try {
                this.wrapped.encodeBegin(facesContext, uiComponent);
            }
            catch (IOException e) {
                this.resetComponentProxyMapping();
                throw e;
            }
            catch (RuntimeException r) {
                this.resetComponentProxyMapping();
                throw r;
            }
        } else {
            this.tryToCreateMessage("encodeBegin");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererProxyStorageEntry entry = this.getRendererEntry(facesContext, uiComponent);
        if (!entry.isEncodeChildrenCalled()) {
            entry.setEncodeChildrenCalled(true);
            try {
                this.wrapped.encodeChildren(facesContext, uiComponent);
            }
            catch (IOException e) {
                this.resetComponentProxyMapping();
                throw e;
            }
            catch (RuntimeException r) {
                this.resetComponentProxyMapping();
                throw r;
            }
        } else {
            this.tryToCreateMessage("encodeChildren");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererProxyStorageEntry entry = this.getRendererEntry(facesContext, uiComponent);
        if (!entry.isEncodeEndCalled()) {
            entry.setEncodeEndCalled(true);
            try {
                this.wrapped.encodeEnd(facesContext, uiComponent);
            }
            catch (IOException e) {
                this.resetComponentProxyMapping();
                throw e;
            }
            catch (RuntimeException r) {
                this.resetComponentProxyMapping();
                throw r;
            }
        } else {
            this.tryToCreateMessage("encodeEnd");
        }
    }

    public String convertClientId(FacesContext facesContext, String s) {
        try {
            return this.wrapped.convertClientId(facesContext, s);
        }
        catch (RuntimeException r) {
            this.resetComponentProxyMapping();
            throw r;
        }
    }

    public boolean getRendersChildren() {
        try {
            return this.wrapped.getRendersChildren();
        }
        catch (RuntimeException t) {
            this.resetComponentProxyMapping();
            throw t;
        }
    }

    public Object getCachedConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object o) {
        RendererProxyStorageEntry entry = this.getRendererEntry(facesContext, uiComponent);
        if (entry.getConvertedValue() == null) {
            try {
                entry.setConvertedValue(this.wrapped.getConvertedValue(facesContext, uiComponent, o));
            }
            catch (RuntimeException r) {
                this.resetComponentProxyMapping();
                throw r;
            }
        }
        return entry.getConvertedValue();
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object o) throws ConverterException {
        RendererProxyStorageEntry entry = this.getRendererEntry(facesContext, uiComponent);
        if (entry.getConvertedValue() == null) {
            try {
                entry.setConvertedValue(this.wrapped.getConvertedValue(facesContext, uiComponent, o));
            }
            catch (RuntimeException r) {
                this.resetComponentProxyMapping();
                throw r;
            }
        } else {
            this.tryToCreateMessage("getConvertedValue");
        }
        return entry.getConvertedValue();
    }

    protected RendererProxyStorageEntry getRendererEntry(FacesContext facesContext, UIComponent uiComponent) {
        String key = uiComponent.getClientId(facesContext);
        key = key + this.getOptionalKey(facesContext, uiComponent);
        RendererProxyStorage rendererProxyStorage = this.getRendererStorage();
        if (!rendererProxyStorage.containsEntry(this.getRendererKey(), key)) {
            rendererProxyStorage.setEntry(this.getRendererKey(), key, new RendererProxyStorageEntry());
        }
        return rendererProxyStorage.getEntry(this.getRendererKey(), key);
    }

    protected String getOptionalKey(FacesContext facesContext, UIComponent uiComponent) {
        return "";
    }

    protected String getRendererKey() {
        return ProxyUtils.getClassName(this.wrapped.getClass());
    }

    private RendererProxyStorage getRendererStorage() {
        return ExtValUtils.getStorage(RendererProxyStorage.class, RendererProxyStorage.class.getName());
    }

    private void resetComponentProxyMapping() {
        ExtValUtils.resetStorage(RendererProxyStorage.class, RendererProxyStorage.class.getName());
    }

    private void tryToCreateMessage(String methodName) {
        if (JsfProjectStage.is(JsfProjectStage.Development)) {
            String message = "double call of " + this.wrapped.getClass().getName() + "#" + methodName + " filtered. " + "this optimization might lead to incompatibilities with some component libs. " + "in such a case use the support module for the component lib or use: " + "ExtValContext.getContext().addGlobalProperty(ExtValRendererProxy.KEY, null); " + "in a startup listener";
            FacesContext.getCurrentInstance().addMessage(null, ExtValUtils.createFacesMessage(FacesMessage.SEVERITY_WARN, message, message));
            this.logger.warning(message);
        }
        this.logger.fine("turn on the development mode for further information, if something is displayed wrong.");
    }

    public Renderer getWrappedRenderer() {
        return this.wrapped;
    }
}

