/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class ClassUtils {
    private static final Logger LOG = Logger.getLogger(ClassUtils.class.getName());

    public static Class tryToLoadClassForName(String name) {
        try {
            return ClassUtils.loadClassForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class loadClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(name, false, ClassUtils.class.getClassLoader());
        }
    }

    public static <T> T tryToInstantiateClass(Class<T> targetClass) {
        try {
            return targetClass.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object tryToInstantiateClassForName(String className) {
        try {
            return ClassUtils.instantiateClassForName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object instantiateClassForName(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassUtils.loadClassForName(className).newInstance();
    }

    public static String getJarVersion(Class targetClass) {
        String classFilePath = targetClass.getCanonicalName().replace('.', '/') + ".class";
        String manifestFilePath = "/META-INF/MANIFEST.MF";
        String classLocation = targetClass.getResource(targetClass.getSimpleName() + ".class").toString();
        String manifestFileLocation = classLocation.substring(0, classLocation.indexOf(classFilePath) - 1) + manifestFilePath;
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "couldn't load version of jar file which contains " + targetClass.getName(), e);
            return null;
        }
    }

    public static String getPackageName(Class targetClass) {
        Package currentPackage = targetClass.getPackage();
        if (currentPackage != null) {
            return currentPackage.getName();
        }
        return targetClass.getName().substring(0, targetClass.getName().lastIndexOf("."));
    }
}

