/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.storage.PropertyStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getName());

    public static Method tryToGetMethod(Class targetClass, String targetMethodName) {
        return ReflectionUtils.tryToGetMethod(targetClass, targetMethodName, null);
    }

    public static Method tryToGetMethod(Class targetClass, String targetMethodName, Class ... parameterTypes) {
        try {
            return ReflectionUtils.getMethod(targetClass, targetMethodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getMethod(Class targetClass, String targetMethodName) throws NoSuchMethodException {
        return ReflectionUtils.getMethod(targetClass, targetMethodName, null);
    }

    public static Method getMethod(Class targetClass, String targetMethodName, Class ... parameterTypes) throws NoSuchMethodException {
        Class<Object> currentClass = targetClass;
        Method targetMethod = null;
        while (!Object.class.getName().equals(currentClass.getName())) {
            try {
                targetMethod = currentClass.getDeclaredMethod(targetMethodName, parameterTypes);
                break;
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        if (targetMethod == null) {
            block5: for (Class<?> currentInterface : targetClass.getInterfaces()) {
                for (currentClass = currentInterface; currentClass != null; currentClass = currentClass.getSuperclass()) {
                    try {
                        targetMethod = currentClass.getDeclaredMethod(targetMethodName, parameterTypes);
                        continue block5;
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                }
            }
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        throw new NoSuchMethodException("there is no method with the name '" + targetMethodName + "'" + " class: " + targetClass.getName());
    }

    public static Object tryToInvokeMethod(Object target, Method method) {
        return ReflectionUtils.tryToInvokeMethod(target, method, null);
    }

    public static Object tryToInvokeMethodOfClass(Class target, Method method) {
        return ReflectionUtils.tryToInvokeMethodOfClass(target, method, null);
    }

    public static Object tryToInvokeMethodOfClass(Class target, Method method, Object[] args) {
        try {
            return ReflectionUtils.invokeMethodOfClass(target, method, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeMethodOfClass(Class target, Method method) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return ReflectionUtils.invokeMethod(target.newInstance(), method, null);
    }

    public static Object invokeMethodOfClass(Class target, Method method, Object ... args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return ReflectionUtils.invokeMethod(target.newInstance(), method, args);
    }

    public static Object tryToInvokeMethod(Object target, Method method, Object ... args) {
        try {
            return ReflectionUtils.invokeMethod(target, method, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeMethod(Object target, Method method) throws InvocationTargetException, IllegalAccessException {
        return ReflectionUtils.invokeMethod(target, method, null);
    }

    public static Object invokeMethod(Object target, Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        return method.invoke(target, args);
    }

    public static Object getBaseOfPropertyChain(Object baseObject, String propertyChain) {
        StringTokenizer tokenizer = new StringTokenizer(propertyChain, ".");
        Object currentBase = baseObject;
        while (tokenizer.hasMoreTokens()) {
            String currentProperty = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            Method currentMethod = ReflectionUtils.tryToGetMethod(ProxyUtils.getUnproxiedClass(currentBase.getClass()), "get" + currentProperty.substring(0, 1).toUpperCase() + currentProperty.substring(1));
            currentBase = ReflectionUtils.tryToInvokeMethod(currentBase, currentMethod);
        }
        return currentBase;
    }

    public static PropertyStorage getPropertyStorage() {
        return ExtValUtils.getStorage(PropertyStorage.class, PropertyStorage.class.getName());
    }

    @Deprecated
    public static Method tryToGetMethodOfProperty(Class entity, String property) {
        return ReflectionUtils.tryToGetMethodOfProperty(ReflectionUtils.getPropertyStorage(), entity, property);
    }

    public static Method tryToGetMethodOfProperty(PropertyStorage storage, Class entity, String property) {
        if (ReflectionUtils.isCachedMethod(storage, entity, property)) {
            return ReflectionUtils.getCachedMethod(storage, entity, property);
        }
        Method method = ReflectionUtils.tryToGetReadMethod(entity, property);
        ReflectionUtils.tryToCacheMethod(storage, entity, property, method);
        return method;
    }

    @Deprecated
    public static Field tryToGetFieldOfProperty(Class entity, String property) {
        return ReflectionUtils.tryToGetFieldOfProperty(ReflectionUtils.getPropertyStorage(), entity, property);
    }

    public static Field tryToGetFieldOfProperty(PropertyStorage storage, Class entity, String property) {
        Field field;
        block8: {
            if (ReflectionUtils.isCachedField(storage, entity, property)) {
                return ReflectionUtils.getCachedField(storage, entity, property);
            }
            field = null;
            try {
                field = entity.getDeclaredField(property);
            }
            catch (Exception e) {
                try {
                    try {
                        field = entity.getDeclaredField("_" + property);
                    }
                    catch (Exception e1) {
                        if (property.length() > 1 && Character.isUpperCase(property.charAt(0)) && Character.isUpperCase(property.charAt(1))) {
                            field = entity.getDeclaredField(property.substring(0, 1).toLowerCase() + property.substring(1));
                            break block8;
                        }
                        field = entity.getDeclaredField(Introspector.decapitalize(property));
                    }
                }
                catch (NoSuchFieldException e1) {
                    LOGGER.log(Level.FINEST, "field " + property + " or _" + property + " not found", e1);
                }
            }
        }
        ReflectionUtils.tryToCacheField(storage, entity, property, field);
        return field;
    }

    private static void tryToCacheField(PropertyStorage storage, Class entity, String property, Field field) {
        if (!storage.containsField(entity, property)) {
            storage.storeField(entity, property, field);
        }
    }

    private static boolean isCachedField(PropertyStorage storage, Class entity, String property) {
        return storage.containsField(entity, property);
    }

    private static Method tryToGetReadMethod(Class baseBeanClass, String property) {
        Method method = ReflectionUtils.tryToGetReadMethodViaBeanInfo(baseBeanClass, property);
        if (method == null) {
            method = ReflectionUtils.tryToGetReadMethodManually(baseBeanClass, property);
        }
        return method;
    }

    private static Method tryToGetReadMethodViaBeanInfo(Class entity, String property) {
        if (ReflectionUtils.useBeanInfo()) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(entity);
                for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                    if (!property.equals(propertyDescriptor.getName()) || propertyDescriptor.getReadMethod() == null) continue;
                    return propertyDescriptor.getReadMethod();
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean useBeanInfo() {
        return Boolean.TRUE.equals(ExtValContext.getContext().getGlobalProperty(BeanInfo.class.getName()));
    }

    private static Method tryToGetReadMethodManually(Class entity, String property) {
        property = property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            return entity.getDeclaredMethod("is" + property, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return entity.getDeclaredMethod("get" + property, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                LOGGER.finest("method not found - class: " + entity.getName() + " - methods: " + "get" + property + " " + "is" + property);
                return null;
            }
        }
    }

    private static Field getCachedField(PropertyStorage storage, Class entity, String property) {
        return storage.getField(entity, property);
    }

    private static boolean isCachedMethod(PropertyStorage storage, Class entity, String property) {
        return storage.containsMethod(entity, property);
    }

    private static void tryToCacheMethod(PropertyStorage storage, Class entity, String property, Method method) {
        if (!storage.containsMethod(entity, property)) {
            storage.storeMethod(entity, property, method);
        }
    }

    private static Method getCachedMethod(PropertyStorage storage, Class entity, String property) {
        return storage.getMethod(entity, property);
    }
}

