/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.viewController;


/**
 * An implementation of ViewControllerExecutor that can be subclassed to customise 
 * the mapping of lifecycle events to bean methods.
 * <p>
 * Orchestra provides this class so that the executor responsibilities can be extended
 * between releases without breaking binary compatibility (something that cannot be done
 * with an interface).
 */
public abstract class AbstractViewControllerExecutor implements ViewControllerExecutor
{
    public boolean invokeInitView(String beanName, Object bean)
    {
        return false;
    }

    public boolean invokePreRenderView(String beanName, Object bean)
    {
        return false;
    }
    
    public boolean invokePreProcess(String beanName, Object bean)
    {
        return false;
    }
}
