/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.runners;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.myfaces.test.runners.NamedRunner;
import org.apache.myfaces.test.runners.TestClassLoader;
import org.junit.After;
import org.junit.Before;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPerClassLoaderRunner
extends NamedRunner {
    private static final Logger LOGGER = Logger.getLogger(TestPerClassLoaderRunner.class.getName());
    private static String classPath;
    private static boolean classPathDetermined;
    private TestClass testClassFromClassLoader;
    private Object beforeFromClassLoader;
    private Object afterFromClassLoader;

    public TestPerClassLoaderRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Object createTest() throws Exception {
        return this.testClassFromClassLoader.getJavaClass().newInstance();
    }

    private void loadClassesWithCustomClassLoader() throws ClassNotFoundException {
        String testPath = TestPerClassLoaderRunner.getClassPath();
        TestClassLoader classLoader = testPath != null ? new TestClassLoader(testPath) : new TestClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this.testClassFromClassLoader = new TestClass(classLoader.loadClass(this.getTestClass().getJavaClass().getName()));
        this.beforeFromClassLoader = classLoader.loadClass(Before.class.getName());
        this.afterFromClassLoader = classLoader.loadClass(After.class.getName());
    }

    protected Statement methodBlock(FrameworkMethod method) {
        FrameworkMethod newMethod = null;
        try {
            this.loadClassesWithCustomClassLoader();
            Method methodFromNewlyLoadedClass = this.testClassFromClassLoader.getJavaClass().getMethod(method.getName(), new Class[0]);
            newMethod = new FrameworkMethod(methodFromNewlyLoadedClass);
        }
        catch (ClassNotFoundException e) {
            return new Fail((Throwable)e);
        }
        catch (SecurityException e) {
            return new Fail((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            return new Fail((Throwable)e);
        }
        return super.methodBlock(newMethod);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.testClassFromClassLoader.getAnnotatedMethods((Class)this.afterFromClassLoader);
        return new RunAfters(statement, afters, target);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List befores = this.testClassFromClassLoader.getAnnotatedMethods((Class)this.beforeFromClassLoader);
        return new RunBefores(statement, befores, target);
    }

    private static String getClassPath() {
        if (classPathDetermined) {
            return classPath;
        }
        classPathDetermined = true;
        classPath = System.getProperty("surefire.test.class.path");
        if (classPath != null) {
            return classPath;
        }
        String booterClassPath = System.getProperty("java.class.path");
        Vector<String> pathItems = null;
        if (booterClassPath != null) {
            pathItems = TestPerClassLoaderRunner.scanPath(booterClassPath);
        }
        if (pathItems != null && pathItems.size() == 1 && TestPerClassLoaderRunner.isJar(pathItems.get(0))) {
            classPath = TestPerClassLoaderRunner.loadJarManifestClassPath(pathItems.get(0), "META-INF/MANIFEST.MF");
        }
        return classPath;
    }

    private static String loadJarManifestClassPath(String path, String fileName) {
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        try {
            Manifest mf = new Manifest();
            mf.read(zipFile.getInputStream(entry));
            return mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH).replaceAll(" ", System.getProperty("path.separator")).replaceAll("file:/", "");
        }
        catch (MalformedURLException e) {
            LOGGER.throwing("ClassLoaderTestSuite", "loadJarManifestClassPath", e);
        }
        catch (IOException e) {
            LOGGER.throwing("ClassLoaderTestSuite", "loadJarManifestClassPath", e);
        }
        return null;
    }

    private static boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private static Vector<String> scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        Vector<String> pathItems = new Vector<String>(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            pathItems.addElement(st.nextToken());
        }
        return pathItems;
    }

    static {
        classPathDetermined = false;
    }
}

