// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIColumnNode;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.component.ColumnNodeTagDeclaration}.
 */
public final class ColumnNodeTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(ColumnNodeTag.class);
  private javax.el.ValueExpression  tip;
  private javax.el.ValueExpression  disabled;
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  resizable;
  private javax.el.ValueExpression  label;

  @Override
  public String getComponentType() {
    return UIColumnNode.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "TreeNode";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UIColumnNode component = (UIColumnNode) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (tip != null) {
      component.setValueExpression("tip", tip);
    }

    if (disabled != null) {
      if (!disabled.isLiteralText()) {
        component.setValueExpression("disabled", disabled);
      } else {
        component.setDisabled(Boolean.parseBoolean(disabled.getExpressionString()));
      }
    }
    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (resizable != null) {
      if (!resizable.isLiteralText()) {
        component.setValueExpression("resizable", resizable);
      } else {
        component.setResizable(Boolean.parseBoolean(resizable.getExpressionString()));
      }
    }
    if (label != null) {
      component.setValueExpression("label", label);
    }

  }

  public javax.el.ValueExpression getTip() {
    return tip;
  }

  public void setTip(final javax.el.ValueExpression tip) {
    this.tip = tip;
  }

  public javax.el.ValueExpression getDisabled() {
    return disabled;
  }

  public void setDisabled(final javax.el.ValueExpression disabled) {
    this.disabled = disabled;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getResizable() {
    return resizable;
  }

  public void setResizable(final javax.el.ValueExpression resizable) {
    this.resizable = resizable;
  }

  public javax.el.ValueExpression getLabel() {
    return label;
  }

  public void setLabel(final javax.el.ValueExpression label) {
    this.label = label;
  }



  @Override
  public void release() {
    super.release();
    tip = null;
    disabled = null;
    markup = null;
    resizable = null;
    label = null;
  }
}