/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;

public final class DateFormatUtils {
    private static final String TYPE_DATE = "date";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_BOTH = "both";
    private static final String STYLE_DEFAULT = "default";
    private static final String STYLE_MEDIUM = "medium";
    private static final String STYLE_SHORT = "short";
    private static final String STYLE_LONG = "long";
    private static final String STYLE_FULL = "full";

    private DateFormatUtils() {
    }

    public static String findPattern(DateTimeConverter converter) {
        DateFormat dateFormat;
        String pattern = converter.getPattern();
        if (pattern == null && (dateFormat = DateFormatUtils.getDateFormat(converter.getType(), converter.getDateStyle(), converter.getTimeStyle(), converter.getLocale())) instanceof SimpleDateFormat) {
            SimpleDateFormat format = (SimpleDateFormat)dateFormat;
            pattern = format.toPattern();
        }
        return pattern;
    }

    private static DateFormat getDateFormat(String type, String dateStyle, String timeStyle, Locale locale) {
        DateFormat format;
        if (type.equals(TYPE_DATE)) {
            format = DateFormat.getDateInstance(DateFormatUtils.calcStyle(dateStyle), locale);
        } else if (type.equals(TYPE_TIME)) {
            format = DateFormat.getTimeInstance(DateFormatUtils.calcStyle(timeStyle), locale);
        } else if (type.equals(TYPE_BOTH)) {
            format = DateFormat.getDateTimeInstance(DateFormatUtils.calcStyle(dateStyle), DateFormatUtils.calcStyle(timeStyle), locale);
        } else {
            throw new ConverterException("invalid type '" + type + "'");
        }
        format.setLenient(false);
        return format;
    }

    private static int calcStyle(String name) {
        if (name.equals(STYLE_DEFAULT)) {
            return 2;
        }
        if (name.equals(STYLE_MEDIUM)) {
            return 2;
        }
        if (name.equals(STYLE_SHORT)) {
            return 3;
        }
        if (name.equals(STYLE_LONG)) {
            return 1;
        }
        if (name.equals(STYLE_FULL)) {
            return 0;
        }
        throw new ConverterException("invalid style '" + name + "'");
    }
}

