/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIStars;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarsRenderer
extends MessageLayoutRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(StarsRenderer.class);

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUIStars stars = (AbstractUIStars)component;
        String clientId = stars.getClientId(facesContext);
        String fieldId = stars.getFieldId(facesContext);
        String hiddenInputId = clientId + "::" + "input";
        String sliderId = clientId + "::" + "slider";
        int value = stars.getRangeValue();
        int max = stars.getRangeMax();
        Double placeholder = stars.getPlaceholder();
        boolean readonly = stars.isReadonly();
        boolean disabled = stars.isDisabled();
        boolean required = stars.isRequired();
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)stars);
        String sliderValue = stars.getSubmittedValue() != null ? (String)stars.getSubmittedValue() : String.valueOf(value);
        String hiddenInputValue = required && "0".equals(sliderValue) ? null : sliderValue;
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(fieldId);
        writer.writeClassAttribute((CssItem)TobagoClass.STARS, TobagoClass.STARS.createMarkup(stars.getMarkup()), new CssItem[]{stars.getCustomClass()});
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(hiddenInputId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, hiddenInputValue, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__CONTAINER);
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(sliderId);
        writer.writeNameAttribute(clientId);
        writer.writeClassAttribute(TobagoClass.STARS__SLIDER);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, readonly || disabled ? HtmlInputTypes.HIDDEN : HtmlInputTypes.RANGE);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MIN, required ? 1 : 0);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAX, max);
        writer.writeAttribute(HtmlAttributes.VALUE, sliderValue, true);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, stars)));
        if (placeholder != null) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, placeholder.toString(), true);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        HtmlRendererUtils.renderFocus(clientId, stars.isFocus(), ComponentUtils.isError(stars), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, stars.getTabIndex());
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.endElement(HtmlElements.INPUT);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.STARS__FOCUS_BOX);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__TOOLTIP, BootstrapClass.FADE);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__SELECTED);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__UNSELECTED);
        writer.endElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.STARS__PRESELECTED);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.SPAN);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        AbstractUIStars stars = (AbstractUIStars)component;
        return stars.getFieldId(facesContext);
    }
}

