/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.bridge;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeNotAFacesRequestException;
import javax.portlet.faces.BridgePublicRenderParameterHandler;
import javax.portlet.faces.BridgeUninitializedException;
import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.BridgeWriteBehindResponse;
import javax.portlet.faces.annotation.BridgePreDestroy;
import javax.portlet.faces.annotation.BridgeRequestScopeAttributeAdded;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.portlet.faces.event.EventNavigationResult;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.myfaces.portlet.faces.bridge.wrapper.BridgeRenderRequestWrapper;
import org.apache.myfaces.portlet.faces.el.PortletELContextImpl;
import org.apache.myfaces.portlet.faces.util.QueryString;
import org.apache.myfaces.portlet.faces.util.config.FacesConfigurationProcessor;
import org.apache.myfaces.portlet.faces.util.config.WebConfigurationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeImpl
implements Bridge,
ELContextListener,
PhaseListener,
ServletRequestAttributeListener {
    private static final long serialVersionUID = 5807626987246270989L;
    public static final String UPDATED_VIEW_STATE_PARAM = "org.apache.myfaces.portlet.faces.updatedViewStateParam";
    public static final String REDIRECT_VIEWPARAMS = "org.apache.myfaces.portlet.faces.redirectViewParams";
    public static final String RENDER_REDIRECT_VIEWPARAMS = "org.apache.myfaces.portlet.faces.renderRedirectViewParams";
    public static final String RENDER_REDIRECT_PRPMAP = "org.apache.myfaces.portlet.faces.renderRedirectPRPMap";
    public static final String HAS_RENDER_REDIRECTED_AFTER_FORWARD = "org.apache.myfaces.portlet.faces.hasRenderRedirectedAfterForward";
    public static final String LOGGING_ENABLED = "org.apache.myfaces.portlet.faces.loggingEnabled";
    public static final String WRITE_BEHIND_RESPONSE = "org.apache.myfaces.portlet.faces.writeBehindResponse";
    public static final String PORTLET_NAME_ATTRIBUTE = "org.apache.myfaces.portlet.faces.portletName";
    public static final String VIEWID_QUERYSTRING_ATTRIBUTE = "org.apache.myfaces.portlet.faces.viewIdQueryString";
    private static final String REQUEST_SCOPE_LOCK = "org.apache.myfaces.portlet.faces.requestScopeLock";
    private static final String REQUEST_SCOPE_MAP = "org.apache.myfaces.portlet.faces.requestScopeMap";
    private static final String SCOPE_VIEW_KEY = "org.apache.myfaces.portlet.faces.includeInScope.scopeViewKey";
    private static final String CHILD_RESOURCE_REQUEST_SCOPE_MAP = "org.apache.myfaces.portlet.faces.includeInScope.childResourceRequestScopeMap";
    private static final String REQUEST_SCOPE_LISTENER = "org.apache.myfaces.portlet.faces.requestScopeWatch";
    public static final String FACES_VIEWROOT = "org.apache.myfaces.portlet.faces.includeInScope.facesViewRoot";
    private static final String FACES_MESSAGES = "org.apache.myfaces.portlet.faces.includeInScope.facesMessages";
    public static final String REQUEST_PARAMETERS = "org.apache.myfaces.portlet.faces.includeInScope.requestParameters";
    public static final String PREEXISTING_ATTRIBUTE_NAMES = "org.apache.myfaces.portlet.faces.preExistingAttributeNames";
    private static final String REQUEST_SCOPE_ID_RENDER_PARAM = "__jpfbReqScopeId";
    private static final String NULL_VIEW_STATE_PARAM_VALUE = "org.apache.myfaces.portlet.faces.nullViewState";
    private static final String CACHED_VIEWROOT_LOCALE = "org.apache.myfaces.portlet.faces.cachedViewRootLocale";
    private static final String PROCESSED_PUBLIC_PARAMS = "org.apache.myfaces.portlet.faces.processedPublicParams";
    private static final int DEFAULT_MAX_MANAGED_REQUEST_SCOPES = 100;
    private Boolean mPreserveActionParams = Boolean.FALSE;
    private List<String> mExcludedRequestAttributes = null;
    private Map<String, String> mPublicParameterMappings = null;
    private PortletConfig mPortletConfig = null;
    private FacesContextFactory mFacesContextFactory = null;
    private Lifecycle mLifecycle = null;
    private BridgeEventHandler mEventHandler = null;
    private BridgePublicRenderParameterHandler mProcessPRPHandler = null;
    private List<String> mFacesMappings = null;
    private boolean mInitialized = false;
    private Boolean mDebugLoggingEnabled;
    private Map<String, String> mDefaultViewIdMap = null;
    private Class<? extends BridgeWriteBehindResponse> mWriteBehindRenderResponseWrapper = null;
    private Class<? extends BridgeWriteBehindResponse> mWriteBehindResourceResponseWrapper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PortletConfig config) throws BridgeException {
        if (this.mInitialized) {
            throw new BridgeException("Bridge already initialized.");
        }
        this.mPortletConfig = config;
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        this.mDebugLoggingEnabled = (Boolean)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + LOGGING_ENABLED);
        if (this.mDebugLoggingEnabled == null) {
            this.mDebugLoggingEnabled = Boolean.FALSE;
        }
        this.mEventHandler = (BridgeEventHandler)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "bridgeEventHandler");
        this.mProcessPRPHandler = (BridgePublicRenderParameterHandler)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "bridgePublicRenderParameterHandler");
        this.mPreserveActionParams = (Boolean)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "preserveActionParams");
        this.mExcludedRequestAttributes = (List)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "excludedRequestAttributes");
        this.mExcludedRequestAttributes = this.mExcludedRequestAttributes != null ? new ArrayList<String>(this.mExcludedRequestAttributes) : new ArrayList<String>(5);
        this.processFacesConfiguration(portletContext);
        PortletContext portletContext2 = portletContext;
        synchronized (portletContext2) {
            Object lock = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
            if (lock == null) {
                portletContext.setAttribute(REQUEST_SCOPE_LOCK, new Object());
            }
        }
        ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication().addELContextListener((ELContextListener)this);
        WebConfigurationProcessor webConfig = new WebConfigurationProcessor(portletContext);
        this.mFacesMappings = webConfig.getFacesMappings();
        if (this.mFacesMappings == null || this.mFacesMappings.size() == 0) {
            throw new BridgeException("BridgeImpl.init(): unable to determine Faces servlet web.xml mapping.");
        }
        this.mDefaultViewIdMap = (Map)portletContext.getAttribute("javax.portlet.faces." + this.mPortletConfig.getPortletName() + "." + "defaultViewIdMap");
        this.mInitialized = true;
    }

    public void doFacesRequest(ActionRequest request, ActionResponse response) throws BridgeException, BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, NullPointerException {
        if (!this.mInitialized) {
            throw new BridgeUninitializedException();
        }
        if (request == null || response == null) {
            throw new NullPointerException("request or response parameter is null");
        }
        if (request.getParameter("_jsfBridgeNonFacesView") != null) {
            throw new BridgeNotAFacesRequestException("NonFaces target = " + request.getParameter("_jsfBridgeNonFacesView"));
        }
        StringBuffer keyBuf = new StringBuffer(30);
        String key = keyBuf.append("javax.portlet.faces.viewIdHistory").append(".view").toString();
        if (request.getPortletSession().getAttribute(key) == null) {
            this.initViewHistoryDefaults(request.getPortletSession(), this.mDefaultViewIdMap);
        }
        request.setAttribute("javax.portlet.faces.phase", (Object)Bridge.PortletPhase.ACTION_PHASE);
        request.setAttribute(LOGGING_ENABLED, (Object)this.mDebugLoggingEnabled);
        request.setAttribute(PORTLET_NAME_ATTRIBUTE, (Object)this.mPortletConfig.getPortletName());
        if (this.mFacesMappings != null) {
            request.setAttribute("org.apache.myfaces.portlet.faces.context.facesMapping", this.mFacesMappings);
        }
        List<String> preExistingAttributes = this.getRequestAttributes((PortletRequest)request);
        FacesContext context = null;
        Lifecycle lifecycle = null;
        String scopeId = null;
        try {
            lifecycle = this.getLifecycle();
            context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, null);
            request.getPortletSession().removeAttribute("javax.portlet.faces.__jpfbReqScopeId");
            lifecycle.addPhaseListener((PhaseListener)this);
            lifecycle.execute(context);
            if (!context.getResponseComplete()) {
                this.finalizeActionResponse(context);
                this.processOutgoingPublicRenderParameters(context, (PortletRequest)request, (StateAwareResponse)response);
                Boolean noScope = (Boolean)request.getAttribute("org.apache.myfaces.portlet.faces.noScope");
                if (noScope == null || noScope.equals(Boolean.FALSE)) {
                    scopeId = this.initBridgeRequestScope((PortletRequest)request, (StateAwareResponse)response);
                    this.saveFacesView(context);
                    this.saveActionParams(context);
                    this.saveBridgeRequestScopeData(context, scopeId, preExistingAttributes);
                }
            }
        }
        catch (Exception e2) {
            BridgeException e2;
            if (this.mDebugLoggingEnabled.booleanValue()) {
                this.mPortletConfig.getPortletContext().log("Exception thrown in doFacesRequest:action", (Throwable)e2);
            }
            if (!(e2 instanceof BridgeException)) {
                e2 = new BridgeException((Throwable)e2);
            }
            throw (BridgeException)e2;
        }
        finally {
            this.dumpScopeId(scopeId, "ACTION_PHASE");
            if (lifecycle != null) {
                lifecycle.removePhaseListener((PhaseListener)this);
            }
            if (context != null) {
                context.getExternalContext().getRequestMap().remove(REDIRECT_VIEWPARAMS);
                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_PRPMAP);
                context.release();
            }
            request.removeAttribute("javax.portlet.faces.phase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpScopeId(String scopeId, String phase) {
        if (!this.mDebugLoggingEnabled.booleanValue()) {
            return;
        }
        PortletContext ctx = this.mPortletConfig.getPortletContext();
        ctx.log("dumpScopeId: " + phase);
        Object object = ctx.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)ctx.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                ctx.log("There are No saved scoped.  Can't match: " + scopeId);
                return;
            }
            Map m = (Map)requestScopeMap.get(scopeId);
            if (m == null) {
                ctx.log("Can't match scope: " + scopeId);
                return;
            }
            Set set = m.entrySet();
            Iterator i = set.iterator();
            ctx.log("Elements in scope: " + scopeId);
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ctx.log("     " + (String)entry.getKey());
            }
            ctx.log("end dumpScopeId");
        }
    }

    private void dumpParameters(PortletRequest request) {
        int i;
        String[] values;
        String key;
        if (!this.mDebugLoggingEnabled.booleanValue()) {
            return;
        }
        PortletContext ctx = this.mPortletConfig.getPortletContext();
        ctx.log("dumpParameters: ");
        Map m = request.getParameterMap();
        for (Map.Entry e : m.entrySet()) {
            key = (String)e.getKey();
            values = (String[])e.getValue();
            for (i = 0; i < values.length; ++i) {
                ctx.log("    key: " + key + "   value: " + values[i]);
            }
        }
        ctx.log("dumpPublicParameters: ");
        m = request.getPublicParameterMap();
        for (Map.Entry e : m.entrySet()) {
            key = (String)e.getKey();
            values = (String[])e.getValue();
            for (i = 0; i < values.length; ++i) {
                ctx.log("    key: " + key + "   value: " + values[i]);
            }
        }
        ctx.log("dumpPrivateParameters: ");
        m = request.getPrivateParameterMap();
        for (Map.Entry e : m.entrySet()) {
            key = (String)e.getKey();
            values = (String[])e.getValue();
            for (i = 0; i < values.length; ++i) {
                ctx.log("    key: " + key + "   value: " + values[i]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFacesRequest(EventRequest request, EventResponse response) throws BridgeException, BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, NullPointerException {
        boolean removeScope;
        String scopeId;
        Lifecycle lifecycle;
        FacesContext context;
        block35: {
            block34: {
                block32: {
                    block33: {
                        StringBuffer sb;
                        String modeCheck;
                        if (!this.mInitialized) {
                            throw new BridgeUninitializedException();
                        }
                        if (request == null) throw new NullPointerException("request or response parameter is null");
                        if (response == null) {
                            throw new NullPointerException("request or response parameter is null");
                        }
                        if (this.mEventHandler == null) {
                            response.setRenderParameters(request);
                            return;
                        }
                        if (request.getParameter("_jsfBridgeNonFacesView") != null) {
                            throw new BridgeNotAFacesRequestException("NonFaces target = " + request.getParameter("_jsfBridgeNonFacesView"));
                        }
                        StringBuffer keyBuf = new StringBuffer(30);
                        String key = keyBuf.append("javax.portlet.faces.viewIdHistory").append(".view").toString();
                        if (request.getPortletSession().getAttribute(key) == null) {
                            this.initViewHistoryDefaults(request.getPortletSession(), this.mDefaultViewIdMap);
                        }
                        request.setAttribute("javax.portlet.faces.phase", (Object)Bridge.PortletPhase.EVENT_PHASE);
                        request.setAttribute(LOGGING_ENABLED, (Object)this.mDebugLoggingEnabled);
                        request.setAttribute(PORTLET_NAME_ATTRIBUTE, (Object)this.mPortletConfig.getPortletName());
                        if (this.mFacesMappings != null) {
                            request.setAttribute("org.apache.myfaces.portlet.faces.context.facesMapping", this.mFacesMappings);
                        }
                        List<String> preExistingAttributes = this.getRequestAttributes((PortletRequest)request);
                        response.setRenderParameters(request);
                        context = null;
                        lifecycle = null;
                        scopeId = this.getRequestScopeId((PortletRequest)request);
                        if (scopeId != null && scopeId.indexOf(modeCheck = (sb = new StringBuffer(10)).append(":").append(request.getPortletMode().toString()).append(":").toString()) < 0) {
                            scopeId = null;
                        }
                        boolean restoredScope = false;
                        removeScope = false;
                        restoredScope = this.restoreBridgeRequestScopeData((PortletRequest)request, scopeId);
                        try {
                            try {
                                lifecycle = this.getLifecycle();
                                context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, null);
                                if (restoredScope) {
                                    this.restoreFacesView(context, scopeId);
                                }
                                request.getPortletSession().removeAttribute("javax.portlet.faces.__jpfbReqScopeId");
                                if (scopeId != null) {
                                    response.setRenderParameter(REQUEST_SCOPE_ID_RENDER_PARAM, scopeId);
                                }
                                lifecycle.addPhaseListener((PhaseListener)this);
                                lifecycle.execute(context);
                                EventNavigationResult result = this.mEventHandler.handleEvent(context, request.getEvent());
                                if (context.getResponseComplete()) {
                                    removeScope = true;
                                    Object var14_16 = null;
                                    if (removeScope) {
                                        this.removeRequestScopes(scopeId);
                                    }
                                    this.dumpScopeId(scopeId, "EVENT_PHASE");
                                    if (lifecycle == null) break block32;
                                    break block33;
                                }
                                if (result != null) {
                                    context.getApplication().getNavigationHandler().handleNavigation(context, result.getFromAction(), result.getOutcome());
                                    if (context.getResponseComplete()) {
                                        removeScope = true;
                                        break block34;
                                    }
                                }
                                this.finalizeActionResponse(context);
                                this.processOutgoingPublicRenderParameters(context, (PortletRequest)request, (StateAwareResponse)response);
                                Boolean noScope = (Boolean)request.getAttribute("org.apache.myfaces.portlet.faces.noScope");
                                if (noScope == null || noScope.equals(Boolean.FALSE)) {
                                    if (scopeId == null) {
                                        scopeId = this.initBridgeRequestScope((PortletRequest)request, (StateAwareResponse)response);
                                    }
                                    this.saveFacesView(context);
                                    this.saveBridgeRequestScopeData(context, scopeId, preExistingAttributes);
                                    break block35;
                                } else {
                                    removeScope = true;
                                }
                                break block35;
                            }
                            catch (Exception e2) {
                                if (!this.mDebugLoggingEnabled.booleanValue()) {
                                    this.mPortletConfig.getPortletContext().log("Exception thrown in doFacesRequest:event", (Throwable)e2);
                                }
                                if (e2 instanceof BridgeException) throw (BridgeException)e2;
                                BridgeException e2 = new BridgeException((Throwable)e2);
                                throw (BridgeException)e2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_19 = null;
                            if (removeScope) {
                                this.removeRequestScopes(scopeId);
                            }
                            this.dumpScopeId(scopeId, "EVENT_PHASE");
                            if (lifecycle != null) {
                                lifecycle.removePhaseListener((PhaseListener)this);
                            }
                            if (context != null) {
                                context.getExternalContext().getRequestMap().remove(REDIRECT_VIEWPARAMS);
                                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
                                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_PRPMAP);
                                context.release();
                            }
                            request.removeAttribute("javax.portlet.faces.phase");
                            throw throwable;
                        }
                    }
                    lifecycle.removePhaseListener((PhaseListener)this);
                }
                if (context != null) {
                    context.getExternalContext().getRequestMap().remove(REDIRECT_VIEWPARAMS);
                    context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
                    context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_PRPMAP);
                    context.release();
                }
                request.removeAttribute("javax.portlet.faces.phase");
                return;
            }
            Object var14_17 = null;
            if (removeScope) {
                this.removeRequestScopes(scopeId);
            }
            this.dumpScopeId(scopeId, "EVENT_PHASE");
            if (lifecycle != null) {
                lifecycle.removePhaseListener((PhaseListener)this);
            }
            if (context != null) {
                context.getExternalContext().getRequestMap().remove(REDIRECT_VIEWPARAMS);
                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
                context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_PRPMAP);
                context.release();
            }
            request.removeAttribute("javax.portlet.faces.phase");
            return;
        }
        Object var14_18 = null;
        if (removeScope) {
            this.removeRequestScopes(scopeId);
        }
        this.dumpScopeId(scopeId, "EVENT_PHASE");
        if (lifecycle != null) {
            lifecycle.removePhaseListener((PhaseListener)this);
        }
        if (context != null) {
            context.getExternalContext().getRequestMap().remove(REDIRECT_VIEWPARAMS);
            context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
            context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_PRPMAP);
            context.release();
        }
        request.removeAttribute("javax.portlet.faces.phase");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFacesRequest(RenderRequest request, RenderResponse response) throws BridgeException, BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, NullPointerException {
        block21: {
            if (!this.mInitialized) {
                throw new BridgeUninitializedException();
            }
            if (request == null) throw new NullPointerException("request or response parameter is null");
            if (response == null) {
                throw new NullPointerException("request or response parameter is null");
            }
            if (request.getParameter("_jsfBridgeNonFacesView") != null) {
                throw new BridgeNotAFacesRequestException("NonFaces target = " + request.getParameter("_jsfBridgeNonFacesView"));
            }
            this.dumpParameters((PortletRequest)request);
            StringBuffer keyBuf = new StringBuffer(30);
            String key = keyBuf.append("javax.portlet.faces.viewIdHistory").append(".view").toString();
            if (request.getPortletSession().getAttribute(key) == null) {
                this.initViewHistoryDefaults(request.getPortletSession(), this.mDefaultViewIdMap);
            }
            String scopeId = null;
            boolean restoredScope = false;
            boolean restoredView = false;
            request.setAttribute("javax.portlet.faces.phase", (Object)Bridge.PortletPhase.RENDER_PHASE);
            request.setAttribute(LOGGING_ENABLED, (Object)this.mDebugLoggingEnabled);
            request.setAttribute(PORTLET_NAME_ATTRIBUTE, (Object)this.mPortletConfig.getPortletName());
            if (this.mWriteBehindRenderResponseWrapper != null) {
                request.setAttribute(WRITE_BEHIND_RESPONSE, this.mWriteBehindRenderResponseWrapper);
            }
            if (this.mFacesMappings != null) {
                request.setAttribute("org.apache.myfaces.portlet.faces.context.facesMapping", this.mFacesMappings);
            }
            List<String> preExistingAttributes = this.getRequestAttributes((PortletRequest)request);
            boolean clientDirectedView = request.getAttribute("javax.portlet.faces.viewId") != null || request.getAttribute("javax.portlet.faces.viewPath") != null;
            QueryString redirectParams = (QueryString)request.getPortletSession(true).getAttribute(RENDER_REDIRECT_VIEWPARAMS);
            boolean modeChanged = this.hasModeChanged(request, redirectParams);
            if (redirectParams != null) {
                if (clientDirectedView || modeChanged) {
                    redirectParams = null;
                    request.getPortletSession().removeAttribute(RENDER_REDIRECT_VIEWPARAMS);
                    request.getPortletSession().removeAttribute(RENDER_REDIRECT_PRPMAP);
                } else {
                    this.updatePublicRedirectParams((PortletRequest)request, redirectParams, (Map)request.getPortletSession(true).getAttribute(RENDER_REDIRECT_PRPMAP));
                }
            }
            if (redirectParams == null && !clientDirectedView) {
                scopeId = this.getRequestScopeId((PortletRequest)request);
            }
            if (scopeId != null) {
                restoredScope = this.restoreBridgeRequestScopeData((PortletRequest)request, scopeId);
            } else {
                scopeId = this.initBridgeRequestScope((PortletRequest)request, null);
            }
            FacesContext context = null;
            try {
                try {
                    Lifecycle lifecycle = this.getLifecycle();
                    context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, redirectParams);
                    ExternalContext extCtx = context.getExternalContext();
                    RenderRequest extRequest = (RenderRequest)extCtx.getRequest();
                    if (restoredScope) {
                        extRequest = this.restoreActionParams(context);
                        restoredView = this.restoreFacesView(context, scopeId);
                    }
                    if (extCtx.getRequestParameterValuesMap().containsKey("javax.faces.ViewState")) {
                        extCtx.getRequestMap().put("javax.portlet.faces.isPostback", Boolean.TRUE);
                    }
                    this.doFacesRender((PortletRequest)request, (MimeResponse)response, context, lifecycle, scopeId, preExistingAttributes);
                    context = FacesContext.getCurrentInstance();
                    extCtx = context.getExternalContext();
                }
                catch (Exception e2) {
                    context = FacesContext.getCurrentInstance();
                    if (!this.mDebugLoggingEnabled.booleanValue()) {
                        this.mPortletConfig.getPortletContext().log("Exception thrown in doFacesRequest:render", (Throwable)e2);
                    }
                    if (e2 instanceof BridgeException) throw (BridgeException)e2;
                    BridgeException e2 = new BridgeException((Throwable)e2);
                    throw (BridgeException)e2;
                }
                Object var17_18 = null;
                this.dumpScopeId(scopeId, "RENDER_PHASE");
                if (context == null) break block21;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                this.dumpScopeId(scopeId, "RENDER_PHASE");
                if (context != null) {
                    context.release();
                }
                request.removeAttribute("javax.portlet.faces.phase");
                throw throwable;
            }
            context.release();
        }
        request.removeAttribute("javax.portlet.faces.phase");
    }

    private boolean hasModeChanged(RenderRequest request, QueryString renderRedirectParams) {
        String mode;
        int i;
        boolean hasModeChanged = false;
        String targetViewId = null;
        targetViewId = renderRedirectParams == null ? request.getParameter("__jpfbJSFTARGET") : renderRedirectParams.getParameter("__jpfbJSFTARGET");
        if (targetViewId != null && (i = targetViewId.indexOf(58)) >= 0 && !(mode = targetViewId.substring(0, i)).equalsIgnoreCase(request.getPortletMode().toString())) {
            hasModeChanged = true;
        }
        return hasModeChanged;
    }

    private void doFacesRender(PortletRequest request, MimeResponse response, FacesContext context, Lifecycle lifecycle, String scopeId, List<String> preExistingAttributes) throws BridgeException, BridgeUninitializedException, NullPointerException {
        boolean redirectedDuringRender = false;
        try {
            try {
                lifecycle.addPhaseListener((PhaseListener)this);
                lifecycle.execute(context);
            }
            catch (Exception e2) {
                BridgeException e2;
                if (!(e2 instanceof BridgeException)) {
                    e2 = new BridgeException((Throwable)e2);
                }
                throw (BridgeException)e2;
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            lifecycle.removePhaseListener((PhaseListener)this);
            throw throwable;
        }
        lifecycle.removePhaseListener((PhaseListener)this);
        QueryString redirectParams = (QueryString)context.getExternalContext().getRequestMap().get(REDIRECT_VIEWPARAMS);
        if (redirectParams == null) {
            if (!context.getResponseComplete()) {
                lifecycle.render(context);
            }
        } else {
            this.redirectRender(context, lifecycle, request, response, redirectParams, preExistingAttributes);
            context = FacesContext.getCurrentInstance();
            redirectedDuringRender = true;
        }
        if ((redirectParams = (QueryString)context.getExternalContext().getRequestMap().get(REDIRECT_VIEWPARAMS)) != null) {
            this.redirectRender(context, lifecycle, request, response, redirectParams, preExistingAttributes);
            context = FacesContext.getCurrentInstance();
            redirectedDuringRender = true;
        }
        if (scopeId != null && !redirectedDuringRender) {
            context.getExternalContext().getRequestMap().put(SCOPE_VIEW_KEY, this.getScopeViewKey(context.getExternalContext()));
            this.saveFacesMessageState(context);
            this.saveBridgeRequestScopeData(context, scopeId, preExistingAttributes);
            this.updateViewInfo(context, scopeId);
        } else {
            if (scopeId != null) {
                this.removeRequestScopes(scopeId);
            }
            scopeId = this.initBridgeRequestScope(request, null);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put(SCOPE_VIEW_KEY, this.getScopeViewKey(context.getExternalContext()));
            this.putBridgeRequestScopeData(scopeId, m);
            this.updateViewInfo(context, scopeId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFacesRequest(ResourceRequest request, ResourceResponse response) throws BridgeException, BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, NullPointerException {
        block15: {
            if (!this.mInitialized) {
                throw new BridgeUninitializedException();
            }
            if (request == null) throw new NullPointerException("request or response parameter is null");
            if (response == null) {
                throw new NullPointerException("request or response parameter is null");
            }
            request.setAttribute("javax.portlet.faces.phase", (Object)Bridge.PortletPhase.RESOURCE_PHASE);
            request.setAttribute(LOGGING_ENABLED, (Object)this.mDebugLoggingEnabled);
            if (!this.isFacesResourceRequest(request)) {
                try {
                    String target = request.getResourceID();
                    PortletRequestDispatcher rd = this.mPortletConfig.getPortletContext().getRequestDispatcher(target);
                    rd.forward((PortletRequest)request, (PortletResponse)response);
                    return;
                }
                catch (Exception e2) {
                    if (e2 instanceof BridgeException) throw (BridgeException)e2;
                    BridgeException e2 = new BridgeException((Throwable)e2);
                    throw (BridgeException)e2;
                }
            }
            StringBuffer keyBuf = new StringBuffer(30);
            String key = keyBuf.append("javax.portlet.faces.viewIdHistory").append(".view").toString();
            if (request.getPortletSession().getAttribute(key) == null) {
                this.initViewHistoryDefaults(request.getPortletSession(), this.mDefaultViewIdMap);
            }
            request.setAttribute(PORTLET_NAME_ATTRIBUTE, (Object)this.mPortletConfig.getPortletName());
            if (this.mWriteBehindResourceResponseWrapper != null) {
                request.setAttribute(WRITE_BEHIND_RESPONSE, this.mWriteBehindResourceResponseWrapper);
            }
            if (this.mFacesMappings != null) {
                request.setAttribute("org.apache.myfaces.portlet.faces.context.facesMapping", this.mFacesMappings);
            }
            List<String> preExistingAttributes = this.getRequestAttributes((PortletRequest)request);
            FacesContext context = null;
            String scopeId = null;
            try {
                try {
                    Lifecycle lifecycle = this.getLifecycle();
                    context = this.getFacesContext((PortletRequest)request, (PortletResponse)response, lifecycle, null);
                    ExternalContext extCtx = context.getExternalContext();
                    ResourceRequest extRequest = (ResourceRequest)extCtx.getRequest();
                    scopeId = this.getResourceRequestScopeId(extCtx, (PortletRequest)request);
                    this.doFacesRender((PortletRequest)request, (MimeResponse)response, context, lifecycle, scopeId, preExistingAttributes);
                }
                catch (Exception e3) {
                    if (!this.mDebugLoggingEnabled.booleanValue()) {
                        context.getExternalContext().log("Exception thrown in doFacesRequest:resource", (Throwable)e3);
                    }
                    if (e3 instanceof BridgeException) throw (BridgeException)e3;
                    BridgeException e3 = new BridgeException((Throwable)e3);
                    throw (BridgeException)e3;
                }
                Object var12_17 = null;
                this.dumpScopeId(scopeId, "RENDER_PHASE");
                if (context == null) break block15;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                this.dumpScopeId(scopeId, "RENDER_PHASE");
                if (context != null) {
                    context.release();
                }
                request.removeAttribute("javax.portlet.faces.phase");
                throw throwable;
            }
            context.release();
        }
        request.removeAttribute("javax.portlet.faces.phase");
    }

    private boolean isFacesResourceRequest(ResourceRequest request) {
        return request.getParameter("__jpfbJSFTARGET") != null || request.getParameter("_jsfBridgeViewId") != null || request.getParameter("_jsfBridgeViewPath") != null;
    }

    public void destroy() {
        if (!this.mInitialized) {
            return;
        }
        this.mInitialized = false;
        ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication().removeELContextListener((ELContextListener)this);
        this.removeRequestScopes(this.qualifyScopeId(this.mPortletConfig.getPortletName(), null, null, null));
        this.mPortletConfig = null;
    }

    public void contextCreated(ELContextEvent ece) {
        ELContext elContext = ece.getELContext();
        String portletName = (String)((FacesContext)elContext.getContext(FacesContext.class)).getExternalContext().getRequestMap().get(PORTLET_NAME_ATTRIBUTE);
        if (portletName != null && portletName.equals(this.mPortletConfig.getPortletName())) {
            PortletELContextImpl portletELContext;
            if (elContext instanceof PortletELContextImpl) {
                portletELContext = (PortletELContextImpl)elContext;
                portletELContext.setFacesResolved(true);
                portletELContext.setPortletConfig(this.mPortletConfig);
            } else {
                portletELContext = new PortletELContextImpl(elContext.getELResolver());
                portletELContext.setFacesResolved(false);
            }
            elContext.putContext(PortletELContextImpl.class, (Object)portletELContext);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent srae) {
        Bridge.PortletPhase phase = (Bridge.PortletPhase)srae.getServletRequest().getAttribute("javax.portlet.faces.phase");
        if (phase == null || phase == Bridge.PortletPhase.RENDER_PHASE || this.isExcludedFromBridgeRequestScope(srae.getName(), srae.getValue(), (List)srae.getServletRequest().getAttribute(PREEXISTING_ATTRIBUTE_NAMES))) {
            return;
        }
        Object o = srae.getValue();
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(BridgeRequestScopeAttributeAdded.class)) continue;
            try {
                methods[i].invoke(o, null);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent srae) {
        Bridge.PortletPhase phase = (Bridge.PortletPhase)srae.getServletRequest().getAttribute("javax.portlet.faces.phase");
        if (phase != null && phase != Bridge.PortletPhase.RENDER_PHASE) {
            this.notifyPreDestroy(srae.getValue());
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent srae) {
        Bridge.PortletPhase phase = (Bridge.PortletPhase)srae.getServletRequest().getAttribute("javax.portlet.faces.phase");
        if (phase != null && phase != Bridge.PortletPhase.RENDER_PHASE) {
            this.notifyPreDestroy(srae.getValue());
        }
    }

    private void initViewHistoryDefaults(PortletSession session, Map<String, String> viewIdDefaultMap) {
        Set<String> keys = viewIdDefaultMap.keySet();
        for (String mode : keys) {
            String modeView = viewIdDefaultMap.get(mode);
            if (modeView == null || modeView.length() == 0) continue;
            String defaultViewId = this.encodeMode(mode, modeView);
            StringBuffer key = new StringBuffer(100);
            session.setAttribute(key.append("javax.portlet.faces.viewIdHistory").append('.').append(mode).toString(), (Object)defaultViewId);
        }
    }

    private String encodeMode(String mode, String viewId) {
        StringBuffer sb = new StringBuffer(viewId.length() + 30);
        int queryStart = viewId.indexOf(63);
        if (queryStart < 0) {
            return sb.append(viewId).append('?').append("javax.portlet.faces.PortletMode").append('=').append(mode).toString();
        }
        QueryString qs = new QueryString(viewId.substring(queryStart + 1), "UTF8");
        qs.setParameter("javax.portlet.faces.PortletMode", mode);
        return sb.append(viewId.substring(0, queryStart + 1)).append(qs.toString()).toString();
    }

    private ArrayList<String> getPublicParameterNamesList() {
        Enumeration e = this.mPortletConfig.getPublicRenderParameterNames();
        ArrayList<String> l = new ArrayList<String>();
        if (!e.hasMoreElements()) {
            return l;
        }
        while (e.hasMoreElements()) {
            l.add((String)e.nextElement());
        }
        Collections.sort(l);
        return l;
    }

    private RenderRequest wrapRequestToRedirect(RenderRequest request, QueryString redirectParams) {
        redirectParams.removeParameter("javax.portlet.faces.DirectLink");
        redirectParams.removeParameter("javax.portlet.faces.PortletMode");
        redirectParams.removeParameter("javax.portlet.faces.WindowState");
        redirectParams.removeParameter("javax.portlet.faces.Secure");
        LinkedHashMap<String, String[]> publicParamMap = new LinkedHashMap<String, String[]>(redirectParams.numParameters());
        LinkedHashMap<String, String[]> privateParamMap = new LinkedHashMap<String, String[]>(redirectParams.numParameters());
        ArrayList<String> publicParamNamesList = this.getPublicParameterNamesList();
        Enumeration<String> nameEnum = redirectParams.getParameterNames();
        while (nameEnum != null && nameEnum.hasMoreElements()) {
            String name = nameEnum.nextElement();
            Enumeration<String> valuesEnum = redirectParams.getParameterValues(name);
            ArrayList<String> values = new ArrayList<String>();
            while (valuesEnum != null && valuesEnum.hasMoreElements()) {
                values.add(valuesEnum.nextElement());
            }
            if (Collections.binarySearch(publicParamNamesList, name) >= 0) {
                publicParamMap.put(name, values.toArray(new String[values.size()]));
                continue;
            }
            privateParamMap.put(name, values.toArray(new String[values.size()]));
        }
        return new BridgeRenderRequestWrapper(request, privateParamMap, publicParamMap, false);
    }

    private void updatePublicRedirectParams(PortletRequest request, QueryString redirectParams, Map<String, String[]> cachedPRPs) {
        String key;
        Map prps = request.getPublicParameterMap();
        boolean modified = false;
        if (cachedPRPs == null) {
            cachedPRPs = Collections.EMPTY_MAP;
        }
        for (Map.Entry entry : cachedPRPs.entrySet()) {
            key = (String)entry.getKey();
            if (prps.containsKey(key)) {
                if (Arrays.equals((Object[])prps.get(key), (Object[])cachedPRPs.get(key))) continue;
                modified = true;
                redirectParams.removeParameter(key);
                for (String param : (String[])prps.get(key)) {
                    redirectParams.addParameter(key, param);
                }
                continue;
            }
            modified = true;
            redirectParams.removeParameter(key);
        }
        for (Map.Entry entry : prps.entrySet()) {
            key = (String)entry.getKey();
            if (cachedPRPs.containsKey(key)) continue;
            for (String param : (String[])prps.get(key)) {
                modified = true;
                redirectParams.addParameter(key, param);
            }
        }
        if (modified) {
            request.getPortletSession().setAttribute(RENDER_REDIRECT_VIEWPARAMS, (Object)redirectParams);
            request.getPortletSession().setAttribute(RENDER_REDIRECT_PRPMAP, new HashMap(prps));
        }
    }

    private void redirectRender(FacesContext context, Lifecycle lifecycle, PortletRequest request, MimeResponse response, QueryString redirectParams, List<String> preExistingAttrs) {
        if (context.getExternalContext().getSessionMap().get(RENDER_REDIRECT_PRPMAP) == null) {
            context.getExternalContext().getSessionMap().put(RENDER_REDIRECT_PRPMAP, new HashMap(request.getPublicParameterMap()));
        }
        Boolean hasRenderRedirectedAfterForward = (Boolean)request.getAttribute(HAS_RENDER_REDIRECTED_AFTER_FORWARD);
        context.release();
        if (hasRenderRedirectedAfterForward != null) {
            request.setAttribute(HAS_RENDER_REDIRECTED_AFTER_FORWARD, (Object)hasRenderRedirectedAfterForward);
        }
        this.getRequestAttributes(request);
        context = this.getFacesContext(request, (PortletResponse)response, lifecycle, redirectParams);
        context.getExternalContext().getSessionMap().remove(RENDER_REDIRECT_VIEWPARAMS);
        this.doFacesRender(request, response, context, lifecycle, null, preExistingAttrs);
        context = FacesContext.getCurrentInstance();
        if (context.getExternalContext().getSessionMap().get(RENDER_REDIRECT_VIEWPARAMS) == null) {
            context.getExternalContext().getSessionMap().put(RENDER_REDIRECT_VIEWPARAMS, redirectParams);
        }
    }

    private FacesContextFactory getFacesContextFactory() throws BridgeException {
        try {
            if (this.mFacesContextFactory == null) {
                this.mFacesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            }
            return this.mFacesContextFactory;
        }
        catch (FacesException e) {
            throw new BridgeException((Throwable)e);
        }
    }

    private FacesContext getFacesContext(PortletRequest request, PortletResponse response, Lifecycle lifecycle, QueryString redirectParams) throws FacesException {
        FacesContext context = null;
        context = this.getFacesContextFactory().getFacesContext((Object)this.mPortletConfig.getPortletContext(), (Object)request, (Object)response, lifecycle);
        if (redirectParams != null) {
            context.getExternalContext().setRequest((Object)this.wrapRequestToRedirect((RenderRequest)request, redirectParams));
        }
        return context;
    }

    private Lifecycle getLifecycle() throws BridgeException {
        try {
            if (this.mLifecycle == null) {
                LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
                String lifecycleId = this.mPortletConfig.getPortletContext().getInitParameter("javax.faces.LIFECYCLE_ID");
                if (lifecycleId == null) {
                    lifecycleId = "DEFAULT";
                }
                this.mLifecycle = lifecycleFactory.getLifecycle(lifecycleId);
            }
            return this.mLifecycle;
        }
        catch (FacesException e) {
            throw new BridgeException((Throwable)e);
        }
    }

    private void saveFacesView(FacesContext context) {
        this.saveFacesMessageState(context);
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(FACES_VIEWROOT, context.getViewRoot());
    }

    private boolean restoreFacesView(FacesContext context, String scopeId) {
        Map requestMap = context.getExternalContext().getRequestMap();
        UIViewRoot viewRoot = (UIViewRoot)requestMap.get(FACES_VIEWROOT);
        if (viewRoot != null) {
            context.setViewRoot(viewRoot);
            requestMap.remove(FACES_VIEWROOT);
        }
        return viewRoot != null;
    }

    private void saveActionParams(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Map requestMap = ec.getRequestMap();
        Map requestParameterMap = ec.getRequestParameterValuesMap();
        if (this.mPreserveActionParams.equals(Boolean.FALSE)) {
            HashMap<String, Object> m = new HashMap<String, Object>(1);
            if (requestParameterMap != null && requestParameterMap.containsKey("javax.faces.ViewState")) {
                m.put("javax.faces.ViewState", requestParameterMap.get("javax.faces.ViewState"));
            } else {
                m.put("javax.faces.ViewState", new String[]{NULL_VIEW_STATE_PARAM_VALUE});
            }
            requestMap.put(REQUEST_PARAMETERS, m);
        } else {
            HashMap mutableParams = new HashMap(requestParameterMap);
            requestMap.put(REQUEST_PARAMETERS, mutableParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewInfo(FacesContext context, String scopeId) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                return;
            }
            Map scopeMap = (Map)requestScopeMap.get(scopeId);
            if (scopeMap == null) {
                return;
            }
            HashMap<String, String[]> requestParams = (HashMap<String, String[]>)scopeMap.get(REQUEST_PARAMETERS);
            if (requestParams == null) {
                requestParams = new HashMap<String, String[]>(1);
                scopeMap.put(REQUEST_PARAMETERS, requestParams);
            }
            String[] values = new String[1];
            String updatedViewStateParam = (String)context.getExternalContext().getRequestMap().get(UPDATED_VIEW_STATE_PARAM);
            if (updatedViewStateParam != null) {
                values[0] = updatedViewStateParam;
                requestParams.put("javax.faces.ViewState", values);
            }
            scopeMap.remove(FACES_VIEWROOT);
        }
    }

    private LRUMap createRequestScopeMap(PortletContext portletContext) {
        int managedScopes = 100;
        String managedScopesSetting = portletContext.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
        if (managedScopesSetting != null) {
            managedScopes = Integer.parseInt(managedScopesSetting);
        }
        return new LRUMap(managedScopes);
    }

    private RenderRequest restoreActionParams(FacesContext context) {
        ExternalContext ec = context.getExternalContext();
        Map m = (Map)ec.getRequestMap().get(REQUEST_PARAMETERS);
        Object wrapped = (RenderRequest)ec.getRequest();
        if (m != null && !m.isEmpty()) {
            wrapped = new BridgeRenderRequestWrapper((RenderRequest)wrapped, m);
            ec.setRequest(wrapped);
        }
        return wrapped;
    }

    public void saveFacesMessageState(FacesContext context) {
        Iterator clientIds = context.getClientIdsWithMessages();
        if (clientIds.hasNext()) {
            FacesMessageState state = new FacesMessageState();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator messages = context.getMessages(clientId);
                while (messages.hasNext()) {
                    state.addMessage(clientId, (FacesMessage)messages.next());
                }
            }
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(FACES_MESSAGES, state);
        }
    }

    private void restoreFacesMessageState(FacesContext context) {
        Map map;
        FacesMessageState state;
        if (context.getExternalContext().getRequest() instanceof RenderRequest && (state = (FacesMessageState)(map = context.getExternalContext().getRequestMap()).get(FACES_MESSAGES)) != null) {
            for (String clientId : state.getClientIds()) {
                for (FacesMessage message : state.getMessages(clientId)) {
                    context.addMessage(clientId, message);
                }
            }
        }
    }

    private String getResourceRequestScopeId(ExternalContext extCtx, PortletRequest request) {
        String scopeId = this.getRequestScopeId(request);
        if (scopeId == null) {
            return this.initBridgeRequestScope(request, null);
        }
        Map<String, Object> m = this.getScopeMap(scopeId);
        HashMap<String, String> childResourceScopeMap = (HashMap<String, String>)m.get(CHILD_RESOURCE_REQUEST_SCOPE_MAP);
        String scopeIdKey = (String)m.get(SCOPE_VIEW_KEY);
        String childIdKey = this.getScopeViewKey(extCtx);
        if (scopeIdKey != null && scopeIdKey.equalsIgnoreCase(childIdKey)) {
            return scopeId;
        }
        String childScopeId = null;
        if (childResourceScopeMap != null) {
            childScopeId = (String)childResourceScopeMap.get(childIdKey);
        }
        if (childScopeId == null) {
            childScopeId = this.createBridgeRequestScope(request);
            if (childResourceScopeMap == null) {
                childResourceScopeMap = new HashMap<String, String>(3);
                m.put(CHILD_RESOURCE_REQUEST_SCOPE_MAP, childResourceScopeMap);
            }
            childResourceScopeMap.put(childIdKey, childScopeId);
        }
        return childScopeId;
    }

    private String getScopeViewKey(ExternalContext extCtx) {
        String scopeIdKey = null;
        String pathInfo = extCtx.getRequestPathInfo();
        String servletPath = extCtx.getRequestServletPath();
        scopeIdKey = pathInfo == null ? servletPath : (servletPath == null ? pathInfo : servletPath + pathInfo);
        return scopeIdKey;
    }

    private String getRequestScopeId(PortletRequest request) {
        StringBuffer sb;
        String modeCheck;
        PortletSession session;
        boolean fromSession = false;
        String scopeId = request.getParameter(REQUEST_SCOPE_ID_RENDER_PARAM);
        if (scopeId == null && (session = request.getPortletSession()) != null) {
            scopeId = (String)session.getAttribute("javax.portlet.faces.__jpfbReqScopeId");
            fromSession = true;
        }
        if (scopeId != null && scopeId.indexOf(modeCheck = (sb = new StringBuffer(10)).append(":").append(request.getPortletMode().toString()).append(":").toString()) < 0) {
            scopeId = null;
        }
        return scopeId;
    }

    private String createBridgeRequestScope(PortletRequest request) {
        UID uid = new UID();
        return this.qualifyScopeId(this.mPortletConfig.getPortletName(), request.getPortletSession(true).getId(), request.getPortletMode().toString(), uid.toString());
    }

    private String initBridgeRequestScope(PortletRequest request, StateAwareResponse response) {
        String requestScopeId = this.createBridgeRequestScope(request);
        if (response != null) {
            response.setRenderParameter(REQUEST_SCOPE_ID_RENDER_PARAM, requestScopeId);
        } else {
            PortletSession session = request.getPortletSession(true);
            session.setAttribute("javax.portlet.faces.__jpfbReqScopeId", (Object)requestScopeId);
        }
        return requestScopeId;
    }

    private void saveBridgeRequestScopeData(FacesContext context, String scopeId, List<String> preExistingList) {
        this.putBridgeRequestScopeData(scopeId, this.copyRequestMap(context.getExternalContext().getRequestMap(), preExistingList));
        this.watchScope(context, scopeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBridgeRequestScopeData(String scopeId, Map<String, Object> o) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            Map existing;
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                requestScopeMap = this.createRequestScopeMap(portletContext);
                portletContext.setAttribute(REQUEST_SCOPE_MAP, (Object)requestScopeMap);
            }
            if (BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RESOURCE_PHASE && (existing = (Map)requestScopeMap.get(scopeId)) != null) {
                for (Map.Entry e : existing.entrySet()) {
                    if (o.containsKey(e.getKey())) continue;
                    o.put((String)e.getKey(), e.getValue());
                }
            }
            requestScopeMap.put(scopeId, o);
        }
    }

    private Map<String, Object> copyRequestMap(Map<String, Object> m, List<String> preExistingList) {
        HashMap<String, Object> copy = new HashMap<String, Object>(m.size());
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (this.isExcludedFromBridgeRequestScope(key, value = entry.getValue(), preExistingList)) continue;
            copy.put(key, value);
        }
        return copy;
    }

    private List<String> getRequestAttributes(PortletRequest request) {
        ArrayList<String> requestAttributeNames = Collections.list(request.getAttributeNames());
        if (requestAttributeNames != null) {
            request.setAttribute(PREEXISTING_ATTRIBUTE_NAMES, requestAttributeNames);
        }
        return requestAttributeNames;
    }

    private boolean isExcludedFromBridgeRequestScope(String key, Object value, List<String> preExistingList) {
        return value != null && value.getClass().getAnnotation(ExcludeFromManagedRequestScope.class) != null || preExistingList != null && preExistingList.contains(key) || this.isPreDefinedExcludedObject(key, value) || this.isConfiguredExcludedAttribute(key);
    }

    private boolean isPreDefinedExcludedObject(String s, Object o) {
        if (o != null && (o instanceof PortletConfig || o instanceof PortletContext || o instanceof PortletRequest || o instanceof PortletResponse || o instanceof PortletSession || o instanceof PortletPreferences || o instanceof PortalContext || o instanceof FacesContext || o instanceof ExternalContext || o instanceof ServletConfig || o instanceof ServletContext || o instanceof ServletRequest || o instanceof ServletResponse || o instanceof HttpSession)) {
            return true;
        }
        return this.isInNamespace(s, "javax.portlet.") || this.isInNamespace(s, "javax.portlet.faces.") || this.isInNamespace(s, "javax.faces.") || this.isInNamespace(s, "javax.servlet.") || this.isInNamespace(s, "javax.servlet.include.") || this.isInNamespace(s, "org.apache.myfaces.portlet.faces.") || s.startsWith("org.apache.myfaces.portlet.faces.context.");
    }

    private boolean isConfiguredExcludedAttribute(String s) {
        if (this.mExcludedRequestAttributes == null) {
            return false;
        }
        if (this.mExcludedRequestAttributes.contains(s)) {
            return true;
        }
        for (String exclude : this.mExcludedRequestAttributes) {
            if (!exclude.endsWith("*") || !this.isInNamespace(s, exclude.substring(0, exclude.length() - 1))) continue;
            return true;
        }
        return false;
    }

    private boolean isInNamespace(String s, String namespace) {
        if (s.startsWith(namespace)) {
            s = s.substring(0, s.lastIndexOf(46) + 1);
            return s.equals(namespace);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getScopeMap(String scopeId) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                return null;
            }
            return (Map)requestScopeMap.get(scopeId);
        }
    }

    private boolean restoreBridgeRequestScopeData(PortletRequest request, String scopeId) throws BridgeException {
        if (scopeId == null) {
            return false;
        }
        Map<String, Object> m = this.getScopeMap(scopeId);
        if (m == null) {
            return false;
        }
        Set<Map.Entry<String, Object>> s = m.entrySet();
        for (Map.Entry<String, Object> e : s) {
            request.setAttribute(e.getKey(), e.getValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromBridgeRequestScopeData(FacesContext context, String scopeId, String key) {
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Map m = null;
        if (scopeId == null) {
            return false;
        }
        Object object = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap == null) {
                return false;
            }
            m = (Map)requestScopeMap.get(scopeId);
            if (m != null) {
                return m.remove(key) != null;
            }
        }
        return false;
    }

    private String qualifyScopeId(String portletId, String sessionId, String mode, String scopeId) {
        if (portletId == null) {
            portletId = this.mPortletConfig.getPortletName();
        }
        StringBuffer sb = new StringBuffer(portletId);
        sb.append(':');
        if (sessionId != null) {
            sb.append(sessionId);
            sb.append(':');
            if (mode != null) {
                sb.append(mode);
                sb.append(':');
                if (scopeId != null) {
                    sb.append(scopeId);
                }
            }
        }
        return sb.toString();
    }

    private void watchScope(FacesContext context, String scopeId) {
        RequestScopeListener scopeListener;
        PortletSession session = (PortletSession)context.getExternalContext().getSession(true);
        if (session != null && (scopeListener = (RequestScopeListener)session.getAttribute(REQUEST_SCOPE_LISTENER)) == null) {
            session.setAttribute(REQUEST_SCOPE_LISTENER, (Object)new RequestScopeListener(this.qualifyScopeId(this.mPortletConfig.getPortletName(), session.getId(), null, null)));
        }
    }

    private boolean processIncomingPublicRenderParameters(FacesContext context, PortletRequest request) {
        boolean paramsMapped = false;
        if (this.mPublicParameterMappings == null) {
            return false;
        }
        Enumeration e = this.mPortletConfig.getPublicRenderParameterNames();
        if (!e.hasMoreElements()) {
            return false;
        }
        Map m = request.getPublicParameterMap();
        Application app = context.getApplication();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String prefixedName = new StringBuffer(this.mPortletConfig.getPortletName()).append(":").append(name).toString();
            boolean isPrefixed = this.mPublicParameterMappings.containsKey(prefixedName);
            if (!isPrefixed && !this.mPublicParameterMappings.containsKey(name)) continue;
            if (m.containsKey(name)) {
                String[] newVals = (String[])m.get(name);
                String expr = this.mPublicParameterMappings.get(isPrefixed ? prefixedName : name);
                ValueExpression valExpr = app.getExpressionFactory().createValueExpression(context.getELContext(), expr, String.class);
                String curVal = (String)valExpr.getValue(context.getELContext());
                if (curVal != null && curVal.equals(newVals[0])) continue;
                valExpr.setValue(context.getELContext(), (Object)newVals[0]);
                paramsMapped = true;
                continue;
            }
            String expr = this.mPublicParameterMappings.get(isPrefixed ? prefixedName : name);
            ValueExpression valExpr = app.getExpressionFactory().createValueExpression(context.getELContext(), expr, String.class);
            try {
                String curVal = (String)valExpr.getValue(context.getELContext());
                if (curVal == null || curVal.length() <= 0) continue;
                valExpr.setValue(context.getELContext(), null);
                paramsMapped = true;
            }
            catch (Exception ex) {}
        }
        if (paramsMapped && this.mProcessPRPHandler != null) {
            this.mProcessPRPHandler.processUpdates(context);
        }
        return paramsMapped;
    }

    private void processOutgoingPublicRenderParameters(FacesContext context, PortletRequest request, StateAwareResponse response) {
        if (this.mPublicParameterMappings == null) {
            return;
        }
        Application app = context.getApplication();
        Enumeration e = this.mPortletConfig.getPublicRenderParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            String expr = this.mPublicParameterMappings.get(new StringBuffer(this.mPortletConfig.getPortletName()).append(":").append(s).toString());
            if (expr == null && (expr = this.mPublicParameterMappings.get(s)) == null) continue;
            ValueExpression valExpr = app.getExpressionFactory().createValueExpression(context.getELContext(), expr, String.class);
            try {
                String value = (String)valExpr.getValue(context.getELContext());
                Map m = request.getPublicParameterMap();
                if (value != null) {
                    String[] requestVals = (String[])m.get(s);
                    if (requestVals != null && requestVals[0].equals(value)) continue;
                    response.setRenderParameter(s, value);
                    continue;
                }
                if (!m.containsKey(s)) continue;
                response.removePublicRenderParameter(s);
            }
            catch (Exception exception) {}
        }
    }

    private void finalizeActionResponse(FacesContext context) throws IOException {
        context.getExternalContext().getRequestMap().put("org.apache.myfaces.portlet.faces.noScope", Boolean.FALSE);
        String viewId = context.getViewRoot().getViewId();
        String qs = (String)context.getViewRoot().getAttributes().remove(VIEWID_QUERYSTRING_ATTRIBUTE);
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        String viewURL = viewHandler.getActionURL(context, viewId);
        if (qs != null && qs.length() > 1) {
            viewURL = viewURL.indexOf(63) < 0 ? viewURL.concat(qs) : viewURL + "&" + qs.substring(1);
        }
        context.getExternalContext().encodeActionURL(viewURL);
    }

    private void notifyPreDestroy(Map<String, Object> scope) {
        Iterator<Map.Entry<Object, Object>> i;
        Set<Map.Entry<Object, Object>> s;
        Map childMap = (Map)scope.get(CHILD_RESOURCE_REQUEST_SCOPE_MAP);
        if (childMap != null) {
            s = childMap.entrySet();
            i = s.iterator();
            while (i.hasNext()) {
                this.removeRequestScopes((String)i.next().getValue());
            }
        }
        s = scope.entrySet();
        i = s.iterator();
        while (i.hasNext()) {
            this.notifyPreDestroy(i.next().getValue());
        }
    }

    private void notifyPreDestroy(Object o) {
        Method[] methods = o.getClass().getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if (!methods[m].isAnnotationPresent(BridgePreDestroy.class)) continue;
            try {
                methods[m].invoke(o, null);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequestScopes(String scopePrefix) {
        if (scopePrefix == null || this.mPortletConfig == null) {
            return;
        }
        PortletContext portletContext = this.mPortletConfig.getPortletContext();
        Object lock = portletContext.getAttribute(REQUEST_SCOPE_LOCK);
        if (lock == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            LRUMap requestScopeMap = (LRUMap)portletContext.getAttribute(REQUEST_SCOPE_MAP);
            if (requestScopeMap != null) {
                Vector<String> scopesToRemove = new Vector<String>(5);
                for (String scopeId : requestScopeMap.keySet()) {
                    if (scopeId == null || !scopeId.startsWith(scopePrefix)) continue;
                    scopesToRemove.add(scopeId);
                }
                for (String scopeId : scopesToRemove) {
                    if (scopeId == null) continue;
                    requestScopeMap.remove(scopeId);
                }
            }
        }
    }

    private void processFacesConfiguration(PortletContext context) {
        FacesConfigurationProcessor processor = new FacesConfigurationProcessor(context);
        this.mPublicParameterMappings = processor.getPublicParameterMappings();
        this.mWriteBehindRenderResponseWrapper = this.validateWrapperClass(processor.getWriteBehindRenderResponseWrapperClassName());
        this.mWriteBehindResourceResponseWrapper = this.validateWrapperClass(processor.getWriteBehindResourceResponseWrapperClassName());
        List<String> list = processor.getExcludedAttributes();
        if (list != null) {
            ListIterator<String> i = list.listIterator();
            while (i.hasNext()) {
                String attr = i.next();
                if (this.mExcludedRequestAttributes.contains(attr)) continue;
                this.mExcludedRequestAttributes.add(attr);
            }
        }
    }

    private Class<? extends BridgeWriteBehindResponse> validateWrapperClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader.loadClass(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent event) {
        Locale l;
        UIViewRoot viewRoot;
        FacesContext context = event.getFacesContext();
        if (context != FacesContext.getCurrentInstance()) {
            return;
        }
        String pName = (String)context.getExternalContext().getRequestMap().get(PORTLET_NAME_ATTRIBUTE);
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW && (viewRoot = context.getViewRoot()) != null && (l = viewRoot.getLocale()) != null) {
            context.getExternalContext().getRequestMap().put(CACHED_VIEWROOT_LOCALE, l);
        }
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (context != FacesContext.getCurrentInstance()) {
            return;
        }
        String pName = (String)context.getExternalContext().getRequestMap().get(PORTLET_NAME_ATTRIBUTE);
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            UIViewRoot viewRoot;
            Locale l = (Locale)context.getExternalContext().getRequestMap().get(CACHED_VIEWROOT_LOCALE);
            if (l != null && (viewRoot = context.getViewRoot()) != null) {
                viewRoot.setLocale(l);
            }
            this.restoreFacesMessageState(context);
            boolean mappedPublicParams = false;
            if (context.getExternalContext().getRequestMap().get(PROCESSED_PUBLIC_PARAMS) == null) {
                mappedPublicParams = this.processIncomingPublicRenderParameters(context, (PortletRequest)context.getExternalContext().getRequest());
                context.getExternalContext().getRequestMap().put(PROCESSED_PUBLIC_PARAMS, Boolean.TRUE);
            }
            switch (BridgeUtil.getPortletRequestPhase()) {
                case RENDER_PHASE: 
                case EVENT_PHASE: {
                    if (mappedPublicParams) break;
                    context.renderResponse();
                }
            }
        }
    }

    private final class RequestScopeListener
    implements HttpSessionBindingListener {
        String mScopePrefix = null;

        public RequestScopeListener(String scopePrefix) {
            this.mScopePrefix = scopePrefix;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            BridgeImpl.this.removeRequestScopes(this.mScopePrefix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FacesMessageState
    implements Serializable {
        private static final long serialVersionUID = 8438070672451887050L;
        private LinkedHashMap<String, List<FacesMessage>> mMessages = new LinkedHashMap();

        private FacesMessageState() {
        }

        public void addMessage(String clientId, FacesMessage message) {
            List<FacesMessage> list = this.mMessages.get(clientId);
            if (list == null) {
                list = new ArrayList<FacesMessage>();
                this.mMessages.put(clientId, list);
            }
            list.add(message);
        }

        public List<FacesMessage> getMessages(String clientId) {
            List<FacesMessage> list = this.mMessages.get(clientId);
            if (list != null) {
                return list;
            }
            return Collections.emptyList();
        }

        public Set<String> getClientIds() {
            return this.mMessages.keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LRUMap
    extends LinkedHashMap<String, Map<String, Object>> {
        private static final long serialVersionUID = 4372455368577337965L;
        private int mMaxCapacity;

        public LRUMap(int maxCapacity) {
            super(maxCapacity, 1.0f, true);
            this.mMaxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Map<String, Object>> eldest) {
            if (this.size() > this.mMaxCapacity) {
                this.remove(eldest.getKey());
            }
            return false;
        }

        public Map<String, Object> remove(String key) {
            BridgeImpl.this.dumpScopeId(key, "RemovePhase");
            Map o = (Map)super.remove(key);
            if (o != null) {
                BridgeImpl.this.notifyPreDestroy(o);
            }
            return o;
        }

        @Override
        public Map<String, Object> put(String key, Map<String, Object> value) {
            return super.put(key, value);
        }
    }
}

