/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.config;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebConfigurationProcessor {
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private List<String> mMappings = null;

    public WebConfigurationProcessor(PortletContext context) {
        if (context != null) {
            this.scanForFacesMappings(context);
        }
    }

    public List<String> getFacesMappings() {
        return this.mMappings;
    }

    private void scanForFacesMappings(PortletContext context) {
        SAXParserFactory factory = this.getSAXFactory();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(context.getResourceAsStream(WEB_XML_PATH), (DefaultHandler)new WebXmlHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SAXParserFactory getSAXFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    private class WebXmlHandler
    extends DefaultHandler {
        private static final String SERVLET_ELEMENT = "servlet";
        private static final String SERVLET_NAME_ELEMENT = "servlet-name";
        private static final String SERVLET_CLASS_ELEMENT = "servlet-class";
        private static final String SERVLET_MAPPING_ELEMENT = "servlet-mapping";
        private static final String URL_PATTERN_ELEMENT = "url-pattern";
        private static final String FACES_SERVLET_DATA = "javax.faces.webapp.FacesServlet";
        private boolean mInServletElement = false;
        private boolean mInServletNameElement = false;
        private boolean mInServletClassElement = false;
        private boolean mInServletMappingElement = false;
        private boolean mInURLPatternElement = false;
        private String mName = null;
        private String mClass = null;
        private String mFacesServletName = null;
        private StringBuilder mContent;

        private WebXmlHandler() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean parseContent = false;
            if (SERVLET_ELEMENT.equals(localName)) {
                this.mInServletElement = true;
            } else if (SERVLET_MAPPING_ELEMENT.equals(localName)) {
                this.mInServletMappingElement = true;
            } else if (this.mInServletElement) {
                if (SERVLET_CLASS_ELEMENT.equals(localName)) {
                    parseContent = true;
                    this.mInServletClassElement = true;
                } else if (SERVLET_NAME_ELEMENT.equals(localName)) {
                    parseContent = true;
                    this.mInServletNameElement = true;
                }
            } else if (this.mInServletMappingElement) {
                if (URL_PATTERN_ELEMENT.equals(localName)) {
                    parseContent = true;
                    this.mInURLPatternElement = true;
                } else if (SERVLET_NAME_ELEMENT.equals(localName)) {
                    parseContent = true;
                    this.mInServletNameElement = true;
                }
            }
            if (parseContent) {
                this.mContent = new StringBuilder();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mContent != null) {
                this.mContent.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.mInServletClassElement) {
                this.mClass = this.mContent.toString().trim();
                this.mInServletClassElement = false;
            } else if (this.mInServletNameElement) {
                this.mName = this.mContent.toString().trim();
                this.mInServletNameElement = false;
            } else if (this.mInURLPatternElement) {
                if (this.mInServletMappingElement && this.mName != null && this.mFacesServletName != null && this.mName.equals(this.mFacesServletName)) {
                    if (WebConfigurationProcessor.this.mMappings == null) {
                        WebConfigurationProcessor.this.mMappings = new ArrayList();
                    }
                    WebConfigurationProcessor.this.mMappings.add(this.mContent.toString().trim());
                }
                this.mInURLPatternElement = false;
            } else if (SERVLET_ELEMENT.equals(localName)) {
                if (this.mName != null && this.mClass != null && this.mClass.equals(FACES_SERVLET_DATA)) {
                    this.mFacesServletName = this.mName;
                }
                this.mInServletElement = false;
            } else if (SERVLET_MAPPING_ELEMENT.equals(localName)) {
                this.mInServletMappingElement = false;
            }
            this.mContent = null;
        }
    }
}

