/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.map;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.myfaces.portlet.faces.util.map.PortletAbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSessionMap
extends PortletAbstractMap<Object> {
    private final PortletRequest mPortletRequest;
    private final int mScope;

    public PortletSessionMap(Object request) {
        if (request == null || !(request instanceof PortletRequest)) {
            throw new IllegalArgumentException("Only supported in a portlet environment");
        }
        this.mPortletRequest = (PortletRequest)request;
        this.mScope = 2;
    }

    public PortletSessionMap(Object request, int scope) {
        if (request == null || !(request instanceof PortletRequest)) {
            throw new IllegalArgumentException("Only supported in a portlet environment");
        }
        this.mPortletRequest = (PortletRequest)request;
        this.mScope = scope;
    }

    @Override
    protected Object getAttribute(String key) {
        if (this.mPortletRequest != null) {
            PortletSession portletSession = this.mPortletRequest.getPortletSession(true);
            return portletSession.getAttribute(key, this.mScope);
        }
        throw new IllegalArgumentException("Only supported in a portlet environment");
    }

    @Override
    protected void setAttribute(String key, Object value) {
        if (this.mPortletRequest != null) {
            this.mPortletRequest.getPortletSession(true).setAttribute(key, value, this.mScope);
        }
    }

    @Override
    protected void removeAttribute(String key) {
        PortletSession portletSession;
        if (this.mPortletRequest != null && (portletSession = this.mPortletRequest.getPortletSession(false)) != null) {
            portletSession.removeAttribute(key, this.mScope);
        }
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        if (this.mPortletRequest != null) {
            PortletSession portletSession = this.mPortletRequest.getPortletSession(false);
            if (portletSession == null) {
                List dummy = Collections.emptyList();
                return Collections.enumeration(dummy);
            }
            return portletSession.getAttributeNames(this.mScope);
        }
        throw new IllegalArgumentException("Only supported in a portlet environment");
    }
}

